@php

$meta_title = 'Aurobees | Change Password';

$meta_description = '';

$meta_keywords = '';

$add_class_header='show-nav';

$footer_sign_up_for_free_trial=true;

$active_page='setting';

@endphp

@extends('frontend.user.includes.master')

@section('body')

<div class="dashboard_bg">

    <section class="usr_dashboard_user">

        <div class="container">

            <div class="row">

                <div class="col-md-3"></div>

                <div class="col-md-9">

                    <div class="usr_dashboard_title">

                        <h1>Change Password</h1>

                        <div class="d-flex">

                            <div class="log_out_btn">

                                <a href="javascript:void(0);" onclick="$('#logout-form').submit();">Log Out</a>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="row">

                <div class="col-md-3">

                    @include('frontend.customer.includes.body.sidebar')

                </div>

                <div class="col-md-9">
                    <div class="scroll_screen">
                        <div class="dashboard_right user_setting">

                            <h4>Update Password</h4>

                            <form method="POST" name='customer_change_password' autocomplete="off"
                                action="{{ route('customer.change.password.store') }}">

                                @csrf

                                <div class="form_content_inner">

                                    <div class="form_group">

                                        <label for="">Current Password*</label>

                                        <div class="form_feild">

                                            <input type="password" name="old_password" id="old_password">

                                            <span class="password-toggle" onclick="togglePasswordVisibility()">

                                                <i id="eyeIcon" class="fa fa-eye"></i>

                                            </span>

                                            @error('old_password')

                                            <span class="text-danger">{{ $message }}</span>

                                            @enderror

                                        </div>

                                    </div>

                                    <div class="form_group">

                                        <label for="">New Password*</label>

                                        <div class="form_feild">

                                            <input type="password" name="password" id="password">

                                            <span class="password-toggle" onclick="togglePasswordVisibility1()">

                                                <i id="eyeIcon1" class="fa fa-eye"></i>

                                            </span>

                                            @error('password')

                                            <span class="text-danger">{{ $message }}</span>

                                            @enderror

                                        </div>

                                    </div>

                                    <div class="form_group">

                                        <label for="">Confirm New Password*</label>

                                        <div class="form_feild">

                                            <input type="password" name="confirm_password" id="confirm_password">

                                            <span class="password-toggle" onclick="togglePasswordVisibility2()">

                                                <i id="eyeIcon2" class="fa fa-eye"></i>

                                            </span>

                                            @error('confirm_password')

                                            <span class="text-danger">{{ $message }}</span>

                                            @enderror

                                        </div>

                                    </div>

                                    <div class="save_discard">

                                        <input type="reset" value="CLEAR ALL" class="discard_btn">

                                        <input type="submit" value="UPDATE PASSWORD" class="save_btn">

                                    </div>

                                </div>

                            </form>

                        </div>
                    </div>
                </div>

            </div>
            @include('frontend.customer.includes.body.help-center-mobile')
        </div>

    </section>

</div>

@endsection

@section('script')

<script>

    window.addEventListener('load', function () {

        @if (Session:: has('message'))

    AlertMassage(`<?= Session::get('message') ?>`);

    @endif

    });

</script>

<script>

    jQuery(function () {

        // Add custom password validation method

        jQuery.validator.addMethod("password", function (value, element) {

            let password = value;

            if (!(/^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.*[@#$%&])(.{8,14}$)/.test(password))) {

                return false;

            }

            return true;

        }, function (value, element) {

            let password = $(element).val();

            if (!(/^(.{8,14}$)/.test(password))) {

                return 'Password must be between 8 to 14 characters long.';

            } else if (!(/^(?=.*[A-Z])/.test(password))) {

                return 'Password must contain at least one uppercase letter.';

            } else if (!(/^(?=.*[a-z])/.test(password))) {

                return 'Password must contain at least one lowercase letter.';

            } else if (!(/^(?=.*[0-9])/.test(password))) {

                return 'Password must contain at least one digit.';

            } else if (!(/^(?=.*[@#$%&])/.test(password))) {

                return 'Password must contain at least one special character from @#$%&.';

            }

            return false;

        });



        jQuery("form[name='customer_change_password']").validate({

            rules: {

                old_password: {

                    required: true,

                    minlength: 8,

                    maxlength: 13,

                },

                password: {

                    required: true,

                    minlength: 8,

                    maxlength: 13,

                    password: true // Use the custom password validation method

                },

                confirm_password: {

                    required: true,

                    minlength: 8,

                    maxlength: 13,

                    equalTo: "#password"

                }

            },

            // Specify validation error messages

            messages: {

                old_password: {

                    required: "Please provide a password",

                    minlength: "Password must be between 8 to 12 characters long.",

                    maxlength: "Password must be between 8 to 12 characters long."

                },

                password: {

                    required: "Please provide a password",

                    minlength: "Password must be between 8 to 12 characters long.",

                    maxlength: "Password must be between 8 to 12 characters long."

                },

                confirm_password: {

                    required: "Please provide a password",

                    minlength: "Password must be between 8 to 12 characters long.",

                    equalTo: "Password does not match.",

                    maxlength: "Password must be between 8 to 12 characters long."

                }

            }

        });

    });

</script>

<script>

    function togglePasswordVisibility() {

        const passwordField = document.getElementById("old_password");

        const eyeIcon = document.getElementById("eyeIcon");



        if (passwordField.type === "password") {

            passwordField.type = "text";

            eyeIcon.classList.remove("fa-eye");

            eyeIcon.classList.add("fa-eye-slash");

        } else {

            passwordField.type = "password";

            eyeIcon.classList.remove("fa-eye-slash");

            eyeIcon.classList.add("fa-eye");

        }

    }



    function togglePasswordVisibility1() {

        const passwordField = document.getElementById("password");

        const eyeIcon = document.getElementById("eyeIcon1");



        if (passwordField.type === "password") {

            passwordField.type = "text";

            eyeIcon.classList.remove("fa-eye");

            eyeIcon.classList.add("fa-eye-slash");

        } else {

            passwordField.type = "password";

            eyeIcon.classList.remove("fa-eye-slash");

            eyeIcon.classList.add("fa-eye");

        }

    }



    function togglePasswordVisibility2() {

        const passwordField = document.getElementById("confirm_password");

        const eyeIcon = document.getElementById("eyeIcon2");



        if (passwordField.type === "password") {

            passwordField.type = "text";

            eyeIcon.classList.remove("fa-eye");

            eyeIcon.classList.add("fa-eye-slash");

        } else {

            passwordField.type = "password";

            eyeIcon.classList.remove("fa-eye-slash");

            eyeIcon.classList.add("fa-eye");

        }

    }

</script>

@endsection