
@php
$meta_title = $data->meta_title;
$meta_description = $data->meta_description;
$meta_keywords =  $data->meta_key;
//$add_class_header='show-nav';
function numberToWord($number) {
    $words = [
        1 => 'one',
        2 => 'two',
        3 => 'three',
        4 => 'four',
        5 => 'five',
        6 => 'six',
        7 => 'seven',
        8 => 'eight',
        9 => 'nine',
        10 => 'ten',
        11 => 'eleven',
        12 => 'twelve',
        13 => 'thirteen',
        14 => 'fourteen',
        15 => 'fifteen',
        16 => 'sixteen',
        17 => 'seventeen',
        18 => 'eighteen',
        19 => 'nineteen',
        20 => 'twenty'
    ];

    if (isset($words[$number])) {
        return $words[$number];
    } else {
        return 'unknown';
    }
}
@endphp
@extends('frontend.user.includes.master')
@section('body')
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
@if ($data->banner_image)
    <section class="banner__section payment_gatway one-line-text-box">
        <div id="baner_slider" class="carousel slide" data-bs-ride="carousel" data-interval="false">
            <div class="carousel-inner">
                <div class="carousel-item active">
                    <img src="{{url($data->banner_image)}}" class="w-100" alt="img">
                    <div class="carousel-caption">
                        <div class="container">
                            <div class="inner__content_-wrap">
                                <h1>{{$data->title}}</h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endif

<div class="container">
    <section class="form_wrap">
        <div class="row g-0">
            <div class="col-md-6">
                <div class="address__grid">
                    <div class="map_img">
                        <img src="{{url($data->map)}}" alt="map-img">
                    </div>
                    <div class="address_inner">
                        <h4><?=@$data->corporate_headquarters_text?></h4>
                        <div class="aurionpro__inner">
                            @if($data->link_link && $data->link_text)<h5><a href="<?=@$data->link_link?>"><?=@$data->link_text?></a></h5>@endif
                            <?=@$data->address?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="login_grid sign_up">
                    <div class="form_title">
                        <h2><?=@$data->lets_connect_text?></h2>
                    </div>
                    <form name="customer_registration" id="customer_registration" method="POST" autocomplete="off" action="{{route('general.page.contact-us.store')}}" >
                        @csrf
                        @if($data->first_name_text)
                            <div class="form_group">
                                <label for=""><?=@$data->first_name_text?><span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="text" name="f_name" id="f_name" placeholder="">
                                    @error('f_name')
                                        <span class="text-danger error-f-name">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        @endif
                        @if($data->last_name_text)
                            <div class="form_group">
                                <label for=""><?=@$data->last_name_text?><span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="text" name="l_name" id="l_name" placeholder="">
                                    @error('l_name')
                                        <span class="text-danger error-l-name">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        @endif
                        @if($data->email_text)
                            <div class="form_group">
                                <label for=""><?=@$data->email_text?><span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="email" name="email" id="email" placeholder="">
                                </div>
                            </div>
                            @error('email')
                                <span class="text-danger error-email"><?= $message ?></span>
                            @enderror
                        @endif
                        @if($data->phone_text)
                            <div class="form_group">
                                <label><?=@$data->phone_text?><span style="color: red;">*</span></label>
                                <div class="form_feild">
                                    <input type="hidden" name="calling_code" id="calling_code" >
                                    <input type="tel" id="mobile_code" class="form-control" placeholder="<?=@$data->phone_text?>" name="phone">
                                    @error('phone')
                                        <span class="text-danger error-phone">{{ $message }}</span>
                                    @enderror
                                    @error('calling_code')
                                        <span class="text-danger error-calling-code">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        @endif
                        <div class="form_group capta_img">
                            <div class="form_feild">
                                <div class="g-recaptcha" data-sitekey="<?=env("RECAPTCHA","6Lfd62QlAAAAAH-Fqd6ec9hH4apRfEN-VR1AbQ0l")?>"></div>
                                <div class="text-danger recaptcha-show-error">please click on the recaptcha box.</div>
                            </div>
                        </div>
                        <div class="form_group">
                            @if (Session::has('message1'))
                                <span class="error">{{ Session::get('message1') }}</span>
                            @endif
                            @if (Session::has('message'))
                                <span class="success">{{ Session::get('message') }}</span>
                            @endif
                        </div>
                        <div class="btn_grid">
                            <div class="form_feild">
                                <input type="submit" value="submit">
                            </div>
                            <div class="form_feild">
                                <button class="clear" onclick="document.getElementById('customer_registration').reset();">Clear All</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

@if($data['ContactUsGlobalOffices'])
    <section class="office_wrap">
        <div class="container">
            @php $p=1; $q=0; @endphp
            @foreach($data['ContactUsGlobalOffices'] as $global_office)
                @if($global_office->status=='Published')
                    <div class="state_text_title">
                        @if($p==1)<h4><?=@$data->global_offices_text?></h4>@endif
                        <h5><span><?=@$global_office->title?></span></h5>
                    </div>
                    @if(@$global_office['ContactUsGlobalOfficesAddress'])
                        @php $sizeOfArray=sizeof($global_office['ContactUsGlobalOfficesAddress']);
                            $sizeOfArray=($sizeOfArray>6)?'6':$sizeOfArray;
                        @endphp
                        <div class="stylish-banner">
                            <div class="fiveAnimted <?=($sizeOfArray==1)?'center-main-box':''?> <?=numberToWord(@$sizeOfArray);?>__box_effect">
                                <div class="d-flex">
                                    @php $i=1; @endphp
                                    @foreach($global_office['ContactUsGlobalOfficesAddress'] as $address)
                                        @php
                                            $q=($q==0)?'':$q;
                                            $div_id='';
                                            if($sizeOfArray-1==$i){
                                                $div_id='four'.$q;
                                            }elseif($sizeOfArray==$i){
                                                $div_id='five'.$q;
                                            }
                                        @endphp
                                        <div class="same {{numberToWord($i)}} <?=($sizeOfArray==1)?'center-address-box':''?>" id="<?=@$div_id?>" >
                                            <div class="inner_description1">
                                                <img src="{{url($address->image)}}" alt="img">
                                                <div class="detail-box-one art-info-box">
                                                    <div class="project-detail">
                                                        <div class="city_details">
                                                            <div class="city_address">
                                                                <h4><?php if($address->link){?> <a href="<?=@$address->link?>" target="_blank"> <?php } ?> {{$address->title}}<?php if($address->link){?></a><?php } ?></h4>
                                                                <?=@$address->description;?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="city__title">
                                                <h4>{{$address->title}}</h4>
                                            </div>
                                        </div>
                                        @php $i++; if($i>6){break;} @endphp
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                    @php $p++; $q++; @endphp
                @endif
            @endforeach
        </div>
    </section>
@endif
@endsection

@section('script')

<script>
    $('.recaptcha-show-error').hide();
        window.onload = function() {
            var recaptcha = document.querySelector('#g-recaptcha-response');
            if(recaptcha) {
                $('#g-recaptcha-response').attr("required", "required");
            }
        }
    //email
    jQuery(document).on('keypress', '#email', function(event) {
        jQuery('.error-email').hide();
        var regex = new RegExp("^[a-zA-Z.0-9.@]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });
    //Dealer Name
    jQuery(document).on('keypress', '#f_name', function(event) {
        jQuery('.error-f-name').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z ]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
        var phone_no=$('#f_name').val();
        if(phone_no.length>=40){
            return false;
        }
    });
    //Dealer Name
    jQuery(document).on('keypress', '#l_name', function(event) {
        jQuery('.error-l-name').hide();
        $(this).css({'text-transform': 'capitalize'});
        var regex = new RegExp("^[a-zA-Z ]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
        var phone_no=$('#l_name').val();
        if(phone_no.length>=40){
            return false;
        }
    });
    //phone
    jQuery(document).on('keypress', '#mobile_code', function(event) {
        jQuery('.error-phone').hide();
        jQuery('.error-calling-code').hide();
        var regex = new RegExp("^[0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }

    });

    $('body').on('click keydown keypress touchstart pointerdown', '.iti__country.iti__standard', function(){
        var code =$(this).attr('data-dial-code');
        $('#calling_code').val(code);
    });

    jQuery(function() {
        $.validator.addMethod("CallingCode", function(value, element) {
            return ($('#calling_code').val())?true:false;
        }, "Please select Calling code.");
        $.validator.addMethod("customEmail", function(value, element) {
            return this.optional(element) || /^[a-zA-Z0-9_.-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/i.test(value);
        }, "Please enter a valid email address.");
        jQuery("form[name='customer_registration']").validate({
            rules: {
                    f_name:{
                    required: true,
                    maxlength:41,
                    minlength:2
                },
                l_name:{
                    required: true,
                    maxlength:41,
                    minlength:2
                },
                email: {
                    required: true,
                    email: true,
                    customEmail: true
                },
                phone:{
                    CallingCode:true,
                    required:true,
                    digits:true
                }
            },
            // Specify validation error messages
            messages: {
                f_name:{
                required: "Please enter first name",
                maxlength: "First name must be less then 40 characters long.",
                minlength: "First name must be greater then 2 characters long."
                },
                l_name:{
                required: "Please enter last name",
                maxlength: "Last name must be less then 40 characters long.",
                minlength: "Last name must be greater then 2 characters long."
                },
                phone: {
                required: "Please enter phone number.",
                minlength: "Your phone number must be at least 10 digits long",
                maxlength: "Your phone number must be less or equal 15 digits long"
                },
                email: "Please enter a valid email address"
            },
            submitHandler: function(form) {
                if(grecaptcha.getResponse()){
                    form.submit();
                }else{
                    $('.recaptcha-show-error').show();
                }
            }
        });
    });
    
    $(document).ready(function() {
        $('.iti__selected-flag .iti__flag').addClass('dummy-flag-icon');
    });
</script>

@endsection
