@php
$meta_title = $categoryList->meta_title;
$meta_description = $categoryList->meta_description;
$meta_keywords =  $categoryList->meta_key;
$add_class_header='show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
<?php function NewsSingleRowData($news){ ?>
    <div class="media_box_inner">
        <div class="media_box_img">
            @if ($news->media_type=='Image' && $news->image)
                <img src="{{ url($news->image)}}" alt="img">
            @elseif($news->media_type=='Video')
                @if($news->video_type=='MP4' && $news->video)
                    <video width="100%" height="100%" autoplay muted loop>
                        <source src="{{ url($news->video)}}" type="video/mp4">
                    </video>
                @elseif ($news->video_type=='Youtube' && $news->youtube)
                    <iframe width="100%" height="100%" src="{{$news->youtube}}"></iframe>
                @endif
            @endif
        </div>
        <div class="media_box_img_title">
            @if ($news->language!='en' && $news->default_language_page && @$news['DefaultLanguagePage']['post_slug'])
                <a href="{{route('news.page.single',$news['DefaultLanguagePage']['post_slug'])}}">
            @elseif($news->post_slug)
                <a href="{{route('news.page.single',$news->post_slug)}}">
            @else
                <a href="">
            @endif
            <span>{{$news->post_title}}</span></a>
        </div>
    </div>
<?php } ?>
    <style>
        .hidden div p.text-sm.text-gray-700.leading-5{
            display: none;
        }
        nav.flex.items-center.justify-between div:first-child {
        display: none;
        }
        svg{
            max-height: 20px;
            max-width: 20px;
        }
        nav.flex.items-center.justify-between{
            width:100%;
            text-align: center;
        }
    </style>
    <section class="inner_page_grid">
        <div class="container">
            <div class="news_title">
                <h1>{{$categoryList->name}}</h1>
            </div>

            <div class="row media_new_grid">
                @php $data_lenght=sizeof($datas); $i=1; @endphp
                @foreach ($datas as $news )
                    @if($i==1)
                        <div class="col-md-8">
                            <?=NewsSingleRowData($news); ?>
                        </div>
                    @endif
                @if($i==2 || $i==3)
                    @if($i==2) <div class="col-md-4">@endif
                        <?=NewsSingleRowData($news); ?>
                    @if(($i==2 && $data_lenght==2) ||($i==3 && $data_lenght>=3))</div> @endif
                @endif
            @if( $i==4)</div>

            <div class="row news_media">@endif
                @if($i>=4)
                    <div class="col-md-4">
                        <?=NewsSingleRowData($news); ?>
                    </div>
                @endif
                @php $i++; @endphp
                @endforeach
            </div>
        </div>
    </section>

    <section class="">
        <div class="container">
            <div class="pagination__crum">
                {{ $datas->links() }}
            </div>
        </div>
    </section>
@endsection
@section('script')

@endsection

