@php
$meta_title = $data->meta_title;
$meta_description = $data->meta_description;
$meta_keywords =  $data->meta_key;
$add_class_header='show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
    <section class="inner_page_grid">
        <div class="container">
            @if($data->post_title)
                <div class="news_title">
                    <h1>{{$data->post_title}}</h1>
                </div>
            @endif

            <div class="media__img">
                @if ($data->media_type=='Image' && $data->image)
                    <img src="{{ url($data->image)}}"  alt="{{$data->post_title}}" title="{{$data->post_title}}">
                @elseif($data->media_type=='Video')
                    @if($data->video_type=='MP4' && $data->video)
                        <video width="100%" height="100%" autoplay muted loop>
                            <source src="{{ url($data->video)}}" type="video/mp4">
                        </video>
                    @elseif ($data->video_type=='Youtube' && $data->youtube)
                        <iframe width="100%" height="100%" src="{{$data->youtube}}"></iframe>
                    @endif
                @endif
            </div>

            <div class="media__description_grid">
                <div class="clander_link"><img src="{{ asset('frontend/images/clander_icon_new.png')}}" alt="img"><?=date('F d, Y',strtotime($data->created_at))?>, {{$data->location}}</div>
                <?=@$data->post_content ?>
                @if(@$data->pdf)
                    <div class="media-download-pdf">
                        <ul>
                            <li>
                                <a href="<?=url(@$data->pdf)?>" download="Download PDF.pdf">
                                    <div class="download-box">
                                        <div class="left-box">
                                            <div class="pdf-icon">
                                                <img src="{{url('frontend/images/pdf-icon.png')}}" alt="img">
                                            </div>
                                            <div class="pdf-content">
                                                <div class="pdf-title">
                                                    <h6>{{ HelperServiceProvider::GetLanguageText('download_pdf')}}.pdf</h6>
                                                </div>
                                                <div class="pdf-size">
                                                    <p>{{ HelperServiceProvider::GetLanguageText('download_pdf')}} • {{@$fileSize}}KB</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="right-box">
                                            <div class="download-icon">
                                                <img src="{{url('frontend/images/download-icon.png')}}" alt="img">
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>
                @endif
            </div>
            @if($datas)
                <div class="media__grid__box">
                    <div class="row">
                        @foreach ($datas as $news )
                            <div class="col-md-4">
                                <div class="media_box_inner">
                                    <div class="media_box_img">
                                        @if ($news->media_type=='Image' && $news->image)
                                            <img src="{{ url($news->image)}}" alt="img">
                                        @elseif($news->media_type=='Video')
                                            @if($news->video_type=='MP4' && $news->video)
                                                <video width="100%" height="100%" autoplay muted loop>
                                                    <source src="{{ url($news->video)}}" type="video/mp4">
                                                </video>
                                            @elseif ($news->video_type=='Youtube' && $news->youtube)
                                                <iframe width="100%" height="100%" src="{{$news->youtube}}"></iframe>
                                            @endif
                                        @endif
                                    </div>
                                    <div class="media_box_img_title">
                                        @if ($news->language!='en' && $news->default_language_page && @$news['DefaultLanguagePage']['post_slug'])
                                            <a href="{{route('news.page.single',$news['DefaultLanguagePage']['post_slug'])}}">
                                        @elseif($news->post_slug)
                                            <a href="{{route('news.page.single',$news->post_slug)}}">
                                        @else
                                            <a href="">
                                        @endif
                                        <span>{{$news->post_title}}</span></a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </section>
@endsection
@section('script')

@endsection

