@php
$footer_sign_up_for_free_trial=true;
$add_class_header='show-nav';
@endphp
@extends('frontend.user.includes.master')
@section('body')
@php
function limitSentence($sentence, $wordLimit) {
    $words = explode(" ", $sentence);
    if (count($words) > $wordLimit) {
        $limitedWords = array_slice($words, 0, $wordLimit);
        $limitedSentence = implode(" ", $limitedWords) . "...";
    } else {
        $limitedSentence = $sentence;
    }
    return $limitedSentence;
}
@endphp
@if($datas)
    <section class="blog_section">
        <div class="container">
            <div class="blog_heading">
                <h1>{{ HelperServiceProvider::GetLanguageText('all_blogs')}}</h1>
                <input type="hidden" value="{{$countPost}}" id="no_of_post">
            </div>
            <div class="blog_crum">
                <ul class="nav_list <?=(@$_GET['order']!='asc')?'active':''?>">
                    <li><a href="{{route('post.page.list')}}?order=desc">{{ HelperServiceProvider::GetLanguageText('newest')}} <img src="{{ asset('frontend/images/green_arrow.png')}}" alt="arrow_icons"></a></li>
                </ul>
                <ul class="nav_list <?=(@$_GET['order']=='asc')?'active':''?>">
                    <li><a href="{{route('post.page.list')}}?order=asc">{{ HelperServiceProvider::GetLanguageText('oldest')}} <img src="{{ asset('frontend/images/green_arrow.png')}}" alt="arrow_icons"></a></li>
                </ul>
            </div>
            <div class="row all_blog_wrap">
                <div class="col-md-9">
                    @foreach ($datas as $post)
                        <div class="outer_shadow">
                            <div class="blog__wrap">
                                <div class="full_blog_img">
                                    @if ($post->media_type=='Image' && $post->image)
                                        @if ($post->language!='en' && $post->default_language_page && @$post['DefaultLanguagePage']['post_slug'])
                                            <a href="{{route('post.page.single',$post['DefaultLanguagePage']['post_slug'])}}">
                                        @elseif($post->post_slug)
                                            <a href="{{route('post.page.single',$post->post_slug)}}">
                                        @else
                                            <a href="">
                                        @endif
                                            <img src="{{ url($post->image)}}"  alt="{{$post->post_title}}" title="{{$post->post_title}}">
                                        </a>
                                    @elseif($post->media_type=='Video')
                                        @if($post->video_type=='MP4' && $post->video)
                                            <video width="100%" height="100%" autoplay muted loop>
                                                <source src="{{ url($post->video)}}" type="video/mp4">
                                            </video>
                                        @elseif ($post->video_type=='Youtube' && $post->youtube)
                                            <iframe width="100%" height="100%" src="{{$post->youtube}}"></iframe>
                                        @endif
                                    @endif
                                </div>
                                <div class="full_blog_content">
                                    <h2>
                                        @if ($post->language !='en' && $post->default_language_page && @$post['DefaultLanguagePage']['post_slug'])
                                            <a href="{{route('post.page.single',$post['DefaultLanguagePage']['post_slug'])}}">
                                        @elseif($post->post_slug)
                                            <a href="{{route('post.page.single',$post->post_slug)}}">
                                        @else
                                            <a href="">
                                        @endif
                                            {{$post->post_title}}</a></h2>
                                    <p><?=limitSentence(@$post->post_content,20);?></p>
                                    <div class="post_bottom">
                                        <div class="blog_views">
                                            <a href="javascript:void(0);"><img src="{{ asset('frontend/images/eyes-icon.png')}}" alt="img"> {{$post->total_post_view}} views</a>
                                        </div>
                                        <div class="read_post">
                                            @php $word_count= str_word_count(@$post->post_content);
                                                $time=ceil($word_count/100);
                                                echo $time." min read";
                                            @endphp
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @php break; @endphp
                    @endforeach
                </div>
                <div class="col-md-3">
                    <div class="related_article" id="related_article">
                        <div class="article_title">
                            <h2>{{ HelperServiceProvider::GetLanguageText('related_articles')}}</h2>
                        </div>
                        @php $i=0; @endphp
                        @foreach ($datas as $post)
                            @php $i++; @endphp
                            @if($i==1) @continue; @endif
                            <div class="article_content">
                                <div class="date__title">
                                    <?=date('F d, Y',strtotime($post->created_at))?>
                                </div>
                                <h4>
                                    @if ($post->language !='en' && $post->default_language_page && @$post['DefaultLanguagePage']['post_slug'])
                                        <a href="{{route('post.page.single',$post['DefaultLanguagePage']['post_slug'])}}">
                                    @elseif($post->post_slug)
                                        <a href="{{route('post.page.single',$post->post_slug)}}">
                                    @else
                                        <a href="">
                                    @endif
                                        {{$post->post_title}}</a></h4>
                                <p><?=limitSentence(@$post->post_content,20);?></p>
                            </div>

                        @endforeach
                    </div>
                    <?php if($countPost>10){ ?>
                        <div class="load_more">
                            <a href="javascript:void(0)" id="loadMore" onClick="LoadMorePost()">{{ HelperServiceProvider::GetLanguageText('load_more')}}</a>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
@endif
@endsection
@section('script')
<script>
function LoadMorePost(){
    var dataShowDiv=$(".article_content").length +1;
    var no_of_post=$('#no_of_post').val();
    if(dataShowDiv<no_of_post){
        $.ajax({
            url: "{{route('post-data-load')}}",
            type: "POST",
            data: { _token : "<?php echo csrf_token() ?>", no_of_row: dataShowDiv, order:'<?=@$_GET['order']?>' },
            async: false,
            success: function(response) {
                if(response){
                    response.map((data) => {
                        var appenddata = `<div class="article_content">
                            <div class="date__title">
                                ${data.date}
                            </div>
                            <h4><a href="${data.link}">${data.title}</a></h4>
                            <p>${data.description}</p>
                        </div>`;
                        $('#related_article').append(appenddata);
                    });
                    var dataShowDiv=$(".article_content").length+1;
                    if(dataShowDiv>=no_of_post){
                        $('.load_more').hide();
                    }
                }else{
                    $('.load_more').hide();
                }
            }
        });
    }else{
        $('.load_more').hide();
    }
}
</script>
@endsection
