@php
$meta_title = $pricing->meta_title;
$meta_description = $pricing->meta_description;
$meta_keywords =  $pricing->meta_key;
@endphp
@extends('frontend.user.includes.master')
@section('body')
<section class="sub__banner__grid price__baner_height price-page-banner-section">
    <div class="sub__banner__img">
        @if($pricing->image)
            <img src="<?=url($pricing->image)?>" alt="img">
        @endif
    </div>
    <div class="sub_banner_wrap">
        <div class="container">
            <div class="sub_baaner_content">
               <?=@$pricing->content ?>
            </div>
        </div>
    </div>
</section>
@if ($plan_list)
{{-- --------mobile view------------ --}}
<section class="mobile__price_list">
    <div class="container">
        <div class="accordion" id="price_accordion">
            @foreach($plan_list as $key =>$plan)
                @if($plan->plan_type=='Free-Trial')
                    @php
                        $child_text=$pricing->free_trial_text;
                        $child_recommended='';
                        $ecom_minimum_order_text='';
                        $child_content=$pricing->free_trial_content;
                    @endphp
                    <form action="{{route('purchase-plan.store')}}" method="post" id="mobile-free-trial-form">
                        @csrf
                        <div class="free_trial @if($child_recommended) recommended_aft_sec @endif ">
                            <div class="price__div_middle">
                                <div class="price__title">
                                    <h6><?=@$child_text?></h6>
                                    <input type="hidden" name="page_id" value="<?=@$pricing->id ?>">
                                    <input type="hidden" name="child_page_id" value="<?=@$plan->id ?>">
                                </div>
                                <?=@$child_content?>
                            </div>
                            <div class="subscribe_div">
                                <a href="javascript:void(0);" onclick="formSubmit('mobile-free-trial-form');">{{ HelperServiceProvider::GetLanguageText('subscribe')}}</a>
                            </div>
                        </div>
                    </form>
                    <div class="accordion-item">
                        <button class="collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne">{{ HelperServiceProvider::GetLanguageText('feature')}}</button>
                        <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#price_accordion">
                            <div class="accordion-body">
                                <div class="table_price_list">
                                    <table class="table">
                                        <tbody>
                                            @foreach ($pricing_feature as $feature)
                                                <tr>
                                                    <td colspan="5">
                                                        <h4><?=$feature->name;?></h4>
                                                    </td>
                                                </tr>
                                                @foreach ($feature['PricingAddons'] as $addons)
                                                    @if($addons->status=='Published')
                                                        <tr>
                                                            <td>{{$addons->name}}</td>
                                                            @if($plan->plan_type=='Free-Trial')
                                                                <td>@if($addons->free_trial) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                                            @endif
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($plan->plan_type=='Basic')
                    @php
                        $child_text=$pricing->basic_text;
                        $child_recommended=$pricing->basic_recommended;
                        $ecom_minimum_order_text='';
                        $child_content=$pricing->basic_content;
                    @endphp
                    <form action="{{route('purchase-plan.store')}}" method="post" id="mobile-basic-form">
                        @csrf
                        <div class="basic_grid @if($child_recommended) recommended_aft_sec @endif">
                            <div class="border_box">
                                <div class="fixed__price__title">
                                    <h5><?=$child_text?></h5>
                                </div>
                                <div class="fixed__switcher">
                                    <div class="switches-container">
                                        <input type="radio" id="MTH_mobile1" name="switchPlan_basic_mobile" value="MTH" checked="checked" />
                                        <input type="radio" id="QTR_mobile1" name="switchPlan_basic_mobile" value="QTR" />
                                        <input type="radio" id="YLY_mobile1" name="switchPlan_basic_mobile" value="YLY" />
                                        <label for="MTH_mobile1">MTH</label>
                                        <label for="QTR_mobile1">QTR</label>
                                        <label for="YLY_mobile1">YLY</label>
                                        <div class="switch-wrapper">
                                            <div class="switch">
                                                <div>MTH</div>
                                                <div>QTR</div>
                                                <div>YLY</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="price__div_middle">
                                    <div class="price__title">
                                        <h6 id="basic-total-amount-mobile">{{$plan->currency}} <?=number_format($plan->monthly,2)?> @if($plan->plan_type!='Free-Trial') / Month @endif </h6>
                                        <input type="hidden" name="page_id" value="<?=@$pricing->id ?>">
                                        <input type="hidden" name="child_page_id" value="<?=@$plan->id ?>">
                                        <input type="hidden" name="plan_screen_view" value="basic-mobile">
                                    </div>
                                    <?=@$child_content ?>
                                </div>
                                <div class="number_counter">
                                    <div class="number_border">
                                        <p>{{ HelperServiceProvider::GetLanguageText('users')}}</p>
                                        <div class="number">
                                            <span class="minus">-</span>
                                            <input type="text" class="no-of-user" maxlength="2" name="no_of_user" id="basic-no-of-user-mobile" value="1" required/>
                                            <span class="plus">+</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="subscribe_div">
                                    <a href="javascript:void(0);" onclick="formSubmit('mobile-basic-form');">{{ HelperServiceProvider::GetLanguageText('subscribe')}}</a>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="accordion-item">
                        <button class="collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseTwo">{{ HelperServiceProvider::GetLanguageText('feature')}}</button>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#price_accordion">
                            <div class="accordion-body">
                                <div class="table_price_list">
                                    <table class="table">
                                        <tbody>
                                            @foreach ($pricing_feature as $feature)
                                                <tr>
                                                    <td colspan="5">
                                                        <h4><?=$feature->name;?></h4>
                                                    </td>
                                                </tr>
                                                @foreach ($feature['PricingAddons'] as $addons)
                                                    @if($addons->status=='Published')
                                                        <tr>
                                                            <td>{{$addons->name}}</td>
                                                            @if($plan->plan_type=='Basic')
                                                                <td>@if($addons->basic) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                                            @endif
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($plan->plan_type=='Advance')
                    @php
                        $child_text=$pricing->advance_text;
                        $child_recommended=$pricing->advance_recommended;
                        $ecom_minimum_order_text='';
                        $child_content=$pricing->advance_content;
                    @endphp
                    <form action="{{route('purchase-plan.store')}}" method="post" id="mobile-advance-form">
                        @csrf
                        <div class="Advanced_grid @if($child_recommended) recommended_aft_sec @endif">
                            <div class="border_box">
                                <div class="fixed__price__title">
                                    <h5><?=$child_text?></h5>
                                </div>
                                <div class="fixed__switcher">
                                    <div class="switches-container">
                                        <input type="radio" id="MTH_mobile2" name="switchPlan_advance_mobile" value="MTH" checked="checked" />
                                        <input type="radio" id="QTR_mobile2" name="switchPlan_advance_mobile" value="QTR" />
                                        <input type="radio" id="YLY_mobile2" name="switchPlan_advance_mobile" value="YLY" />
                                        <label for="MTH_mobile2">MTH</label>
                                        <label for="QTR_mobile2">QTR</label>
                                        <label for="YLY_mobile2">YLY</label>
                                        <div class="switch-wrapper">
                                            <div class="switch">
                                                <div>MTH</div>
                                                <div>QTR</div>
                                                <div>YLY</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="price__div_middle">
                                    <div class="price__title">
                                        <h6 id="advance-total-amount-mobile">{{$plan->currency}} <?=number_format($plan->monthly,2)?> @if($plan->plan_type!='Free-Trial') / Month @endif </h6>
                                        <input type="hidden" name="page_id" value="<?=@$pricing->id ?>">
                                        <input type="hidden" name="child_page_id" value="<?=@$plan->id ?>">
                                        <input type="hidden" name="plan_screen_view" value="advance-mobile">
                                    </div>
                                    <?=@$child_content ?>
                                </div>
                                <div class="number_counter">
                                    <div class="number_border">
                                        <p>{{ HelperServiceProvider::GetLanguageText('users')}}</p>
                                        <div class="number">
                                            <span class="minus">-</span>
                                            <input type="text" class="no-of-user" maxlength="2" name="no_of_user" id="advance-no-of-user-mobile" value="1" required />
                                            <span class="plus">+</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="subscribe_div">
                                    <a href="javascript:void(0);" onclick="formSubmit('mobile-advance-form');">{{ HelperServiceProvider::GetLanguageText('subscribe')}}</a>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="accordion-item">
                        <button class="collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseThree">
                            {{ HelperServiceProvider::GetLanguageText('feature')}}
                        </button>
                        <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#price_accordion">
                            <div class="accordion-body">
                                <div class="table_price_list">
                                    <table class="table">
                                        <tbody>
                                            @foreach ($pricing_feature as $feature)
                                                <tr>
                                                    <td colspan="5">
                                                        <h4><?=$feature->name;?></h4>
                                                    </td>
                                                </tr>
                                                @foreach ($feature['PricingAddons'] as $addons)
                                                    @if($addons->status=='Published')
                                                        <tr>
                                                            <td>{{$addons->name}}</td>
                                                            @if($plan->plan_type=='Advance')
                                                                <td>@if($addons->advance) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                                            @endif
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @elseif($plan->plan_type=='Ecommerce')
                    @php
                        $child_text=$pricing->ecom_text;
                        $child_recommended=$pricing->ecom_recommended;
                        $ecom_minimum_order_text=$pricing->ecom_minimum_order_text;
                        $child_content=$pricing->ecom_content;
                    @endphp
                    <form action="{{route('purchase-plan.store')}}" method="post" id="mobile-ecommerce-form">
                        @csrf
                        <div class="go_ecommerce_grid @if($child_recommended) recommended_aft_sec @endif">
                            <div class="border_box">
                                <div class="fixed__price__title">
                                    <h5><?=$child_text?></h5>
                                </div>
                                <div class="fixed__switcher">
                                    <div class="switches-container">
                                        <input type="radio" id="MTH_mobile3" name="switchPlan_ecommerce_mobile" value="MTH" checked="checked" />
                                        <input type="radio" id="QTR_mobile3" name="switchPlan_ecommerce_mobile" value="QTR" />
                                        <input type="radio" id="YLY_mobile3" name="switchPlan_ecommerce_mobile" value="YLY" />
                                        <label for="MTH_mobile3">MTH</label>
                                        <label for="QTR_mobile3">QTR</label>
                                        <label for="YLY_mobile3">YLY</label>
                                        <div class="switch-wrapper">
                                            <div class="switch">
                                                <div>MTH</div>
                                                <div>QTR</div>
                                                <div>YLY</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="price__div_middle">
                                    <div class="price__title">
                                        <h6 id="ecommerce-total-amount-mobile">{{$plan->currency}} <?=number_format($plan->monthly,2)?>@if($plan->plan_type!='Free-Trial') / Month @endif</h6>
                                        <input type="hidden" name="page_id" value="<?=@$pricing->id ?>">
                                        <input type="hidden" name="child_page_id" value="<?=@$plan->id ?>">
                                        <input type="hidden" name="plan_screen_view" value="ecommerce-mobile">
                                    </div>
                                    <?=@$child_content ?>
                                </div>

                                <div class="number_counter">
                                    <p><?=@$ecom_minimum_order_text ?></p>
                                </div>
                                <div class="subscribe_div">
                                    <a href="javascript:void(0);" onclick="formSubmit('mobile-ecommerce-form');">{{ HelperServiceProvider::GetLanguageText('subscribe')}}</a>
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="accordion-item">
                        <button class="collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseFour">{{ HelperServiceProvider::GetLanguageText('feature')}}</button>
                        <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#price_accordion">
                            <div class="accordion-body">
                                <div class="table_price_list">
                                    <table class="table">
                                        <tbody>
                                            @foreach ($pricing_feature as $feature)
                                                <tr>
                                                    <td colspan="5">
                                                        <h4><?=$feature->name;?></h4>
                                                    </td>
                                                </tr>
                                                @foreach ($feature['PricingAddons'] as $addons)
                                                    @if($addons->status=='Published')
                                                        <tr>
                                                            <td>{{$addons->name}}</td>
                                                            @if($plan->plan_type=='Ecommerce')
                                                                <td>@if($addons->go_ecommerce) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                                            @endif
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endforeach
        </div>
    </div>
</section>
{{-- --------end mobile view------------ --}}

@php
$sizeofDiv=sizeof($plan_list);
if($sizeofDiv==2){
    $add_class='two-items';
}elseif($sizeofDiv==3){
    $add_class='three-items';
}else{
    $add_class='';
}
@endphp

<section class="price-upper-div <?=@$add_class?> ">
    <div class="price__box_wrap">
        <div class="container">
            <div class="price__box_grid">
                @foreach($plan_list as $key =>$plan)
                    @php
                        if($plan->plan_type=='Free-Trial'){
                            $child_text=$pricing->free_trial_text;
                            $child_recommended='';
                            $ecom_minimum_order_text='';
                            $child_content=$pricing->free_trial_content;
                        }elseif($plan->plan_type=='Basic'){
                            $child_text=$pricing->basic_text;
                            $child_recommended=$pricing->basic_recommended;
                            $ecom_minimum_order_text='';
                            $child_content=$pricing->basic_content;
                        }elseif($plan->plan_type=='Advance'){
                            $child_text=$pricing->advance_text;
                            $child_recommended=$pricing->advance_recommended;
                            $ecom_minimum_order_text='';
                            $child_content=$pricing->advance_content;
                        }elseif($plan->plan_type=='Ecommerce'){
                            $child_text=$pricing->ecom_text;
                            $child_recommended=$pricing->ecom_recommended;
                            $ecom_minimum_order_text=$pricing->ecom_minimum_order_text;
                            $child_content=$pricing->ecom_content;
                        }
                    @endphp
                    <div class="price__box__inner @if($child_recommended) recommended_aft_sec @endif">
                        <form action="{{route('purchase-plan.store')}}" method="post" id="{{$plan->plan_type}}-form">
                            @csrf
                            <div class="border_box">
                                <div class="fixed__price__title">
                                    <h5><?=$child_text?></h5>
                                </div>
                                <div class="fixed__switcher">
                                    @if($plan->plan_type!='Free-Trial')
                                        <div class="switches-container">
                                            <input type="radio" id="MTH{{$plan->plan_type}}" name="switchPlan{{$plan->plan_type}}" value="MTH" checked="checked" />
                                            <input type="radio" id="QTR{{$plan->plan_type}}" name="switchPlan{{$plan->plan_type}}" value="QTR" />
                                            <input type="radio" id="YLY{{$plan->plan_type}}" name="switchPlan{{$plan->plan_type}}" value="YLY" />
                                            <label for="MTH{{$plan->plan_type}}">MTH</label>
                                            <label for="QTR{{$plan->plan_type}}">QTR</label>
                                            <label for="YLY{{$plan->plan_type}}">YLY</label>
                                            <div class="switch-wrapper">
                                                <div class="switch">
                                                    <div>MTH</div>
                                                    <div>QTR</div>
                                                    <div>YLY</div>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>

                                <div class="price__div_middle">
                                    <div class="price__title">
                                        <h6 id="{{$plan->plan_type}}-total-amount">{{$plan->currency}} <?=number_format($plan->monthly,2)?> @if($plan->plan_type!='Free-Trial') / Month @endif </h6>
                                        <input type="hidden"  id="{{$plan->plan_type}}_price_mth" value="{{$plan->monthly}}">
                                        <input type="hidden"  id="{{$plan->plan_type}}_price_qtr" value="{{$plan->quaterly}}">
                                        <input type="hidden"  id="{{$plan->plan_type}}_price_yly" value="{{$plan->yearly}}">
                                        <input type="hidden"  class="currency" value="{{$plan->currency}}">
                                        <input type="hidden"  value="<?=@$plan->country_code ?>">
                                        <input type="hidden" name="page_id" value="<?=@$pricing->id ?>">
                                        <input type="hidden" name="child_page_id" value="<?=@$plan->id ?>">
                                    </div>
                                    <?=@$child_content ?>
                                </div>
                                @if($plan->plan_type!='Free-Trial')
                                    <div class="number_counter">
                                        @if($plan->plan_type!='Ecommerce' )
                                            <div class="number_border">
                                                <p>{{ HelperServiceProvider::GetLanguageText('users')}}</p>
                                                <div class="number">
                                                    <span class="minus">-</span>
                                                    <input type="text" class="no-of-user" maxlength="2" name="no_of_user" id="{{$plan->plan_type}}-no-of-user" value="1" required />
                                                    <span class="plus">+</span>
                                                </div>
                                            </div>
                                        @elseif($plan->plan_type=='Ecommerce')
                                            <p><?=@$ecom_minimum_order_text ?></p>
                                        @endif
                                    </div>
                                @endif
                                <div class="subscribe_div">
                                    <a href="javascript:void(0);" onclick="formSubmit('{{$plan->plan_type}}-form');">{{ HelperServiceProvider::GetLanguageText('subscribe')}}</a>
                                </div>
                            </div>
                        </form>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <div>
        <div class="container">
            <div class="table_price_list">
                <table class="table">
                    <thead>
                        <tr>
                            <th>{{ HelperServiceProvider::GetLanguageText('feature')}}</th>
                            @foreach($plan_list as $key =>$plan)
                                <th>@if($plan->plan_type=='Free-Trial'){{ HelperServiceProvider::GetLanguageText('free_trial')}} @elseif($plan->plan_type=='Basic'){{ HelperServiceProvider::GetLanguageText('basic')}} @elseif($plan->plan_type=='Advance'){{ HelperServiceProvider::GetLanguageText('advanced')}} @elseif($plan->plan_type=='Ecommerce'){{ HelperServiceProvider::GetLanguageText('enable-e-commerce')}} @endif </th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pricing_feature as $feature)
                            <tr>
                                <td colspan="<?=@$sizeofDiv+1?>">
                                    <h4><?=$feature->name;?></h4>
                                </td>
                            </tr>
                            @foreach ($feature['PricingAddons'] as $addons)
                                @if($addons->status=='Published')
                                    <tr>
                                        <td>{{$addons->name}}</td>
                                        @foreach($plan_list as $key =>$plan)
                                            @if($plan->plan_type=='Free-Trial')
                                                <td>@if($addons->free_trial) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                            @elseif($plan->plan_type=='Basic')
                                                <td>@if($addons->basic) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                            @elseif($plan->plan_type=='Advance')
                                                <td>@if($addons->advance) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                            @elseif($plan->plan_type=='Ecommerce')
                                                <td>@if($addons->go_ecommerce) <img src="{{ asset('frontend/images/right-tick.png')}}" alt="right-tick"> @else <img src="{{ asset('frontend/images/dash-img.png')}}" alt=""> @endif   </td>
                                            @endif
                                        @endforeach
                                    </tr>
                                @endif
                            @endforeach
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
@endif
@endsection
@section('script')
<script>
    $('.accordion-collapse').on('shown.bs.collapse', function (e) {
        var $panel = $(this).closest('.accordion-item');
        $('html,body').animate({
            scrollTop: $panel.offset().top
        }, 500);
    });
</script>
<script>
    //basic
    $('[name="switchPlanBasic"]').click(function(){
        if($(this).val()=='MTH'){
            var price=$('#Basic_price_mth').val();
            var priceType=' / Month';
        }else if($(this).val()=='QTR'){
            var price=parseFloat(parseFloat($('#Basic_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if($(this).val()=='YLY'){
            var price=parseFloat(parseFloat($('#Basic_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#Basic-no-of-user').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#Basic-total-amount').html(basic_currency+' '+total_price+priceType);
    });
    $('#Basic-no-of-user').change(function(){
        var select_type=$('[name="switchPlanBasic"]:checked').val();
        if(select_type=='MTH'){
            var price=$('#Basic_price_mth').val();
            var priceType=' / Month';
        }else if(select_type=='QTR'){
            var price=parseFloat(parseFloat($('#Basic_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if(select_type=='YLY'){
            var price=parseFloat(parseFloat($('#Basic_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#Basic-no-of-user').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#Basic-total-amount').html(basic_currency+' '+total_price+priceType);
    });

    //Advance
    $('[name="switchPlanAdvance"]').click(function(){
        if($(this).val()=='MTH'){
            var price=$('#Advance_price_mth').val();
            var priceType=' / Month';
        }else if($(this).val()=='QTR'){
            var price=parseFloat(parseFloat($('#Advance_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if($(this).val()=='YLY'){
            var price=parseFloat(parseFloat($('#Advance_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#Advance-no-of-user').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#Advance-total-amount').html(basic_currency+' '+total_price+priceType);
    });
    $('#Advance-no-of-user').change(function(){
        var select_type=$('[name="switchPlanAdvance"]:checked').val();
        if(select_type=='MTH'){
            var price=$('#Advance_price_mth').val();
            var priceType=' / Month';
        }else if(select_type=='QTR'){
            var price=parseFloat(parseFloat($('#Advance_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if(select_type=='YLY'){
            var price=parseFloat(parseFloat($('#Advance_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#Advance-no-of-user').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#Advance-total-amount').html(basic_currency+' '+total_price+priceType);
    });

    //Ecommerce
    $('[name="switchPlanEcommerce"]').click(function(){
        if($(this).val()=='MTH'){
            var price=$('#Ecommerce_price_mth').val();
            var priceType=' / Month';
        }else if($(this).val()=='QTR'){
            var price=parseFloat(parseFloat($('#Ecommerce_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if($(this).val()=='YLY'){
            var price=parseFloat(parseFloat($('#Ecommerce_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var total_price=parseFloat(price);
        var currency=$('.currency').val();
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#Ecommerce-total-amount').html(currency+' '+ total_price+priceType);
    });
</script>
<script>
    //mobile-----------------------------------------------------------------------
    //basic
    $('[name="switchPlan_basic_mobile"]').click(function(){
        if($(this).val()=='MTH'){
            var price=$('#Basic_price_mth').val();
            var priceType=' / Month';
        }else if($(this).val()=='QTR'){
            var price=parseFloat(parseFloat($('#Basic_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if($(this).val()=='YLY'){
            var price=parseFloat(parseFloat($('#Basic_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#basic-no-of-user-mobile').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#basic-total-amount-mobile').html(basic_currency+' '+total_price+priceType);
    });
    $('#basic-no-of-user-mobile').change(function(){
        var select_type=$('[name="switchPlan_basic_mobile"]:checked').val();
        if(select_type=='MTH'){
            var price=$('#Basic_price_mth').val();
            var priceType=' / Month';
        }else if(select_type=='QTR'){
            var price=parseFloat(parseFloat($('#Basic_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if(select_type=='YLY'){
            var price=parseFloat(parseFloat($('#Basic_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#basic-no-of-user-mobile').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#basic-total-amount-mobile').html(basic_currency+' '+total_price+priceType);
    });

    //Advance
    $('[name="switchPlan_advance_mobile"]').click(function(){
        if($(this).val()=='MTH'){
            var price=$('#Advance_price_mth').val();
            var priceType=' / Month';
        }else if($(this).val()=='QTR'){
            var price=parseFloat(parseFloat($('#Advance_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if($(this).val()=='YLY'){
            var price=parseFloat(parseFloat($('#Advance_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#advance-no-of-user-mobile').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#advance-total-amount-mobile').html(basic_currency+' '+total_price+priceType);
    });
    $('#advance-no-of-user-mobile').change(function(){
        var select_type=$('[name="switchPlan_advance_mobile"]:checked').val();
        if(select_type=='MTH'){
            var price=$('#Advance_price_mth').val();
            var priceType=' / Month';
        }else if(select_type=='QTR'){
            var price=parseFloat(parseFloat($('#Advance_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if(select_type=='YLY'){
            var price=parseFloat(parseFloat($('#Advance_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var user=$('#advance-no-of-user-mobile').val();
        var basic_currency=$('.currency').val();
        var total_price=parseFloat(price*user);
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#advance-total-amount-mobile').html(basic_currency+' '+total_price+priceType);
    });

    //Ecommerce
    $('[name="switchPlan_ecommerce_mobile"]').click(function(){
        if($(this).val()=='MTH'){
            var price=$('#Ecommerce_price_mth').val();
            var priceType=' / Month';
        }else if($(this).val()=='QTR'){
            var price=parseFloat(parseFloat($('#Ecommerce_price_qtr').val())/3).toFixed(2);
            var priceType=' / Month';
        }else if($(this).val()=='YLY'){
            var price=parseFloat(parseFloat($('#Ecommerce_price_yly').val())/12).toFixed(2);
            var priceType=' / Month';
        }
        var total_price=parseFloat(price);
        var currency=$('.currency').val();
        var total_price1=total_price.toFixed(2);
        var total_price= total_price1.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        $('#ecommerce-total-amount-mobile').html(currency+' '+ total_price+priceType);
    });
</script>
<script>
    $(document).ready(function() {
      // Bind the keydown event to the input field with class "no-of-user"
      $(".no-of-user").on("keydown", function(e) {
        // Allow only numeric input and certain control keys (e.g., backspace, delete)
        if (
          !(
            (e.keyCode >= 48 && e.keyCode <= 57) || // Numeric keys
            (e.keyCode >= 96 && e.keyCode <= 105) || // Numeric keypad keys
            e.keyCode === 8 || // Backspace
            e.keyCode === 9 || // Tab
            e.keyCode === 46 || // Delete
            e.keyCode === 37 || // Left arrow
            e.keyCode === 39 // Right arrow
          )
        ) {
          // Prevent any other key from being entered
          e.preventDefault();
        }

        // Get the current value of the input field
        const currentValue = $(this).val();

        // Parse the value to an integer
        const numberValue = parseInt(currentValue);

        // Check if the number is within the desired range (1 to 99)
        if (isNaN(numberValue) || numberValue < 1 || numberValue > 99) {
          // If the number is not within the range, set the input value to 1
         // $(this).val(1);
        }
      });
    });
</script>
<script>
    function formSubmit(plan_type) {
        if ($('form#' + plan_type).find('input.no-of-user').length > 0) {
            var inputData = $('form#' + plan_type).find('input.no-of-user').val();
            if ($.isNumeric(inputData) && inputData >= 1 && inputData <= 99) {
                $('#' + plan_type).submit();
            } else {
                // Input data is not numeric or not within the range
                return false;
            }
        } else {
            // No input field with class 'no-of-user' found
            $('#' + plan_type).submit();
        }
    }

</script>
@endsection
