<?php
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\frontend\HomeController;
use App\Http\Controllers\frontend\IndustryPageController;
use App\Http\Controllers\frontend\FinancialServicesPageController;
use App\Http\Controllers\frontend\PricePageController;

use App\Http\Controllers\backend\UserController;
use App\Http\Controllers\backend\page\contact_us\ContactFormDataShow;
use App\Http\Controllers\backend\CustomerManagementController;
use App\Http\Controllers\backend\BlogCategoryController;
use App\Http\Controllers\backend\EmailManagementController;
use App\Http\Controllers\backend\PostController;
use App\Http\Controllers\backend\LatestNewsController;
use App\Http\Controllers\backend\operation\LobBillingDetailController;
use App\Http\Controllers\backend\operation\LobSubscriptionDetailController;
use App\Http\Controllers\backend\page\contact_us\ContactUsController;
use App\Http\Controllers\backend\page\contact_us\ContactUsGlobalOfficesAddressController;
use App\Http\Controllers\backend\page\contact_us\ContactUsGlobalOfficesController;
use App\Http\Controllers\backend\page\event\EventController;
use App\Http\Controllers\backend\page\event\EventDateController;
use App\Http\Controllers\backend\page\event\EventFormDataController;
use App\Http\Controllers\backend\PricingController;

use App\Http\Controllers\backend\page\financial_service\FinancialServicesCardController;
use App\Http\Controllers\backend\page\financial_service\FinancialServicesController;
use App\Http\Controllers\backend\page\financial_service\FinancialServicesServiceController;
use App\Http\Controllers\backend\page\financial_service\BusinessPaymentPlatformsController;
use App\Http\Controllers\backend\page\general_page\GeneralPageManagemnt;
use App\Http\Controllers\backend\page\general_page\LabelManagementController;
use App\Http\Controllers\backend\page\general_page\vission_mission\VissionAndMissionController;
use App\Http\Controllers\backend\page\general_page\vission_mission\VissionAndMissionFeatureController;
use App\Http\Controllers\backend\page\general_page\vission_mission\VissionAndMissionOurCoreValuesController;
use App\Http\Controllers\backend\page\go_online\GoOnlineCreateWebsiteController;
use App\Http\Controllers\backend\page\go_online\GoOnlineCreateWebsiteFeaturesController;
use App\Http\Controllers\backend\page\go_online\GoOnlineCreateWebsiteThemeController;
use App\Http\Controllers\backend\page\go_online\GoOnlineDigitalMarketingServicesBenefitsController;
use App\Http\Controllers\backend\page\go_online\GoOnlineDigitalMarketingServicesController;
use App\Http\Controllers\backend\page\go_online\GoOnlineDigitalMarketingServicesFeaturesController;
use App\Http\Controllers\backend\page\home\HomeBrandsController;
use App\Http\Controllers\backend\page\home\HomeCloudController;
use App\Http\Controllers\backend\page\home\HomeCustomersDeriveController;
use App\Http\Controllers\backend\page\home\HomeFeaturesController;
use App\Http\Controllers\backend\page\home\HomeIndustriesController;
use App\Http\Controllers\backend\page\home\HomeIntegratedSupplyController;
use App\Http\Controllers\backend\page\home\HomeOurServicesController;
use App\Http\Controllers\backend\page\home\HomeSliderController;
use App\Http\Controllers\backend\page\home\HomeSectionController;
use App\Http\Controllers\backend\page\home\HomeSliderAutoController;
use App\Http\Controllers\backend\page\industries\IndustriesCategoryController;
use App\Http\Controllers\backend\page\industries\IndustriesController;
use App\Http\Controllers\backend\page\industries\IndustriesKeyOfferingsController;
use App\Http\Controllers\backend\page\industries\IndustriesServiceController;
use App\Http\Controllers\backend\page\partner\ParentPageController;
use App\Http\Controllers\backend\PartnerManagementAdminController;
use App\Http\Controllers\backend\PricingAddonsController;
use App\Http\Controllers\backend\PricingFeatureController;
use App\Http\Controllers\backend\setting\CurrencyController;
use App\Http\Controllers\backend\setting\EmailNotificationManagementController;
use App\Http\Controllers\backend\setting\ForgotPasswordPageManagementController;
use App\Http\Controllers\backend\setting\GSTController;
use App\Http\Controllers\backend\setting\PaymentGatewayKeyManagementController;
use App\Http\Controllers\backend\setting\HeaderManagementController;
use App\Http\Controllers\backend\setting\MessageManagementController;
use App\Http\Controllers\Dashboard;
use App\Http\Controllers\frontend\CustomerController;
use App\Http\Controllers\frontend\GeneralPageManageemntController;

use App\Http\Controllers\frontend\become_a_partner\BecomeAPartnerRegistrationController ;
use App\Http\Controllers\frontend\become_a_partner\PartnerProfileController;
use App\Http\Controllers\frontend\become_a_partner\BillingPartnerController;
use App\Http\Controllers\frontend\become_a_partner\PartnerCustomerManagement;
use App\Http\Controllers\frontend\become_a_partner\PartnerSettingController;
use App\Http\Controllers\frontend\customer\CustomerBillingController;
use App\Http\Controllers\frontend\customer\CustomerProfileController;
use App\Http\Controllers\frontend\customer\CustomerSettingController;
use App\Http\Controllers\frontend\customer\CustomerSubscriptionController;
use App\Http\Controllers\frontend\GoOnlinePageController;
use App\Http\Controllers\frontend\NewsPageController;
use App\Http\Controllers\frontend\PostPageController;

use App\Http\Controllers\frontend\operation\CheckoutPageController;
use App\Http\Controllers\frontend\operation\PlanPurchaseController;
use App\Http\Controllers\frontend\operation\SubscriptionUpgradePaidController;
use App\Http\Controllers\frontend\operation\TransactionsPageController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::group(['middleware' => 'prevent-back-history'],function(){
    // Clear application cache:
    Route::get('/clear-cache', function() {
        Artisan::call('cache:clear');
        return 'Application cache has been cleared';
    });

    //Clear route cache:
    Route::get('/route-cache', function() {
        Artisan::call('route:cache');
        return 'Routes cache has been cleared';
    });

    //Clear config cache:
    Route::get('/config-cache', function() {
        Artisan::call('config:cache');
        return 'Config cache has been cleared';
    });

    // Clear view cache:
    Route::get('/view-clear', function() {
        Artisan::call('view:clear');
        return 'View cache has been cleared';
    });
    // Clear view cache:
     Route::get('/clear', function() {
        Artisan::call('view:clear');
        Artisan::call('cache:clear');
        Artisan::call('route:cache');
        Artisan::call('config:cache');
        return "All Cache Clear";
    });

    Route::post('user/login',[Dashboard::class,'login'])->name('login-test');

    Route::get('/',[HomeController::class,'Home'])->name('home');
    Route::get('industry/{slug}',[IndustryPageController::class,'Industry'])->name('industry.page.view');
    Route::get('financial-service/{slug}',[FinancialServicesPageController::class,'FinancialService'])->name('financial-service.page.view');
    Route::get('pricing/{slug}',[PricePageController::class,'Price'])->name('price.page.view');
    Route::get('go-online/{slug}',[GoOnlinePageController::class,'GoOnline'])->name('go-online.page.view');
    Route::get('page/{slug}',[GeneralPageManageemntController::class,'index'])->name('general.page.view');
    Route::post('page/contact-us/store',[GeneralPageManageemntController::class,'ContactUsStore'])->name('general.page.contact-us.store');
    Route::post('page/event/store',[GeneralPageManageemntController::class,'EventStore'])->name('general.page.event.store');
    Route::get('news',[NewsPageController::class,'List'])->name('news.page.list');
    Route::get('news/category/{slug}',[NewsPageController::class,'Category'])->name('news.category.page.list');
    Route::get('news/{slug}',[NewsPageController::class,'Single'])->name('news.page.single');
    Route::get('blog',[PostPageController::class,'List'])->name('post.page.list');
    Route::get('blog/{slug}',[PostPageController::class,'Single'])->name('post.page.single');
    Route::post('post-data-load',[PostPageController::class,'ListAjax'])->name('post-data-load');
    Route::post('post-data-add-like',[PostPageController::class,'addRemoveLike'])->name('post-data-add-like');
    Route::post('post-data-add-comment',[PostPageController::class,'commentStore'])->name('post-data-add-comment');

    Route::get('lang/change', [LanguageController::class, 'change'])->name('changeLang');

    Route::get('login', function () {
        if (auth()->check()) { // Check if the user is authenticated
            return redirect()->route('dashboard'); // Redirect to the dashboard route
        } else {
            return view('frontend.new_user.login'); // Show the login view
        }
    })->name('login');
    Route::get('/transactions/callbackauropay', [TransactionsPageController::class, 'callbackauropay'])->name('callbackauropay');

    Route::POST('account/otp', [CustomerController::class, 'verifyOtpAccount'])->name('customer.otp');//registration otp
    Route::POST('account-otp', [CustomerController::class, 'verifyOtpAccountAjax'])->name('customer.otp.ajax');//registration otp
    Route::get('account/verify/{token}/{email}', [CustomerController::class, 'verifyAccount'])->name('user.verify');  // mail link
    Route::get('account/resend-otp', [CustomerController::class, 'ResendOtp'])->name('resend.otp');         //resend email otp view
    Route::post('account/resend-otp', [CustomerController::class, 'ResendOtpEmail'])->name('resend.otp.email');   //send otp
    Route::post('account/resend-otp-check', [CustomerController::class, 'ResendOtpEmailCheckAjax'])->name('resend.otp.email.check.ajax');   //email check
    Route::post('account-resend-otp', [CustomerController::class, 'ResendOtpEmailAjax'])->name('resend.otp.email.ajax');   //send otp

    Route::get('forget-password', [ForgotPasswordController::class, 'showForgetPasswordForm'])->name('forget.password.get');
    Route::post('forget-password', [ForgotPasswordController::class, 'submitForgetPasswordForm'])->name('forget.password.post');
    Route::post('forget_password', [ForgotPasswordController::class, 'submitForgetPasswordFormAjax'])->name('forget.password.post.ajax');
    Route::post('forget-password/otp', [ForgotPasswordController::class, 'ForgetPasswordOtp'])->name('forget-password.otp');
    Route::get('change/password', [ForgotPasswordController::class, 'ChangePassword'])->name('change-password.add'); //case of forgot password
    Route::post('change/password', [ForgotPasswordController::class, 'ChangePasswordStore'])->name('change-password.store'); //case of forgot password

    Route::post('check-customer-email', [CustomerController::class, 'CheckCustomerEmail'])->name('check-customer-email');   //customer registration time check
    Route::post('check-partner-code', [CustomerController::class, 'CheckPartnerCode'])->name('check-partner-code');   //customer registration time check

    //Customer
    Route::prefix('account')->group(function () {
        Route::controller(CustomerController::class)->group(function () {
            Route::get('customer-register', 'create')->name('customer.create');
            Route::post('/otp-verification', 'store')->name('customer.store');
        });
    });

    //Become a Partner registration Controller
    Route::prefix('partner')->group(function () {
        //Registration
        Route::controller(BecomeAPartnerRegistrationController ::class)->group(function () {
            Route::get('index', 'index')->name('become-a-partner.index');
            Route::get('login-information', 'LoginInformation')->name('become-a-partner.login-information');    //2 page
            Route::post('login-information', 'LoginInformationStore')->name('become-a-partner.login-information.store');
            Route::get('basic-information', 'BasicInformation')->name('become-a-partner.basic-information');    //3 page
            Route::post('basic-information', 'BasicInformationStore')->name('become-a-partner.basic-information.store');
            Route::get('company-information', 'CompanyInformation')->name('become-a-partner.company-information'); //4 page
            Route::post('company-information', 'CompanyInformationStore')->name('become-a-partner.company-information.store');
            Route::get('company-financial-information', 'CompanyFinancialInformation')->name('become-a-partner.company-financial-information'); //5
            Route::post('company-financial-information', 'CompanyFinancialInformationStore')->name('become-a-partner.company-financial-information.store');
            Route::get('company-financial-information2', 'CompanyFinancialInformation2')->name('become-a-partner.company-financial-information2');   //6
            Route::post('company-financial-information2', 'CompanyFinancialInformation2Store')->name('become-a-partner.company-financial-information2.store');
            Route::get('company-documents-upload', 'CompanyDocumentsUpload')->name('become-a-partner.company-documents-upload');  //7
            Route::post('company-documents-upload', 'CompanyDocumentsUploadStore')->name('become-a-partner.company-documents-upload.store');
            Route::get('thank-you', 'ThankYou')->name('become-a-partner.thank-you');
            Route::get('profile-verification-summary', 'ProfileVerificationSummary')->name('become-a-partner.profile-verification-summary');
            Route::get('contract-submission', 'ContractSubmission')->name('become-a-partner.contract-submission');
            Route::get('preview-details', 'PreviewDetails')->name('become-a-partner.preview-details');

            Route::get('partner-contract', 'PartnerContract')->name('become-a-partner.partner-contract');            //11
            Route::post('partner-contract/update', 'PartnerContractUpdate')->name('become-a-partner.partner-contract-update');
            Route::get('contract-verification', 'ContractVerification')->name('become-a-partner.contract-verification');     //10
            Route::post('information/update', 'InformationUpdate')->name('become-a-partner.information.edit');
             Route::get('all/notification/read', 'PartnerReadNotification')->name('partner.notification.read');

        });
    });

    Route::middleware(['auth:sanctum',config('jetstream.auth_session'),'verified', 'is_verify_email'])->group(function () {
        Route::get('/dashboard', [Dashboard::class, 'Dashboard'])->name('dashboard');
        Route::post('/setNotification', [Dashboard::class, 'setNotification'])->name('setNotification');
        Route::get('/all-notification', [Dashboard::class, 'AllNotification'])->name('AllNotification');
        Route::get('/read-notification', [Dashboard::class, 'ReadNotification'])->name('ReadNotification');

        Route::get('/checkout', [CheckoutPageController::class, 'index'])->name('checkout');
        Route::post('/check-checkout-email', [CheckoutPageController::class, 'CheckUniqueEmailAjax'])->name('check-checkout-email');
        Route::post('/store-old-data-checkout', [CheckoutPageController::class, 'OldValueCheckoutPageAjax'])->name('store-old-data-checkout');
        Route::post('/checkout', [CheckoutPageController::class, 'store'])->name('checkout.store');
        Route::get('/transactions', [TransactionsPageController::class, 'transaction'])->name('transactions');
        Route::get('lob/thankyou', [TransactionsPageController::class, 'ThankYou'])->name('subscription.thankyou');
    });

    //purchase plan
    Route::any('purchase-plan', [PlanPurchaseController::class, 'Store'])->name('purchase-plan.store');

    //admin
    Route::middleware(['auth:sanctum',config('jetstream.auth_session'),'verified', 'AdministratorCheck'])->group( function () {
        Route::prefix('admin')->group(function () {
            //user
            Route::controller(UserController::class)->group(function () {
                Route::get('change-password', 'ChangePassword')->name('change-password');
                Route::post('change-password', 'ChangePasswordSave')->name('change.password.store');
                Route::get('users', 'index')->name('user.view');
                Route::get('users/add', 'create')->name('user.add');
                Route::post('users/store', 'store')->name('user.store');
                Route::get('users/edit/{id}', 'edit')->name('user.edit');
                Route::post('users/update/{id}', 'update')->name('user.update');
                Route::get('users/delete/{id}', 'destroy')->name('user.delete');
                Route::get('users/show/{id}', 'show')->name('user.show');
                Route::get('users/inactive', 'inActiveUser')->name('user.inactive.view');
                Route::get('users/edit/inactive/{id}', 'inActiveUserEdit')->name('user.edit.inactive');
            });
            //customer
            Route::controller(CustomerManagementController::class)->group(function () {
                Route::get('customer', 'index')->name('admin.customer.view');
                Route::get('customer/edit/{id}', 'edit')->name('admin.customer.edit');
                Route::post('customer/update/{id}', 'update')->name('admin.customer.update');
                Route::get('customer/delete/{id}', 'destroy')->name('admin.customer.delete');
                Route::get('customer/preview/{id}', 'show')->name('admin.customer.show');
                Route::get('customer/inactive', 'inActiveUser')->name('admin.customer.inactive.view');
                Route::get('customer/edit/inactive/{id}', 'inActiveUserEdit')->name('admin.customer.edit.inactive');
            });
            //partner
            Route::controller(PartnerManagementAdminController::class)->group(function () {
                Route::get('partner', 'index')->name('admin.partner.view');
                Route::get('partner/edit/{id}', 'edit')->name('admin.partner.edit');
                Route::post('partner/update/{id}', 'update')->name('admin.partner.update');
                Route::get('partner/delete/{id}', 'destroy')->name('admin.partner.delete');
                Route::get('partner/preview/{id}', 'show')->name('admin.partner.show');
                Route::get('partner/inactive', 'inActiveUser')->name('admin.partner.inactive.view');
                Route::get('partner/edit/inactive/{id}', 'inActiveUserEdit')->name('admin.partner.edit.inactive');
                Route::get('partner/export', 'ExcelExport')->name('admin.partner.export');
            });
            //General Page Management
            Route::controller(GeneralPageManagemnt::class)->group(function () {
                Route::get('all/page/{type}', 'index')->name('general.page.list');
                Route::get('page/create/{type}', 'create')->name('general.page.addnew');
                Route::post('page/store/{type}', 'store')->name('general.page.store');
                Route::get('page/edit/{type}/{id}', 'edit')->name('general.page.edit');
                Route::post('page/edit/{type}/{id}', 'update')->name('general.page.update');
                Route::get('page/delete/{type}/{id}', 'destroy')->name('general.page.delete');
            });
            //label Management
            Route::controller(LabelManagementController::class)->group(function () {
                Route::get('all/label', 'index')->name('label.page.list');
                Route::get('label/create', 'create')->name('label.page.addnew');
                Route::post('label/store', 'store')->name('label.page.store');
                Route::get('label/edit/{id}', 'edit')->name('label.page.edit');
                Route::post('label/edit/{id}', 'update')->name('label.page.update');
                Route::get('label/delete/{id}', 'destroy')->name('label.page.delete');
            });
            //message Management
            Route::controller(MessageManagementController::class)->group(function () {
                Route::get('all/message', 'index')->name('message.page.list');
                Route::get('message/create', 'create')->name('message.page.addnew');
                Route::post('message/store', 'store')->name('message.page.store');
                Route::get('message/edit/{id}', 'edit')->name('message.page.edit');
                Route::post('message/edit/{id}', 'update')->name('message.page.update');
                Route::get('message/delete/{id}', 'destroy')->name('message.page.delete');
            });

            //Blog Category
            Route::controller(BlogCategoryController::class)->group(function () {
                Route::get('post/category/{type}', 'index')->name('user.blog.category.view');
                Route::get('post/category/add/{type}', 'create')->name('user.blog.category.add');
                Route::post('post/category/store/{type}', 'store')->name('user.blog.category.store');
                Route::get('post/category/edit/{type}/{id}', 'edit')->name('user.blog.category.edit');
                Route::post('post/category/update/{type}/{id}', 'update')->name('user.blog.category.update');
                Route::get('post/category/delete/{type}/{id}', 'destroy')->name('user.blog.category.delete');
                Route::get('post/category/show/{type}/{id}', 'show')->name('user.blog.category.show');
            });

            //Posts
            Route::controller(PostController::class)->group(function () {
                Route::get('all/posts', 'blogList')->name('post.list');
                Route::get('post/create', 'create')->name('post.addnew');
                Route::post('post/store', 'store')->name('post.store');
                Route::get('post/preview/{id}', 'preview')->name('post.preview');
                Route::get('post/edit/{id}', 'edit')->name('post.edit');
                Route::post('post/edit/{id}', 'update')->name('post.update');
                Route::get('post/get-category', 'GetCategory')->name('post.getCategory');
                Route::get('post/get-category-name', 'GetCategoryName')->name('post.getCategoryName');
                Route::get('post/delete/{id}', 'delete')->name('post.delete');
                Route::get('post/comment/{id}', 'comment')->name('post.comment');
                Route::get('post/comment/edit/{id}', 'commentUpdate')->name('post.comment.edit');
            });

            //LatestNews
            Route::controller(LatestNewsController::class)->group(function () {
                Route::get('all/latest-news', 'index')->name('latest-news.list');
                Route::get('latest-news/preview/{id}', 'show')->name('latest-news.preview');
                Route::get('latest-news/create', 'create')->name('latest-news.addnew');
                Route::post('latest-news/store', 'store')->name('latest-news.store');
                Route::get('latest-news/edit/{id}', 'edit')->name('latest-news.edit');
                Route::post('latest-news/edit/{id}', 'update')->name('latest-news.update');
                Route::get('latest-news/delete/{id}', 'destroy')->name('latest-news.delete');
                Route::get('latest-news/get-category', 'GetCategory')->name('latest-news.getCategory');
                Route::get('latest-news/get-category-name', 'GetCategoryName')->name('latest-news.getCategoryName');
            });

            //Go Online Digital Marketing Services
            Route::controller(GoOnlineDigitalMarketingServicesController::class)->group(function () {
                Route::get('all/go-online/digital-marketing-services', 'index')->name('go-online.digital-marketing-services.list');
                Route::get('go-online/digital-marketing-services/preview/{id}', 'show')->name('go-online.digital-marketing-services.preview');
                Route::get('go-online/digital-marketing-services/create', 'create')->name('go-online.digital-marketing-services.addnew');
                Route::post('go-online/digital-marketing-services/store', 'store')->name('go-online.digital-marketing-services.store');
                Route::get('go-online/digital-marketing-services/edit/{id}', 'edit')->name('go-online.digital-marketing-services.edit');
                Route::post('go-online/digital-marketing-services/edit/{id}', 'update')->name('go-online.digital-marketing-services.update');
                Route::get('go-online/digital-marketing-services/delete/{id}', 'destroy')->name('go-online.digital-marketing-services.delete');
            });

            //Go Online Digital Marketing Services Features
            Route::controller(GoOnlineDigitalMarketingServicesFeaturesController::class)->group(function () {
                Route::get('go-online/digital-marketing-services/features/{id}', 'edit')->name('go-online.digital-marketing-services.features');
                Route::post('go-online/digital-marketing-services/features/update/{id}', 'update')->name('go-online.digital-marketing-services.features.update');
                Route::post('go-online/digital-marketing-services/features/delete', 'destroy')->name('go-online.digital-marketing-services.features.delete');
            });
            //Go Online Digital Marketing Services Benefits
            Route::controller(GoOnlineDigitalMarketingServicesBenefitsController::class)->group(function () {
                Route::get('go-online/digital-marketing-services/benefits/{id}', 'edit')->name('go-online.digital-marketing-services.benefits');
                Route::post('go-online/digital-marketing-services/benefits/update/{id}', 'update')->name('go-online.digital-marketing-services.benefits.update');
            });

            //VISION AND MISSION
            Route::controller(VissionAndMissionController::class)->group(function () {
                Route::get('all/vission-and-mission', 'index')->name('page.vission-and-mission.list');
                Route::get('vission-and-mission/create', 'create')->name('page.vission-and-mission.addnew');
                Route::post('vission-and-mission/store', 'store')->name('page.vission-and-mission.store');
                Route::get('vission-and-mission/edit/{id}', 'edit')->name('page.vission-and-mission.edit');
                Route::post('vission-and-mission/edit/{id}', 'update')->name('page.vission-and-mission.update');
                Route::get('vission-and-mission/delete/{id}', 'destroy')->name('page.vission-and-mission.delete');
            });
            //Vission And Mission Feature
            Route::controller(VissionAndMissionFeatureController::class)->group(function () {
                Route::get('vission-and-mission/features/{id}', 'index')->name('page.vission-and-mission.features');
                Route::post('vission-and-mission/features/update/{id}', 'update')->name('page.vission-and-mission.features.update');
                Route::post('vission-and-mission/features/delete', 'destroy')->name('page.vission-and-mission.features.delete');
            });
            //Vission And Mission Feature
            Route::controller(VissionAndMissionOurCoreValuesController::class)->group(function () {
                Route::get('vission-and-mission/our-core-values/{id}', 'index')->name('page.vission-and-mission.our-core-values');
                Route::post('vission-and-mission/our-core-values/update/{id}', 'update')->name('page.vission-and-mission.our-core-values.update');
                Route::post('vission-and-mission/our-core-values/delete', 'destroy')->name('page.vission-and-mission.our-core-values.delete');
            });

            //ContactUs
            Route::controller(ContactUsController::class)->group(function () {
                Route::get('all/contact-us', 'index')->name('page.contact-us.list');
                Route::get('contact-us/create', 'create')->name('page.contact-us.addnew');
                Route::post('contact-us/store', 'store')->name('page.contact-us.store');
                Route::get('contact-us/edit/{id}', 'edit')->name('page.contact-us.edit');
                Route::post('contact-us/edit/{id}', 'update')->name('page.contact-us.update');
                Route::get('contact-us/delete/{id}', 'destroy')->name('page.contact-us.delete');
            });
            //Contact Us Global Offices Controller
            Route::controller(ContactUsGlobalOfficesController::class)->group(function () {
                Route::get('all/contact-us/global-office/{contact_us_id}', 'index')->name('page.contact-us.global-office.list');
                Route::get('contact-us/global-office/create/{contact_us_id}', 'create')->name('page.contact-us.global-office.addnew');
                Route::post('contact-us/global-office/store/{contact_us_id}', 'store')->name('page.contact-us.global-office.store');
                Route::get('contact-us/global-office/edit/{contact_us_id}/{id}', 'edit')->name('page.contact-us.global-office.edit');
                Route::post('contact-us/global-office/edit/{contact_us_id}/{id}', 'update')->name('page.contact-us.global-office.update');
                Route::get('contact-us/global-office/delete/{contact_us_id}/{id}', 'destroy')->name('page.contact-us.global-office.delete');
            });
            //Contact Us Global Offices Address Controller
            Route::controller(ContactUsGlobalOfficesAddressController::class)->group(function () {
                Route::get('contact-us/global-office/address/{contact_us_id}/{id}', 'index')->name('page.contact-us.global-office.address');
                Route::post('contact-us/global-office/address/update/{contact_us_id}/{id}', 'update')->name('page.contact-us.global-office.address.update');
                Route::post('contact-us/global-office/address/delete', 'destroy')->name('page.contact-us.global-office.address.delete');
            });
            //Event
            Route::controller(EventController::class)->group(function () {
                Route::get('all/event', 'index')->name('page.event.list');
                Route::get('event/create', 'create')->name('page.event.addnew');
                Route::post('event/store', 'store')->name('page.event.store');
                Route::get('event/edit/{id}', 'edit')->name('page.event.edit');
                Route::post('event/edit/{id}', 'update')->name('page.event.update');
                Route::get('event/delete/{id}', 'destroy')->name('page.event.delete');
            });
            //Event Date
            Route::controller(EventDateController::class)->group(function () {
                Route::get('all/event/event-date/', 'index')->name('page.event.event-date.list');
                Route::get('event/event-date/create/', 'create')->name('page.event.event-date.addnew');
                Route::post('event/event-date/store/', 'store')->name('page.event.event-date.store');
                Route::get('event/event-date/edit/{id}', 'edit')->name('page.event.event-date.edit');
                Route::post('event/event-date/edit/{id}', 'update')->name('page.event.event-date.update');
                Route::get('event/event-date/delete/{id}', 'destroy')->name('page.event.event-date.delete');
            });
            //Event Form Data
            Route::controller(EventFormDataController::class)->group(function () {
                Route::get('all/event/event-form-data/{id}', 'index')->name('page.event.event-form-data.list');
                Route::get('all/event/event-form-data/excel/{id}', 'excel')->name('page.event.event-form-data.excel');
            });

            //Go Online  Create Website
            Route::controller(GoOnlineCreateWebsiteController::class)->group(function () {
                Route::get('all/go-online/create-website', 'index')->name('go-online.create-website.list');
                Route::get('go-online/create-website/preview/{id}', 'show')->name('go-online.create-website.preview');
                Route::get('go-online/create-website/create', 'create')->name('go-online.create-website.addnew');
                Route::post('go-online/create-website/store', 'store')->name('go-online.create-website.store');
                Route::get('go-online/create-website/edit/{id}', 'edit')->name('go-online.create-website.edit');
                Route::post('go-online/create-website/edit/{id}', 'update')->name('go-online.create-website.update');
                Route::get('go-online/create-website/delete/{id}', 'destroy')->name('go-online.create-website.delete');
            });

            //Go Online Create Website Features
            Route::controller(GoOnlineCreateWebsiteFeaturesController::class)->group(function () {
                Route::get('go-online/create-website/features/{id}', 'edit')->name('go-online.create-website.features');
                Route::post('go-online/create-website/features/update/{id}', 'update')->name('go-online.create-website.features.update');
                Route::post('go-online/create-website/features/delete', 'destroy')->name('go-online.create-website.features.delete');
            });

            //Go Online Create Website Features
            Route::controller(GoOnlineCreateWebsiteThemeController::class)->group(function () {
                Route::get('go-online/create-website/theme/{id}', 'edit')->name('go-online.create-website.theme');
                Route::post('go-online/create-website/theme/update/{id}', 'update')->name('go-online.create-website.theme.update');
                Route::post('go-online/create-website/theme/delete', 'destroy')->name('go-online.create-website.theme.delete');
            });

            //Industries Category    lob  category
            Route::controller(IndustriesCategoryController::class)->group(function () {
                Route::get('all/industries/category', 'index')->name('industries.category.list');
                Route::get('industries/category/preview/{id}', 'show')->name('industries.category.preview');
                Route::get('industries/category/create', 'create')->name('industries.category.addnew');
                Route::post('industries/category/store', 'store')->name('industries.category.store');
                Route::get('industries/category/edit/{id}', 'edit')->name('industries.category.edit');
                Route::post('industries/category/edit/{id}', 'update')->name('industries.category.update');
                Route::get('industries/category/delete/{id}', 'destroy')->name('industries.category.delete');
            });

            //Industries industry lob
            Route::controller(IndustriesController::class)->group(function () {
                Route::get('all/industries/industry', 'index')->name('industries.industry.list');
                Route::get('industries/industry/preview/{id}', 'show')->name('industries.industry.preview');
                Route::get('industries/industry/create', 'create')->name('industries.industry.addnew');
                Route::post('industries/industry/store', 'store')->name('industries.industry.store');
                Route::get('industries/industry/edit/{id}', 'edit')->name('industries.industry.edit');
                Route::post('industries/industry/edit/{id}', 'update')->name('industries.industry.update');
                Route::get('industries/industry/delete/{id}', 'destroy')->name('industries.industry.delete');
                Route::get('industries/get-category-name', 'GetCategoryName')->name('industries.getCategoryName');
            });
            //Industries industry service
            Route::controller(IndustriesServiceController::class)->group(function () {
                Route::get('industries/industry/service/{id}', 'edit')->name('industries.industry.service');
                Route::post('industries/industry/service/update/{id}', 'update')->name('industries.industry.service.update');
                Route::post('industries/industry/service/delete', 'delete')->name('industries.industry.service.delete');
            });

            //Industries industry key-offerings
            Route::controller(IndustriesKeyOfferingsController::class)->group(function () {
                Route::get('industries/industry/key-offerings/{id}', 'edit')->name('industries.industry.key-offerings');
                Route::post('industries/industry/key-offerings/update/{id}', 'update')->name('industries.industry.key-offerings.update');
                Route::post('industries/industry/key-offerings/delete', 'delete')->name('industries.industry.key-offerings.delete');
            });

            //financial-service
            Route::controller(FinancialServicesController::class)->group(function () {
                Route::get('all/financial-service/payment-gateway', 'index')->name('financial-service.payment-gateway.list');
                Route::get('financial-service/payment-gateway/preview/{id}', 'show')->name('financial-service.payment-gateway.preview');
                Route::get('financial-service/payment-gateway/create', 'create')->name('financial-service.payment-gateway.addnew');
                Route::post('financial-service/payment-gateway/store', 'store')->name('financial-service.payment-gateway.store');
                Route::get('financial-service/payment-gateway/edit/{id}', 'edit')->name('financial-service.payment-gateway.edit');
                Route::post('financial-service/payment-gateway/edit/{id}', 'update')->name('financial-service.payment-gateway.update');
                Route::get('financial-service/payment-gateway/delete/{id}', 'destroy')->name('financial-service.payment-gateway.delete');
            });

            //financial-service card
            Route::controller(FinancialServicesCardController::class)->group(function () {
                Route::get('financial-service/card/{id}', 'index')->name('financial-service.card');
                Route::post('financial-service/card/update/{id}', 'update')->name('financial-service.card.update');
                Route::post('financial-service/card/delete', 'destroy')->name('financial-service.card.delete');
            });

            //financial-service service
            Route::controller(FinancialServicesServiceController::class)->group(function () {
                Route::get('financial-service/service/{id}', 'index')->name('financial-service.service');
                Route::post('financial-service/service/update/{id}', 'update')->name('financial-service.service.update');
                Route::post('financial-service/service/delete', 'destroy')->name('financial-service.service.delete');
            });

            //Business Payment Platforms Controller
            Route::controller(BusinessPaymentPlatformsController::class)->group(function () {
                Route::get('all/financial-service/business-payment-platforms', 'index')->name('financial-service.business-payment-platforms.list');
                Route::get('financial-service/business-payment-platforms/create', 'create')->name('financial-service.business-payment-platforms.addnew');
                Route::post('financial-service/business-payment-platforms/store', 'store')->name('financial-service.business-payment-platforms.store');
                Route::get('financial-service/business-payment-platforms/edit/{id}', 'edit')->name('financial-service.business-payment-platforms.edit');
                Route::post('financial-service/business-payment-platforms/edit/{id}', 'update')->name('financial-service.business-payment-platforms.update');
                Route::get('financial-service/business-payment-platforms/delete/{id}', 'destroy')->name('financial-service.business-payment-platforms.delete');
            });

            //Email Management Controller
            Route::controller(EmailManagementController::class)->group(function () {
                Route::get('all/email', 'index')->name('user.email.view');
                Route::get('email/create', 'create')->name('user.email.addnew');
                Route::post('email/store', 'store')->name('user.email.store');
                Route::get('email/edit/{id}', 'edit')->name('user.email.edit');
                Route::post('email/edit/{id}', 'update')->name('user.email.update');
                Route::get('email/delete/{id}', 'destroy')->name('user.email.delete');
            });
            //Email Notification Management Controller
            Route::controller(EmailNotificationManagementController::class)->group(function () {
                Route::get('all/email-subscription-notification', 'index')->name('user.setting.email-subscription-notification.view');
                Route::post('email-subscription-notification/edit', 'update')->name('user.setting.email-subscription-notification.update');
            });

            //language
            Route::controller(LanguageController::class)->group(function () {
                Route::get('all/setting/language', 'index')->name('setting.language.list');
                Route::get('setting/language/create', 'create')->name('setting.language.addnew');
                Route::post('setting/language/store', 'store')->name('setting.language.store');
                Route::get('setting/language/edit/{id}', 'edit')->name('setting.language.edit');
                Route::get('setting/language/updateStatus/{id}', 'updateStatus')->name('setting.language.updateStatus');
                Route::post('setting/language/edit/{id}', 'update')->name('setting.language.update');
            });
            //currency
            Route::controller(CurrencyController::class)->group(function () {
                Route::get('all/setting/currency', 'index')->name('setting.currency.list');
                Route::get('setting/currency/edit/{id}', 'edit')->name('setting.currency.edit');
                Route::post('setting/currency/edit/{id}', 'update')->name('setting.currency.update');
            });
            //gst
            Route::controller(GSTController::class)->group(function () {
                Route::get('all/setting/gst', 'index')->name('setting.gst.list');
                Route::post('setting/gst/update', 'update')->name('setting.gst.update');
            });
            //Payment Gateway Key Management Controller
            Route::controller(PaymentGatewayKeyManagementController::class)->group(function () {
                Route::get('all/setting/payment-gateway', 'index')->name('setting.payment-gateway.list');
                Route::post('setting/payment-gateway/update', 'update')->name('setting.payment-gateway.update');
            });
            //Forgot Password Page Management Controller
            Route::controller(ForgotPasswordPageManagementController::class)->group(function () {
                Route::get('all/setting/forgot-password', 'index')->name('setting.forgot-password.list');
                Route::post('setting/forgot-password/update', 'update')->name('setting.forgot-password.update');
            });
            //Header Management
            Route::controller(HeaderManagementController::class)->group(function () {
                Route::get('all/setting/header', 'index')->name('setting.header.list');
                Route::post('setting/header/header-logo/store', 'HeaderLogoStore')->name('setting.header.header-logo.store');

                Route::get('setting/header/header-menu', 'headerMenu')->name('setting.header.header-menu');
                Route::get('setting/header/header-menu-pre/{order}', 'headerMenuOrderPre')->name('setting.header.header-menu-pre');
                Route::get('setting/header/header-menu-next/{order}', 'headerMenuOrderNext')->name('setting.header.header-menu-next');
                Route::get('setting/header/header-menu-edit/{id}', 'headerMenuEdit')->name('setting.header.header-menu-edit');
                Route::post('setting/header/header-menu/{id}', 'headerMenuUpdate')->name('setting.header.header-menu.edit');
                // for go online and Financial Service
                Route::get('setting/header/header-menu-child/{id}', 'headerMenuChildGet')->name('setting.header.header-menu-child');
                Route::get('setting/header/header-menu-child-pre/{parent_id}/{order}', 'headerMenuChildOrderPre')->name('setting.header.header-menu-child-pre');
                Route::get('setting/header/header-menu-child-next/{parent_id}/{order}', 'headerMenuChildOrderNext')->name('setting.header.header-menu-child-next');
                Route::get('setting/header/header-menu-child-add/{id}', 'headerMenuChildAdd')->name('setting.header.header-menu-child-add');
                Route::post('setting/header/header-menu-child-add/{id}', 'headerMenuChildStore')->name('setting.header.header-menu-child-add.store');
                Route::get('setting/header/header-menu-child-edit/{parent_id}/{id}', 'headerMenuChildEdit')->name('setting.header.header-menu-child-edit');
                Route::post('setting/header/header-menu-child/{parent_id}/{id}', 'headerMenuChildUpdate')->name('setting.header.header-menu-child.edit');
                Route::get('setting/header/header-menu-child-delete/{id}', 'headerMenuChildDelete')->name('setting.header.header-menu-child.delete');
                // for industry and price
                Route::post('setting/header/header-menu-price-add/{id}', 'headerMenuPriceStore')->name('setting.header.header-menu-price-add.store');
                Route::post('setting/header/header-menu-price/{parent_id}/{id}', 'headerMenuPriceUpdate')->name('setting.header.header-menu-price.edit');
                Route::get('setting/header/header-menu-price-delete/{id}', 'headerMenuPriceDelete')->name('setting.header.header-menu-price.delete');
                // for industry and price child
                Route::get('setting/header/header-menu-price-child/{parent_id}/{id}', 'headerMenuPriceChildGet')->name('setting.header.header-menu-price-child');
                Route::get('setting/header/header-menu-price-child-pre/{parent_id}/{child_id}/{order}', 'headerMenuPriceChildOrderPre')->name('setting.header.header-menu-price-child-pre');
                Route::get('setting/header/header-menu-price-child-next/{parent_id}/{child_id}/{order}', 'headerMenuPriceChildOrderNext')->name('setting.header.header-menu-price-child-next');
                Route::get('setting/header/header-menu-price-child-add/{parent_id}/{id}', 'headerMenuPriceChildAdd')->name('setting.header.header-menu-price-child-add');
                Route::post('setting/header/header-menu-price-child-add/{parent_id}/{id}', 'headerMenuPriceChildStore')->name('setting.header.header-menu-price-child-add.store');
                Route::get('setting/header/header-menu/price-child/edit/{parent_id}/{child_id}/{id}', 'headerMenuPriceChildEdit')->name('setting.header.header-menu-price-child-edit');
                Route::post('setting/header/header-menu-price-child/update/{parent_id}/{child_id}/{id}', 'headerMenuPriceChildUpdate')->name('setting.header.header-menu-price-child.update');
                Route::get('setting/header/header-menu-price-child/update/delete/{id}', 'headerMenuPriceChildDelete')->name('setting.header.header-menu-price-child.delete');
                //footer social icons
                Route::get('setting/header/footer-social-icons', 'FooterSocialIcons')->name('setting.header.footer-social-icons');
                Route::post('setting/header/footer-social-icons', 'FooterSocialIconsStore')->name('setting.header.footer-social-icons.store');
                Route::post('setting/header/footer-social-icons/delete', 'FooterSocialIconDelete')->name('setting.header.footer-social-icons.delete');
                Route::get('setting/header/create', 'create')->name('setting.header.addnew');
                Route::post('setting/header/store', 'store')->name('setting.header.store');
                Route::get('setting/header/edit/{id}', 'edit')->name('setting.header.edit');
                Route::post('setting/header/edit/{id}', 'update')->name('setting.header.update');
                //footer menu
                Route::get('setting/footer/footer-menu', 'footerMenu')->name('setting.footer.footer-menu');
                Route::get('setting/footer/footer-menu-pre/{order}', 'footerMenuOrderPre')->name('setting.footer.footer-menu-pre');
                Route::get('setting/footer/footer-menu-next/{order}', 'footerMenuOrderNext')->name('setting.footer.footer-menu-next');
                Route::get('setting/footer/footer-menu-edit/{id}', 'footerMenuEdit')->name('setting.footer.footer-menu-edit');
                Route::post('setting/footer/footer-menu/{id}', 'footerMenuUpdate')->name('setting.footer.footer-menu.edit');
                // footer menu child
                Route::get('setting/footer/footer-menu-child/{id}', 'footerMenuChildGet')->name('setting.footer.footer-menu-child');
                Route::get('setting/footer/footer-menu-child-pre/{parent_id}/{order}', 'footerMenuChildOrderPre')->name('setting.footer.footer-menu-child-pre');
                Route::get('setting/footer/footer-menu-child-next/{parent_id}/{order}', 'footerMenuChildOrderNext')->name('setting.footer.footer-menu-child-next');
                Route::get('setting/footer/footer-menu-child-add/{id}', 'footerMenuChildAdd')->name('setting.footer.footer-menu-child-add');
                Route::post('setting/footer/footer-menu-child-add/{id}', 'footerMenuChildStore')->name('setting.footer.footer-menu-child-add.store');
                Route::get('setting/footer/footer-menu-child-edit/{parent_id}/{id}', 'footerMenuChildEdit')->name('setting.footer.footer-menu-child-edit');
                Route::post('setting/footer/footer-menu-child/{parent_id}/{id}', 'footerMenuChildUpdate')->name('setting.footer.footer-menu-child.edit');
                Route::get('setting/footer/footer-menu-child-delete/{id}', 'footerMenuChildDelete')->name('setting.footer.footer-menu-child.delete');
                //top header menu
                Route::get('setting/top-header-menu', 'topHeaderMenuGet')->name('setting.top-header-menu');
                Route::get('setting/top-header-menu/pre/{order}', 'topHeaderMenuOrderPre')->name('setting.top-header-menu.pre');
                Route::get('setting/top-header-menu/next/{order}', 'topHeaderMenuOrderNext')->name('setting.top-header-menu.next');
                Route::get('setting/top-header-menu/add', 'topHeaderMenuAdd')->name('setting.top-header-menu.add');
                Route::post('setting/top-header-menu/add', 'topHeaderMenuStore')->name('setting.top-header-menu.store');
                Route::get('setting/top-header-menu/edit/{id}', 'topHeaderMenuEdit')->name('setting.top-header-menu.edit');
                Route::post('setting/top-header-menu/update/{id}', 'topHeaderMenuUpdate')->name('setting.top-header-menu.update');
                Route::get('setting/top-header-menu/delete/{id}', 'topHeaderMenuDelete')->name('setting.top-header-menu.delete');
            });

            //Pricing management
            Route::controller(PricingController::class)->group(function () {
                Route::get('pricing', 'index')->name('pricing.index');
                Route::get('pricing/add', 'create')->name('pricing.add');
                Route::get('pricing/edit/{id}', 'edit')->name('pricing.edit');
                Route::post('pricing/store', 'store')->name('pricing.store');
                Route::post('pricing/update/{id}', 'update')->name('pricing.update');
                Route::get('pricing/delete/{id}', 'destroy')->name('pricing.delete');
            });

            //Pricing feature
            Route::controller(PricingFeatureController::class)->group(function () {
                Route::get('pricing/feature/{id}', 'index')->name('pricing.feature');
                Route::get('pricing/feature/create/{id}', 'create')->name('pricing.feature.addnew');
                Route::post('pricing/feature/store/{id}', 'store')->name('pricing.feature.store');
                Route::get('pricing/feature/edit/{price_id}/{id}', 'edit')->name('pricing.feature.edit');
                Route::post('pricing/feature/update/{price_id}/{id}', 'update')->name('pricing.feature.update');
                Route::get('pricing/feature/delete/{price_id}/{id}', 'delete')->name('pricing.feature.delete');
            });
             //Pricing addons
             Route::controller(PricingAddonsController::class)->group(function () {
                Route::get('pricing/addons/{id}', 'index')->name('pricing.addons');
                Route::get('pricing/addons/create/{id}', 'create')->name('pricing.addons.addnew');
                Route::post('pricing/addons/store/{id}', 'store')->name('pricing.addons.store');
                Route::get('pricing/addons/edit/{feature_id}/{id}', 'edit')->name('pricing.addons.edit');
                Route::post('pricing/addons/update/{feature_id}/{id}', 'update')->name('pricing.addons.update');
                Route::get('pricing/addons/delete/{feature_id}/{id}', 'delete')->name('pricing.addons.delete');
            });

            //home page management
            //home slider Section
            Route::controller(HomeSliderController::class)->group(function () {
                Route::get('all/home/slider', 'index')->name('home.slider.list');
                Route::get('home/slider/preview/{id}', 'show')->name('home.slider.preview');
                Route::get('home/slider/create', 'create')->name('home.slider.addnew');
                Route::post('home/slider/store', 'store')->name('home.slider.store');
                Route::get('home/slider/edit/{id}', 'edit')->name('home.slider.edit');
                Route::post('home/slider/edit/{id}', 'update')->name('home.slider.update');
                Route::get('home/slider/delete/{id}', 'destroy')->name('home.slider.delete');
            });
            //home slider Auto Section
            Route::controller(HomeSliderAutoController::class)->group(function () {
                Route::get('all/home/auto-slider', 'index')->name('home.slider-auto.list');
                Route::get('home/auto-slider/preview/{id}', 'show')->name('home.slider-auto.preview');
                Route::get('home/auto-slider/create', 'create')->name('home.slider-auto.addnew');
                Route::post('home/auto-slider/store', 'store')->name('home.slider-auto.store');
                Route::get('home/auto-slider/edit/{id}', 'edit')->name('home.slider-auto.edit');
                Route::post('home/auto-slider/edit/{id}', 'update')->name('home.slider-auto.update');
                Route::get('home/auto-slider/delete/{id}', 'destroy')->name('home.slider-auto.delete');
            });

            //home features Section
            Route::controller(HomeFeaturesController::class)->group(function () {
                Route::get('all/home/features', 'index')->name('home.features.list');
                Route::get('home/features/preview/{id}', 'show')->name('home.features.preview');
                Route::get('home/features/create', 'create')->name('home.features.addnew');
                Route::post('home/features/store', 'store')->name('home.features.store');
                Route::get('home/features/edit/{id}', 'edit')->name('home.features.edit');
                Route::post('home/features/edit/{id}', 'update')->name('home.features.update');
                Route::get('home/features/delete/{id}', 'destroy')->name('home.features.delete');
            });

            //home integrated-supply Section
            Route::controller(HomeIntegratedSupplyController::class)->group(function () {
                Route::get('all/home/integrated-supply', 'index')->name('home.integrated-supply.list');
                Route::get('home/integrated-supply/preview/{id}', 'show')->name('home.integrated-supply.preview');
                Route::get('home/integrated-supply/create', 'create')->name('home.integrated-supply.addnew');
                Route::post('home/integrated-supply/store', 'store')->name('home.integrated-supply.store');
                Route::get('home/integrated-supply/edit/{id}', 'edit')->name('home.integrated-supply.edit');
                Route::post('home/integrated-supply/edit/{id}', 'update')->name('home.integrated-supply.update');
                Route::get('home/integrated-supply/delete/{id}', 'destroy')->name('home.integrated-supply.delete');
            });

            //home our-services Section
            Route::controller(HomeOurServicesController::class)->group(function () {
                Route::get('all/home/our-services', 'index')->name('home.our-services.list');
                Route::get('home/our-services/preview/{id}', 'show')->name('home.our-services.preview');
                Route::get('home/our-services/create', 'create')->name('home.our-services.addnew');
                Route::post('home/our-services/store', 'store')->name('home.our-services.store');
                Route::get('home/our-services/edit/{id}', 'edit')->name('home.our-services.edit');
                Route::post('home/our-services/edit/{id}', 'update')->name('home.our-services.update');
                Route::get('home/our-services/delete/{id}', 'destroy')->name('home.our-services.delete');

                Route::get('home/our-services/link/edit/{id}', 'linkEdit')->name('home.our-services.link.edit');
                Route::post('home/our-services/link/edit/{id}', 'linkUpdate')->name('home.our-services.link.update');
                Route::post('home/our-services/link/delete', 'linkDestroy')->name('home.our-services.link.delete');
            });

            //home industries Section
            Route::controller(HomeIndustriesController::class)->group(function () {
                Route::get('all/home/industries', 'index')->name('home.industries.list');
                Route::get('home/industries/preview/{id}', 'show')->name('home.industries.preview');
                Route::get('home/industries/create', 'create')->name('home.industries.addnew');
                Route::post('home/industries/store', 'store')->name('home.industries.store');
                Route::get('home/industries/edit/{id}', 'edit')->name('home.industries.edit');
                Route::post('home/industries/edit/{id}', 'update')->name('home.industries.update');
                Route::get('home/industries/delete/{id}', 'destroy')->name('home.industries.delete');
            });

            //home cloud Section
            Route::controller(HomeCloudController::class)->group(function () {
                Route::get('all/home/cloud', 'index')->name('home.cloud.list');
                Route::get('home/cloud/preview/{id}', 'show')->name('home.cloud.preview');
                Route::get('home/cloud/create', 'create')->name('home.cloud.addnew');
                Route::post('home/cloud/store', 'store')->name('home.cloud.store');
                Route::get('home/cloud/edit/{id}', 'edit')->name('home.cloud.edit');
                Route::post('home/cloud/edit/{id}', 'update')->name('home.cloud.update');
                Route::get('home/cloud/delete/{id}', 'destroy')->name('home.cloud.delete');
            });

            //home brands Section
            Route::controller(HomeBrandsController::class)->group(function () {
                Route::get('all/home/brands', 'index')->name('home.brands.list');
                Route::get('home/brands/preview/{id}', 'show')->name('home.brands.preview');
                Route::get('home/brands/create', 'create')->name('home.brands.addnew');
                Route::post('home/brands/store', 'store')->name('home.brands.store');
                Route::get('home/brands/edit/{id}', 'edit')->name('home.brands.edit');
                Route::post('home/brands/edit/{id}', 'update')->name('home.brands.update');
                Route::get('home/brands/delete/{id}', 'destroy')->name('home.brands.delete');
            });

            //home customers-derive Section
            Route::controller(HomeCustomersDeriveController::class)->group(function () {
                Route::get('all/home/customers-derive', 'index')->name('home.customers-derive.list');
                Route::get('home/customers-derive/preview/{id}', 'show')->name('home.customers-derive.preview');
                Route::get('home/customers-derive/create', 'create')->name('home.customers-derive.addnew');
                Route::post('home/customers-derive/store', 'store')->name('home.customers-derive.store');
                Route::get('home/customers-derive/edit/{id}', 'edit')->name('home.customers-derive.edit');
                Route::post('home/customers-derive/edit/{id}', 'update')->name('home.customers-derive.update');
                Route::get('home/customers-derive/delete/{id}', 'destroy')->name('home.customers-derive.delete');
            });

            //home page Section
            Route::controller(HomeSectionController::class)->group(function () {
                Route::get('all/home-page/{type}', 'index')->name('home-page.section.list');
                Route::get('home-page/create/{type}', 'create')->name('home-page.section.addnew');
                Route::post('home-page/store/{type}', 'store')->name('home-page.section.store');
                Route::get('home-page/edit/{type}/{id}', 'edit')->name('home-page.section.edit');
                Route::post('home-page/edit/{type}/{id}', 'update')->name('home-page.section.update');
                Route::get('home-page/delete/{type}/{id}', 'destroy')->name('home-page.section.delete');
            });

            //contact us form data
            Route::controller(ContactFormDataShow::class)->group(function () {
                Route::get('all/contact/form-data', 'index')->name('contact.form-data.list');
            });

            //Lob Subscription Detail Controller
            Route::controller(LobSubscriptionDetailController::class)->group(function () {
                Route::get('all/lob/subscription', 'index')->name('lob.subscription.list');
                Route::get('lob/subscription/{id}', 'show')->name('lob.subscription.preview');
                Route::post('lob/subscription/edit/ajax', 'edit')->name('lob.subscription.edit.ajax');
                Route::get('all/lob/subscription/excel', 'excel')->name('lob.subscription.excel');
                
                Route::post('lob/subscription/edit/popup', 'editPopup')->name('lob.subscription.edit.popup');
                Route::post('lob/subscription/edit/popup/update', 'updatePopup')->name('lob.subscription.update.popup');
                Route::post('lob/subscription/edit/next-billing', 'editNextBilling')->name('lob.subscription.edit.next-billing');
                Route::post('lob/subscription/edit/next-billing/update', 'updateNextBilling')->name('lob.subscription.update.next-billing');
                
            });

            //Lob Billing Detail Controller
            Route::controller(LobBillingDetailController::class)->group(function () {
                Route::get('all/lob/billing', 'index')->name('lob.billing.list');
                Route::get('lob/billing/{id}', 'show')->name('lob.billing.preview');
                Route::get('all/lob/billing/pdf/{id}', 'pdf')->name('lob.billing.pdf');
                Route::get('all/lob/billing/excel', 'excel')->name('lob.billing.excel');
            });
            
            //Partner page Controller
            Route::controller(ParentPageController::class)->group(function () {
                Route::get('all/partner-page', 'index')->name('user.partner-page.view');
                Route::get('partner-page/create', 'create')->name('user.partner-page.addnew');
                Route::post('partner-page/store', 'store')->name('user.partner-page.store');
                Route::get('partner-page/edit/{id}', 'edit')->name('user.partner-page.edit');
                Route::post('partner-page/edit/{id}', 'update')->name('user.partner-page.update');
                Route::get('partner-page/delete/{id}', 'destroy')->name('user.partner-page.delete');
                Route::get('partner-page/contract/edit/{id}', 'contractEdit')->name('user.partner-page-contract.edit');
                Route::post('partner-page/contract/edit/{parent_id}', 'contractUpdate')->name('user.partner-page-contract.update');
            });


        });
    });
    //login check

    //customer operation
    Route::middleware(['auth:sanctum',config('jetstream.auth_session'),'verified', 'CustomerCheck'])->group(function (){
        Route::prefix('customer')->group(function (){
            Route::controller(CustomerSettingController::class)->group(function (){
                Route::get('/change/password', 'ChangePassword')->name('customer.change.password');
                Route::post('/change/password', 'ChangePasswordSave')->name('customer.change.password.store');
            });

            Route::controller(CustomerProfileController::class)->group(function (){
                Route::get('/profile/view', 'index')->name('customer.profile.show');
                Route::post('/profile/photo/update', 'updatePhoto')->name('customer.profile.photo.update');
                Route::post('/profile/photo/remove', 'removePhoto')->name('customer.profile.photo.remove');
                Route::post('/profile/photo/bio/update', 'updateBio')->name('customer.profile.bio.update');
                Route::post('/profile/company-information/update', 'companyInformationUpdate')->name('customer.profile.company-information.update');
                Route::post('/profile/authorised-user/update', 'authorisedUserUpdate')->name('customer.profile.authorised-user.update');
                Route::post('/profile/billing-information/update', 'billingInformation')->name('customer.profile.billing-information.update');
                Route::post('/profile/document/update', 'documentUpdate')->name('customer.profile.document.update');
                Route::post('/profile/document/delete', 'documentDelete')->name('customer.profile.document.delete');
            });

            Route::controller(CustomerSubscriptionController::class)->group(function (){
                Route::get('/all/subscription', 'index')->name('customer.subscription.list');
            });

            Route::controller(SubscriptionUpgradePaidController::class)->group(function (){
                Route::get('/subscription-upgrade', 'SubscriptionUpgrade')->name('customer.subscription.upgrade');
                Route::post('/subscription-upgrade/store', 'SubscriptionUpgradeStore')->name('customer.subscription.upgrade.store');
                Route::get('/subscription-paid/pay', 'SubscriptionPaid')->name('customer.subscription.pay.popup');
                Route::get('/subscription-paid/{id}', 'SubscriptionPaidSave')->name('customer.subscription.paid');
                Route::get('/subscription-paid/auropay/{id}', 'SubscriptionPaymentAuropay')->name('customer.subscription.payment.auropay');
            });

            Route::controller(CustomerBillingController::class)->group(function (){
                Route::get('/all/billing', 'index')->name('customer.billing.list');
                Route::get('/billing/{id}', 'show')->name('customer.billing.show');
                Route::get('/billing/pdf/{id}', 'pdf')->name('customer.billing.pdf');
                Route::get('all/billing/excel', 'excel')->name('customer.billing.excel');
            });

            Route::controller(Dashboard::class)->group(function (){
                Route::get('all/notification/read', 'CustomerReadNotification')->name('customer.notification.read');
            });

        });
    });

    //partner operation
    Route::middleware(['auth:sanctum', config('jetstream.auth_session'), 'verified', 'PartnerCheck' ])->group(function () {
        Route::prefix('partner')->group(function () {
            Route::controller(PartnerSettingController::class)->group(function () {
                Route::get('/change/password', 'ChangePassword')->name('partner.change.password');
                Route::post('/change/password', 'ChangePasswordSave')->name('partner.change.password.store');
                Route::get('/all/notification', 'Notifications')->name('partner.all.notification');
            });

            Route::controller(PartnerProfileController::class)->group(function () {
                Route::get('/profile/view', 'index')->name('partner.profile.show');
                Route::post('/profile/photo/update', 'updatePhoto')->name('partner.profile.photo.update');
                Route::post('/profile/photo/remove', 'removePhoto')->name('partner.profile.photo.remove');
                Route::post('/profile/bio/update', 'updateBio')->name('partner.profile.bio.update');
                Route::post('/profile/login-information/update', 'updateLoginInformation')->name('partner.profile.login-information.update');
                Route::post('/profile/basic-information/update', 'updateBasicInformation')->name('partner.profile.basic-information.update');
                Route::post('/profile/company-information/update', 'updateCompanyInformation')->name('partner.profile.company-information.update');
                Route::post('/profile/company-financial-information/update', 'updateCompanyFinancialInformation')->name('partner.profile.company-financial-information.update');
                Route::post('/profile/company-documents-upload/update', 'updateCompanyDocumentsUpload')->name('partner.profile.company-documents-upload.update');
                Route::post('/profile/contract-renewal/update', 'updateContractRenewal')->name('partner.profile.contract-renewal.update');
            });

            Route::controller(BillingPartnerController::class)->group(function () {
                Route::get('/billing/view', 'index')->name('partner.billing.list');
                Route::get('/billing/{id}', 'show')->name('partner.billing.show');
                Route::get('/billing/pdf/{id}', 'pdf')->name('partner.billing.pdf');
                Route::get('all/billing/excel', 'excel')->name('partner.billing.excel');
            });

            Route::controller(PartnerCustomerManagement::class)->group(function () {
                Route::get('/customer/view', 'index')->name('partner.customer.list');
                Route::get('/customer/{id}', 'show')->name('partner.customer.show');
                Route::get('/customer/edit/{id}', 'edit')->name('partner.customer.edit');
                Route::post('/customer/update', 'update')->name('partner.customer.update');
                Route::get('all/customer/excel', 'excel')->name('partner.customer.excel');
            });
        });
    });


});//prevent-back-history

