<div class="tab-pane fade show active" id="company_information" role="tabpanel">
    <div class="form_content_inner">
        <form name='customer_company-information'>
            <?php echo csrf_field(); ?>
            <div class="edit_form">
                <a href="javascript:void(0)" class="edit-button-company-information">Edit</a>
            </div>
            <div class="form_group">
                <label for="">Registered Company Name<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-company-information" name='company' id="company" value="<?php echo e(Auth::user()->company); ?>">
                </div>
            </div>
            <div class="form_group">
                <label for="">Company Code<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="" disabled value="<?php echo e(Auth::user()->code); ?>">
                </div>
            </div>
            <div class="form_group">
                <label>Country<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <select name="country" id="country" class="country-select edit-field-company-information">
                        <?php $__currentLoopData = $country_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($country->code); ?>" <?php if((Auth::user()->country ==$country->code) ||(!Auth::user()->country && $country->code=='IN')): ?> selected <?php endif; ?> ><?php echo e($country->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="form_group state-div" <?php if(Auth::user()->country !=='IN'): ?> style="display:none" <?php endif; ?>>
                <label>State<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <select name="state" class="country-select edit-field-company-information" id="state">
                        <option value="">Please select State</option>
                        <?php $__currentLoopData = $state_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($state->code); ?>" <?php if(Auth::user()->state ==$state->code): ?> selected <?php endif; ?>><?php echo e($state->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="form_group">
                <label>City<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-company-information" maxlength="50" name='city' id="city" value="<?php echo e(Auth::user()->city); ?>">
                </div>
            </div>
            <div class="form_group">
                <label>Address<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="text" class="edit-field-company-information" name='address' maxlength="100" id="address" value="<?php echo e(Auth::user()->address); ?>">
                </div>
            </div>
            <div class="form_group pincode-div " <?php if(Auth::user()->country =='AE'): ?> style="display: none;" <?php endif; ?>>
                <label>Zipcode/Postalcode<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <input type="number" class="edit-field-company-information" name='pincode' id="pincode" value="<?php echo e(Auth::user()->pincode); ?>">
                </div>
            </div>
            <div class="form_group">
                <label>No. of Employee<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <select name="no_of_employee" id="no_of_employee" class="country-select edit-field-company-information">
                        <option value="">Please select No. of Employee</option>
                        <option value="1-10" <?php if(@$data->no_of_employee =='1-10'): ?> selected <?php endif; ?> >1-10</option>
                        <option value="11-50" <?php if(@$data->no_of_employee =='11-50'): ?> selected <?php endif; ?>>11-50 </option>
                        <option value="51-100" <?php if(@$data->no_of_employee =='51-100'): ?> selected <?php endif; ?>>51-100</option>
                        <option value="100+" <?php if(@$data->no_of_employee =='100+'): ?> selected <?php endif; ?>>100+</option>
                    </select>
                </div>
            </div>
            <div class="form_group">
                <label>Industry<span style="color: red;">*</span></label>
                <div class="form_feild">
                    <select name="industry" id="industry" class="country-select edit-field-company-information">
                        <option value="">Please select Industry</option>
                        <?php $__currentLoopData = $industry_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $industry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($industry->id); ?>" <?php if(@$data->industry ==$industry->id): ?> selected <?php endif; ?>><?php echo e($industry->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="save_discard div-button-company-information">
                <button type="button" class="discard_btn discard-button-company-information">DISCARD</button>
                <button type="submit" class="save_btn save-button-company-information">SAVE</button>
            </div>
        </form>
    </div>
</div>


<script>
    var oldCompanyInformation = $("form[name='customer_company-information']").serialize();
    // Function to set value to the input or select field
    function setFieldValue(fieldName, value) {
        var field = document.querySelector(`[name="${fieldName}"]`);
        if (field) {
            if (field.tagName === "INPUT") {
                field.value = value;
            } else if (field.tagName === "SELECT") {
                // Find the option with the given value and set it as selected
                var option = field.querySelector(`option[value="${value}"]`);
                if (option) {
                    option.selected = true;
                }
            }
        }
    }
    //editFieldCompanyInformation
    function editFieldCompanyInformation(status) {
        const editFields = document.querySelectorAll('.edit-field-company-information');
        editFields.forEach((element) => {
            element.disabled = status;
        });
        if (status == false) {
            $('.edit-button-company-information').hide();
            $('.div-button-company-information').show();
            $('#company').focus();
        } else {
            $('.edit-button-company-information').show();
            $('.div-button-company-information').hide();
        }
    }
    //default
    editFieldCompanyInformation(true);
    //edit button
    $(document).on('click', '.edit-button-company-information', function() {
        editFieldCompanyInformation(false);
    });

    //data submit
    jQuery(function() {
        jQuery("form[name='customer_company-information']").validate({
            rules: {
                company: {
                    required: true,
                    maxlength: 101,
                    minlength: 2
                },
                country: "required",
                no_of_employee: "required",
                industry: "required",
                state: {
                    required: function() {
                        if ($("#country").val() == 'IN') {
                            return true;
                        }
                        return false;
                    }
                },
                city: {
                    required: true,
                    minlength: 2,
                    maxlength: 51
                },
                address: {
                    required: true,
                    minlength: 2,
                    maxlength: 101
                },
                pincode: {
                    required:function() {
                        if($("#country").val()=='AE'){
                            return false;
                        }
                        return true;
                    },
                    digits: true,
                    minlength: 6,
                    maxlength: 6
                }
            },
            // Specify validation error messages
            messages: {
                company: {
                    required: "Please enter registered company name",
                    maxlength: "Registered company name must be less then 100 characters long.",
                    minlength: "Registered company name must be greater then 2 characters long."
                },
                country: "Please select country",
                state: "Please select state",
                no_of_employee: "Please select No of employee",
                industry: "Please select industry",
                city: {
                    required: "Please enter city name",
                    maxlength: "City name must be less then 50 characters long.",
                    minlength: "City name must be greater then 2 characters long."
                },
                address: {
                    required: "Please enter address",
                    maxlength: "Address must be less then 50 characters long.",
                    minlength: "Address must be greater then 2 characters long."
                },
                pincode: {
                    required: "Please enter Pincode/Zipcode",
                    minlength: "Pincode/Zipcode must be 6 digits long.",
                    maxlength: "Pincode/Zipcode must be 6 digits long.",
                    digits: "Pincode/Zipcode must be digits."
                }
            },
            submitHandler: function(form) {
                var formData = $("form[name='customer_company-information']").serialize();
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route('customer.profile.company-information.update')); ?>",
                    data: formData,
                    success: function(response) {
                        oldCompanyInformation = formData;
                        editFieldCompanyInformation(true);
                        AlertMassage(response.message);
                        $('#company-information-value').val(5);
                        ProgressGraphStatus();
                    },
                    error: function(xhr, status, error) {
                        AlertMassage(`<?php echo e(\App\Providers\MessageManagementProvider::MessageManage('customer-profile-something-wrong')); ?>`);
                    }
                });
            }
        });
    });
    //discard button
    $(document).on('click', '.discard-button-company-information', function() {
        var params = new URLSearchParams(oldCompanyInformation);

        // Set values for each form field using the extracted values
        setFieldValue("company", params.get("company"));
        setFieldValue("country", params.get("country"));
        setFieldValue("state", params.get("state"));
        setFieldValue("city", params.get("city"));
        setFieldValue("address", params.get("address"));
        setFieldValue("pincode", params.get("pincode"));
        setFieldValue("no_of_employee", params.get("no_of_employee"));
        setFieldValue("industry", params.get("industry"));

        editFieldCompanyInformation(true);
    });
    //state hide
    $('#country').on('click', function() {
        if ($(this).val() == 'IN') {
            $('.state-div').show();
        } else {
            $('.state-div').hide();
        }
        if($(this).val()=='AE'){
            $('.pincode-div').hide();
        }else{
            $('.pincode-div').show();
        }
    });

</script>
<?php /**PATH /home/projectsdemo/public_html/aurobees/resources/views/frontend/customer/profile/company-information.blade.php ENDPATH**/ ?>