<?php

namespace App\Console\Commands;

use App\Models\CustomerNotification;
use Illuminate\Console\Command;
use stdClass;
use Illuminate\Support\Facades\Log;
use App\Providers\EmailProvider;
use App\Models\EmailNotification;
use App\Models\Subscription;
use Carbon\Carbon;

class CheckSubscriptionExpireAndSendEmail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'check-subscription-expire-and-send-email:daily';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Check Subscription Expire And Send Email';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try{
            $list=EmailNotification::where('slug','user-subscription-before-expire-notification')->first();
            $days=$list->description;
            if($days>0){
                $newDateTime = Carbon::now()->addDays($days)->toDateString();
                $subscriptionList=Subscription::whereDate('end_at','<=',$newDateTime)->where('status','Active')->where('upgrade_status','0')->get();
                foreach($subscriptionList as $data){
                    $email=$data['User']['email'];
                    $value=new stdClass();
                    $value->f_name=$data['User']['f_name'];
                    $value->l_name=$data['User']['l_name'];
                    $value->email=$data['User']['email'];
                    $value->amount=$data->grand_amount;
                    $value->futureDate=$data->end_at;
                    $value->currentDate=$data->start_at;
                    $value->currency_code=$data->currency_code;
                    $value->subscription_name=$data['Pricing']['LOB']['title'];
                    $value->plan_name=$data->plan_name;
                    $value->plan_duration=$data->plan_duration;

                    //customer notification
                    $checkNotification=CustomerNotification::where('subscription_id',$data->id)->count();
                    if($checkNotification==0){
                        $item= new CustomerNotification();
                        $item->subscription_id = $data->id;
                        $item->user_id=$data->user_id;
                        $item->notification=$data['Pricing']['LOB']['title'].'('.$data->plan_name.') will be expired on '.$data->end_at.' Renew your subscription in time to avoid any disruptions.';
                        $item->save();
                    }
                    if($data->plan_name=='Free-Trial'){
                        //customer Email free Trial
                        EmailProvider::Email('user_subscription_before_expire_notification_for_free_trial', $email, $value );
                    }else{
                        //customer Email paid
                        EmailProvider::Email('user_subscription_before_expire_notification_for_paid', $email, $value );
                    }
                }
            }
        }catch(\Exception $e){
            Log::error('check-subscription-expire-and-send-email:daily: '.$e);
        }
    }
}




//php artisan check-subscription-expire-and-send-email:daily
