<?php

namespace App\Exports;

use App\Models\Subscription;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use DB;

class AdminBillingExport implements FromView
{
    public function view(): View
    {
        try{
            $todayDate = Carbon::now()->format('d-m-Y');
            // $datas=Subscription::orderBy('id','DESC')->get();
            $datas = Subscription::select(
                'subscriptions.id',
                'subscriptions.serial_number',
                'subscriptions.plan_name',
                'subscriptions.plan_duration',
                'subscriptions.quantity',
                'subscriptions.partner_commission_percentage',
                'subscriptions.partner_commission_amount',
                'subscriptions.grand_amount',
                'subscriptions.start_at',
                'subscriptions.end_at',
                'subscriptions.status',
                'users.f_name', 
                'users.l_name',
                'users.partner_code',
                'users.company',
                DB::raw('CONCAT_WS(" ", users.f_name, users.l_name) as name'),
                'industries.title as industry_title'
            )
            ->join('users', 'subscriptions.user_id', '=', 'users.id')
            ->join('pricings', 'subscriptions.plan_id', '=', 'pricings.id')
            ->join('industries', 'pricings.lob_id', '=', 'industries.id')
            ->with('OrderMeta')
            ->orderBy('subscriptions.id', 'DESC')
            ->get();

            return view('backend.operation.billing.excel',compact('datas','todayDate') );
        }catch(\Exception $e){
            return redirect()->back();
        }
    }
}
