<?php

namespace App\Exports;

use App\Models\Subscription;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class AdminSubscriptionExport implements FromView
{
    public $datas;

    public function __construct($datas)
    {
        $this->datas = $datas;
    }

    public function view(): View
    {
        try{
            $todayDate = Carbon::now()->format('d-m-Y');
            $datas=$datas = $this->datas;
            return view('backend.operation.subscription.excel',compact('datas','todayDate') );
        }catch(\Exception $e){
            return redirect()->back();
        }
    }
}
