<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Models\Subscription;
use Illuminate\Contracts\View\View;
use DB;

class SubscriptionExportForPartner implements FromView
{
    public function view(): View
    {
        try{
            $todayDate = Carbon::now()->format('d-m-Y');
            $dt=Carbon::now();
            $datas=Subscription::select(
                'subscriptions.id',
                'subscriptions.serial_number',
                'users.partner_code',
                'users.company',
                DB::raw('CONCAT_WS(" ", users.f_name, users.l_name) as name'),
                'subscriptions.plan_name',
                'subscriptions.plan_duration',
                'subscriptions.currency_code',
                'subscriptions.plan_rate',
                'subscriptions.addon_rate',
                'subscriptions.rate',
                'subscriptions.quantity',
                'subscriptions.plan_total_rate',
                'subscriptions.addon_total_rate',
                'subscriptions.total_rate',
                'subscriptions.tax',
                'subscriptions.tax_percentage',
                'subscriptions.tax_name',
                'subscriptions.grand_amount',
                'subscriptions.start_at',
                'subscriptions.end_at',
                'subscriptions.status',
                'subscriptions.remarks',
                'subscriptions.partner_commission_percentage',
                'subscriptions.partner_commission_amount',
                'industries.title as industry_title'
            )->join('users', 'subscriptions.user_id', '=', 'users.id')
            ->join('pricings', 'subscriptions.plan_id', '=', 'pricings.id')
            ->join('industries', 'pricings.lob_id', '=', 'industries.id')
            ->with('OrderMeta')
            ->where('users.partner_code', Auth::user()->code)
            ->orderBy('subscriptions.id', 'DESC')
            ->get();

            return view('frontend.become_a_partner.billing.excel',compact('datas','todayDate') );
        }catch(\Exception $e){
            return redirect()->back();
        }
    }
}
