<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cookie;
use App;
use App\Models\Language;
use Illuminate\Support\Facades\Auth;

class LanguageController extends Controller
{
    public function change(Request $request)
    {
        $minutes = 600*10000000000;
        Cookie::queue('language_select', $request->lang, $minutes);
        return redirect()->back();
    }

    public function index(){
        $datas=Language::all();
        return view('backend.setting.language.index',compact('datas'));
    }

    public function create()
    {
        return view('backend.setting.language.add');
    }

    public function store(Request $request){
        $request->validate([
            'name'=>'required',
            'code'=>'unique:languages|required',
        ]);

        $data    =   new Language();
        $data->name       =   $request->name;
        $data->code     =   trim(strtolower($request->code));
        $data->created_by       =   Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.language.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function edit($id)
    {
        $data       =   Language::find($id);
        return view('backend.setting.language.edit',compact('data'));
    }
    public function update(Request $request, $id){
        $request->validate([
            'name'=>'required',
        ]);

        $data= Language::find($id);
        $data->name       =   $request->name;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.language.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function updateStatus($id){
        $data= Language::find($id);
        $data->status       = ($data->status=='Active')?'Inactive':'Active';
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.language.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
