<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Log;
use Zoom;

class ZoomController extends Controller
{

    function createMeeting($request)
    { 
        $meetings = Zoom::createMeeting([
            "agenda" => $request->title,
            "topic" => $request->title,
            "type" => 2, // 1 => instant, 2 => scheduled, 3 => recurring with no fixed time, 8 => recurring with fixed time
            "duration" => $request->duration, // in minutes
            // "timezone" => 'Asia/Kolkata', // set your timezone
            "password" => random_int(100000, 99999999),
            "start_time" => date('Y-m-d\TH:i:s\Z',strtotime( $request->datetime)),
            // "template_id" => 'set your template id', // set your template id  Ex: "Dv4YdINdTk+Z5RToadh5ug==" from https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meetingtemplates
            "pre_schedule" => false,  // set true if you want to create a pre-scheduled meeting
            "schedule_for" => 'aurobees@gmail.com', // set your schedule for
            "settings" => [
                'join_before_host' => false, // if you want to join before host set true otherwise set false
                'host_video' => false, // if you want to start video when host join set true otherwise set false
                'participant_video' => false, // if you want to start video when participants join set true otherwise set false
                'mute_upon_entry' => false, // if you want to mute participants when they join the meeting set true otherwise set false
                'waiting_room' => false, // if you want to use waiting room for participants set true otherwise set false
                'audio' => 'both', // values are 'both', 'telephony', 'voip'. default is both.
                'auto_recording' => 'none', // values are 'none', 'local', 'cloud'. default is none.
                'approval_type' => 0, // 0 => Automatically Approve, 1 => Manually Approve, 2 => No Registration Required
            ],
        ]);
        Log::info('createMeeting: '.json_encode($meetings));
        return $meetings;

        // {
        //     "status": true,
        //     "data": {
        //       "uuid": "zNF4FIi8T/Sy28K26vJamQ==",
        //       "id": 86441552978,
        //       "host_id": "DF5-c0xySLm3csK34wFuLw",
        //       "host_email": "aurobees@gmail.com",
        //       "topic": "your topic",
        //       "type": 2,
        //       "status": "waiting",
        //       "start_time": "2024-10-14T06:45:24Z",
        //       "duration": 60,
        //       "timezone": "Asia/Kolkata",
        //       "agenda": "your agenda",
        //       "created_at": "2024-10-14T06:45:24Z",
        //       "start_url": "https://us05web.zoom.us/s/86441552978?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMSIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJpc3MiOiJ3ZWIiLCJjbHQiOjAsIm1udW0iOiI4NjQ0MTU1Mjk3OCIsImF1ZCI6ImNsaWVudHNtIiwidWlkIjoiREY1LWMweHlTTG0zY3NLMzR3RnVMdyIsInppZCI6Ijk2ZDU2OWIwODdiNjRmNGU4Y2FiOTUyOTk4MGE2NzFkIiwic2siOiIwIiwic3R5IjoxLCJ3Y2QiOiJ1czA1IiwiZXhwIjoxNzI4ODk1NTI1LCJpYXQiOjE3Mjg4ODgzMjUsImFpZCI6ImJsRzBqNE03U0NXZXYwNmVtenk0UVEiLCJjaWQiOiIifQ.kwZO_qCLAWvpYZDuHiCCrn_H034Vsme4K7qzarEflYU",
        //       "join_url": "https://us05web.zoom.us/j/86441552978?pwd=cVLjUM7aRdvcYQFwCza3o6RdMGION3.1",
        //       "password": "12345668",
        //       "h323_password": "12345668",
        //       "pstn_password": "12345668",
        //       "encrypted_password": "cVLjUM7aRdvcYQFwCza3o6RdMGION3.1",
        //       "settings": {
        //         "host_video": false,
        //         "participant_video": false,
        //         "cn_meeting": false,
        //         "in_meeting": false,
        //         "join_before_host": false,
        //         "jbh_time": 0,
        //         "mute_upon_entry": false,
        //         "watermark": false,
        //         "use_pmi": false,
        //         "approval_type": 2,
        //         "audio": "both",
        //         "auto_recording": "none",
        //         "enforce_login": false,
        //         "enforce_login_domains": "",
        //         "alternative_hosts": "",
        //         "alternative_host_update_polls": false,
        //         "close_registration": false,
        //         "show_share_button": false,
        //         "allow_multiple_devices": false,
        //         "registrants_confirmation_email": true,
        //         "waiting_room": false,
        //         "request_permission_to_unmute_participants": false,
        //         "registrants_email_notification": true,
        //         "meeting_authentication": false,
        //         "encryption_type": "enhanced_encryption",
        //         "approved_or_denied_countries_or_regions": {
        //           "enable": false
        //         },
        //         "breakout_room": {
        //           "enable": false
        //         },
        //         "internal_meeting": false,
        //         "continuous_meeting_chat": {
        //           "enable": false,
        //           "auto_add_invited_external_users": false,
        //           "auto_add_meeting_participants": false
        //         },
        //         "participant_focused_meeting": false,
        //         "push_change_to_calendar": false,
        //         "resources": [],
        //         "alternative_hosts_email_notification": true,
        //         "show_join_info": false,
        //         "device_testing": false,
        //         "focus_mode": false,
        //         "meeting_invitees": [],
        //         "enable_dedicated_group_chat": false,
        //         "private_meeting": false,
        //         "email_notification": true,
        //         "host_save_video_order": false,
        //         "sign_language_interpretation": {
        //           "enable": false
        //         },
        //         "email_in_attendee_report": false
        //       },
        //       "pre_schedule": false
        //     }
        //   }
    }

    function UpdateMeeting($request){
        $meeting = Zoom::updateMeeting($request['id'], [
            "agenda" => $request['title'],
            "topic" => $request['title'],
            // "type" => 2, // 1 => instant, 2 => scheduled, 3 => recurring with no fixed time, 8 => recurring with fixed time
            // "duration" => 60, // in minutes
            // "timezone" => 'Asia/Dhaka', // set your timezone
            // "password" => 'set your password',
            // "start_time" => 'set your start time', // set your start time
            // "template_id" => 'set your template id', // set your template id  Ex: "Dv4YdINdTk+Z5RToadh5ug==" from https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meetingtemplates
            // "pre_schedule" => false,  // set true if you want to create a pre-scheduled meeting
            // "schedule_for" => 'set your schedule for profile email ', // set your schedule for
            // "settings" => [
            //     'join_before_host' => false, // if you want to join before host set true otherwise set false
            //     'host_video' => false, // if you want to start video when host join set true otherwise set false
            //     'participant_video' => false, // if you want to start video when participants join set true otherwise set false
            //     'mute_upon_entry' => false, // if you want to mute participants when they join the meeting set true otherwise set false
            //     'waiting_room' => false, // if you want to use waiting room for participants set true otherwise set false
            //     'audio' => 'both', // values are 'both', 'telephony', 'voip'. default is both.
            //     'auto_recording' => 'none', // values are 'none', 'local', 'cloud'. default is none.
            //     'approval_type' => 0, // 0 => Automatically Approve, 1 => Manually Approve, 2 => No Registration Required
            // ],

        ]);
        Log::info('UpdateMeeting: '.json_encode($meeting));
        return $meeting;
    }

    function rescheduleMeeting($request){
        $meetings = Zoom::rescheduleMeeting($request['id'], [
            "agenda" => $request['title'],
            "topic" => $request['title'],
            "type" => 2, // 1 => instant, 2 => scheduled, 3 => recurring with no fixed time, 8 => recurring with fixed time
            "duration" => $request['duration'], // in minutes
            // "timezone" => 'Asia/Kolkata', // set your timezone
            // "password" => 'set your password',
            "start_time" => date('Y-m-d\TH:i:s\Z', strtotime($request['datetime'])),
            // "template_id" => 'set your template id', // set your template id  Ex: "Dv4YdINdTk+Z5RToadh5ug==" from https://marketplace.zoom.us/docs/api-reference/zoom-api/meetings/meetingtemplates
            "pre_schedule" => false,  // set true if you want to create a pre-scheduled meeting
            "schedule_for" => 'aurobees@gmail.com', // set your schedule for
            "settings" => [
                'join_before_host' => false, // if you want to join before host set true otherwise set false
                'host_video' => false, // if you want to start video when host join set true otherwise set false
                'participant_video' => false, // if you want to start video when participants join set true otherwise set false
                'mute_upon_entry' => false, // if you want to mute participants when they join the meeting set true otherwise set false
                'waiting_room' => false, // if you want to use waiting room for participants set true otherwise set false
                'audio' => 'both', // values are 'both', 'telephony', 'voip'. default is both.
                'auto_recording' => 'none', // values are 'none', 'local', 'cloud'. default is none.
                'approval_type' => 0, // 0 => Automatically Approve, 1 => Manually Approve, 2 => No Registration Required
            ],

        ]);
        Log::info('date: '.json_encode( Carbon::parse($request['datetime'], 'Asia/Kolkata')->setTimezone('UTC')->format('Y-m-d\TH:i:s\Z')));
        Log::info('rescheduleMeeting: '.json_encode($meetings));
        return $meetings;
    }

    function deleteMeeting($request){
        $meetings = Zoom::deleteMeeting($request->meetingId);
    }

}