<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use App\Models\CallingCode;
use App\Models\CountryList;
use App\Models\StateList;
use App\Models\Subscription;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use App\Providers\MessageManagementProvider;
use Mail;
use DataTables;

class CustomerManagementController extends Controller
{
    public function index(Request $request)
    {
        if($request->ajax()){
            $products = User::select('*')->where('status','N')->where('role','Customer')->orderBy('id','DESC');

            return DataTables::of($products)
                ->addColumn('action', function($data) {
                    return '
                        <a href="'.route('admin.customer.edit', $data->id).'" class="btn btn-rounded btn-info"><i class="fas fa-edit"></i></a>
                        <a href="'.route('admin.customer.show',$data->id).'"  class="btn btn-rounded btn-success"><i class="fas fa-eye"></i></a>
                        <a href="'.route('admin.customer.delete', $data->id).'" onclick="return confirm(\'Are you sure you want to delete this item?\');" class="btn btn-rounded btn-danger"><i class="fas fa-trash"></i></a>
                    ';
                })
                ->editColumn('is_email_verified', function($data) {
                    return $data->is_email_verified == 1 ? 'Yes' : 'No';
                })
                ->editColumn('created_at', function($data) {
                    return date('Y-m-d H:i:s', strtotime($data->created_at));
                })
                ->addIndexColumn()
                ->rawColumns(['action'])  // Allow HTML in the 'action' column
                ->make(true);
        }
        
        return view('backend.customer.index');
    }

    public function show($id)
    {
        $data=User::find($id);
        return view('backend.customer.show',compact('data'));
    }

    public function edit($id)
    {
        //---------------------------------------------------------------
        $country_list = CountryList::all();
        $state_list = StateList::all();
        $calling_code_list=CallingCode::all();
        //-------------------------------------------------------------------
        $data=User::find($id);
        return view('backend.customer.edit',compact('data','country_list','state_list','calling_code_list'));
    }

    public function update(Request $request, $id)
    {
        $validateData=$request->validate([

            'email'=>'required|unique:users,email,'.$id,
            'f_name'=>'required|min:2',
            'l_name'=>'required|min:2',
            'company'=>'required|min:2',
            'country'=>'required|min:2',
            'calling_code'=>'required',
            'phone' => 'required|numeric',
            'pincode' => strtolower($request->country) === 'ae' ? 'nullable' : 'required|numeric',
            'statelist' => strtolower($request->country) === 'in' ? 'required' : 'nullable',
        ]);

        $data= User::find($id);
        $data->f_name=ucwords($request->f_name);
        $data->l_name=ucwords($request->l_name);
        $data->phone=$request->phone;
        $data->email=$request->email;
        $data->company=$request->company;
        $data->country=$request->country;
        $data->state=($request->country=='IN')?$request->statelist:NULL;
        $data->city=$request->city;
        $data->address=$request->address;
        $data->pincode=($request->country=='AE')?Null:$request->pincode;
        $data->calling_code=$request->calling_code;  
        $data->partner_code=$request->partner_code;
        $data->updated_by=Auth::user()->id;
        $data->save();

        $notification=array(
            'message'=>'Customer Update Successfully!!',
            'alert-type'=>'info'
        );
        return redirect()->route('admin.customer.view')->with($notification);
    }

    public function destroy($id)
    {
        $checkSubscription=Subscription::where('user_id',$id)->count();
        if($checkSubscription==0){
        $data=User::find($id);
        $result=$data->delete();
        }else{
            $notification=array(
                'message'=>'User does not delete!!',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }
        // $data->deleted_by=Auth::user()->id;
        // $data->status='Y';
        // $data->deleted_datetime=date('Y-m-d H:i:s');
        // $result=$data->update();

        $notification=array(
            'message'=>'Customer Delete Successfully!!',
            'alert-type'=>'info'
        );
        return redirect()->route('admin.customer.view')->with($notification);
    }

    public function inActiveUser()
    {
        $datas=User::where('status','Y')->where('role','Customer')->get();
        return view('backend.customer.inactive',compact('datas'));
    }

    public function inActiveUserEdit($id)
    {
        // $data=User::find($id);
        // $data->updated_by=Auth::user()->id;
        // $data->status='N';
        // $result=$data->update();
        // $result=$data->delete();
        $checkSubscription=Subscription::where('user_id',$id)->count();
        if($checkSubscription==0){
            $data=User::find($id);
            $result=$data->delete();
        }else{
            $notification=array(
                'message'=>'User does not delete!!',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }
        $notification=array(
            'message'=>'Customer Active Successfully!!',
            'alert-type'=>'info'
        );
        return redirect()->route('admin.customer.inactive.view')->with($notification);
    }

}
