<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PricingAddons;
use App\Models\PricingFeature;
use App\Models\Pricing;
use App\Models\CountryList;
use App\Models\CurrencyList;
use App\Models\PricingAddonesPrice;
use Illuminate\Support\Facades\Auth;

class PricingAddonsController extends Controller
{
    public function index($id){
        $parent=PricingFeature::find($id);
        $datas=PricingAddons::where('pricing_features_id',$id)->get();
        return view('backend.pricing.addons',compact('datas','id','parent'));
    }

    public function create($id)
    {
        $parent=PricingFeature::find($id);
        $country_list = CountryList::all();
        $currency_list = CurrencyList::all();
        return view('backend.pricing.addons_add',compact('id','parent','country_list', 'currency_list'));
    }

    public function store(Request $request, $id){
        $validated = $request->validate([
            'name'=>'required',
        ]);
        $feature=PricingFeature::find($id);

        $data=new PricingAddons();
        $data->name=$request->name;
        $data->pricing_id=$feature->pricing_id;
        $data->pricing_features_id=$id;
        $data->free_trial=$request->free_trial;
        $data->basic=$request->basic;
        $data->advance=$request->advance;
        $data->go_ecommerce=$request->go_ecommerce;
        $data->created_by=Auth::user()->id;
        $result=$data->save();
        $parent_id = $data->id;

        //addons price
        if($request->plan_type){
            foreach ($request->plan_type as $key => $value) {
                $country = explode('#', $request['country'][$key]);
                $country_code = $country[0];
                $country_name = $country[1];

                $child = new PricingAddonesPrice();
                $child->pricing_addon_id = $parent_id;
                $child->plan_type = $request['plan_type'][$key];
                $child->country_code = $country_code;
                $child->country_name = $country_name;
                $child->currency = $request['currency'][$key];
                $child->monthly = $request['monthly'][$key];
                $child->quaterly = $request['quaterly'][$key];
                $child->yearly = $request['yearly'][$key];
                $child->save();
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('pricing.addons',$id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function edit($feature_id, $id){
        $data=PricingAddons::find($id);
        $parent=PricingFeature::find($feature_id);
        $pricingAddonsList=PricingAddonesPrice::where('pricing_addon_id', $id)->get();
        $country_list = CountryList::all();
        $currency_list = CurrencyList::all();

        return view('backend.pricing.addons_edit',compact('id','parent','data','feature_id', 'pricingAddonsList', 'country_list', 'currency_list'));
    }

    public function update(Request $request,$feature_id, $id){
        $validated = $request->validate([
            'name'=>'required',
        ]);

        $data=PricingAddons::find($id);
        $data->name=$request->name;
        $data->free_trial=$request->free_trial;
        $data->basic=$request->basic;
        $data->advance=$request->advance;
        $data->go_ecommerce=$request->go_ecommerce;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        //addons price
        PricingAddonesPrice::where('pricing_addon_id', $id)->delete();
        if($request->plan_type){
            foreach ($request->plan_type as $key => $value) {
                $country = explode('#', $request['country'][$key]);
                $country_code = $country[0];
                $country_name = $country[1];

                $child = new PricingAddonesPrice();
                $child->pricing_addon_id = $id;
                $child->plan_type = $request['plan_type'][$key];
                $child->country_code = $country_code;
                $child->country_name = $country_name;
                $child->currency = $request['currency'][$key];
                $child->monthly = $request['monthly'][$key];
                $child->quaterly = $request['quaterly'][$key];
                $child->yearly = $request['yearly'][$key];
                $child->save();
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('pricing.addons',$feature_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function delete($feature_id, $id){
        $data       =   PricingAddons::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
            PricingAddonesPrice::where('pricing_addon_id', $id)->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
