<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use App\Models\CountryList;
use App\Models\CurrencyList;
use Illuminate\Http\Request;
use App\Models\Pricing;
use App\Models\Industries;
use App\Models\Language;
use App\Models\PlanPricing;
use App\Models\PricingFeature;
use App\Models\Subscription;
use App\Models\SubscriptionItem;
use Intervention\Image\Facades\Image;

class PricingController extends Controller
{
    public function index(){
        $pricing = Pricing::all();
        return view('backend.pricing.index', compact('pricing'));
    }

    public function create(){
        $country_list = CountryList::all();
        $currency_list = CurrencyList::all();
        $industries     =   Industries::where('language','en')->get();
        $languages      =   Language::all();

        return view('backend.pricing.add', compact('languages', 'industries', 'country_list', 'currency_list'));
    }

    public function store(Request $request){
        $request->validate([
            'lob_id'  => 'required',
            'language'  => 'required',
            'image' => 'nullable|mimes:jpg,png,jpeg,gif,svg',
        ]);

        $check_data=Pricing::where('lob_id',$request->lob_id)->where('language',$request->language)->count();
        if ($check_data) {
            $notification = array(
                'message' => 'Title already exists!!.',
                'alert-type' => 'warning'
            );
            return redirect()->back()->with($notification);
        }


        $data                       =   new Pricing();
        //-------------------------------------------------
        $image_name     =   $request->file('image');
        $name_gen       =   hexdec(uniqid()) . '.' . $image_name->getClientOriginalExtension();
        $path           =   public_path('upload/price/' . $name_gen);
        Image::make($image_name->getRealPath())->save($path);
        $last_img       =   'upload/price/' . $name_gen;
        $data->image            =   $last_img;
        //-------------------------------------------------
        $data->content              =   $request->content;
        $data->lob_id               =   $request->lob_id;
        $data->language             =   $request->language;
        $data->short_name             =   $request->short_name;

        $data->free_trial_content       =   $request->free_trial_content;
        $data->basic_content       =   $request->basic_content;
        $data->advance_content       =   $request->advance_content;
        $data->ecom_content       =   $request->ecom_content;
        $data->ecom_minimum_order_text       =   $request->ecom_minimum_order_text;

        $data->free_trial_text       =   $request->free_trial_text;
        $data->basic_text       =   $request->basic_text;
        $data->basic_recommended       =   $request->basic_recommended;
        $data->advance_text       =   $request->advance_text;
        $data->advance_recommended       =   $request->advance_recommended;
        $data->ecom_text       =   $request->ecom_text;
        $data->ecom_recommended       =   $request->ecom_recommended;

        $data->meta_keywords        =   $request->meta_key;
        $data->meta_title           =   $request->meta_title;
        $data->meta_description     =   $request->meta_description;
        $result                     =   $data->save();
        $parent_id = $data->id;
        if($request->language=='en'){
            foreach ($request->plan_type as $key => $value) {
                $country = explode('#', $request['country'][$key]);
                $country_code = $country[0];
                $country_name = $country[1];

                $child = new PlanPricing();
                $child->price_id = $parent_id;
                $child->plan_type = $request['plan_type'][$key];
                $child->country_code = $country_code;
                $child->country_name = $country_name;
                $child->currency = $request['currency'][$key];
                $child->monthly = $request['monthly'][$key];
                $child->quaterly = $request['quaterly'][$key];
                $child->yearly = $request['yearly'][$key];
                $child->no_of_order = $request['no_of_order'][$key];
                $child->save();
            }
        }
        if ($result) {
            $notification = array(
                'message' => 'Record Created Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('pricing.index')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function edit($id){
        $country_list = CountryList::all();
        $currency_list = CurrencyList::all();
        $industries     =   Industries::where('language','en')->get();
        $languages      =   Language::all();
        $data           =   Pricing::find($id);
        $plan_pricing           =   PlanPricing::where('price_id', $id)->get();
        return view('backend.pricing.edit', compact('languages', 'industries', 'data', 'country_list', 'plan_pricing', 'currency_list'));
    }


    public function update(Request $request, $id){
        $request->validate([
            'lob_id'  => 'required',
            'language'  => 'required',
            'image' => 'nullable|mimes:jpg,png,jpeg,gif,svg',
        ]);
        $old_image = $request->old_image;


        $check_data=Pricing::where('id','!=' ,$id)->where('lob_id',$request->lob_id)->where('language',$request->language)->count();
        if ($check_data) {
            $notification = array(
                'message' => 'Title already exists!!.',
                'alert-type' => 'warning'
            );
            return redirect()->back()->with($notification);
        }


        $data                       =   Pricing::find($id);
        //-------------------------------------------------
        $image_name     =   $request->file('image');
        if ($image_name) {
            $name_gen       =   hexdec(uniqid()) . '.' . $image_name->getClientOriginalExtension();
            $path           =   public_path('upload/price/' . $name_gen);
            Image::make($image_name->getRealPath())->save($path);
            $last_img       =   'upload/price/' . $name_gen;
            $data->image            =   $last_img;
            if ($old_image) {
                @unlink($old_image);
            }
        }
        //-------------------------------------------------

        $data->content              =   $request->content;
        $data->lob_id               =   $request->lob_id;
        $data->language             =   $request->language;
        $data->short_name             =   $request->short_name;
        $data->free_trial_content   =   $request->free_trial_content;
        $data->basic_content        =   $request->basic_content;
        $data->advance_content      =   $request->advance_content;
        $data->ecom_content         =   $request->ecom_content;
        $data->ecom_minimum_order_text       =   $request->ecom_minimum_order_text;

        $data->free_trial_text       =   $request->free_trial_text;
        $data->basic_text       =   $request->basic_text;
        $data->basic_recommended       =   $request->basic_recommended;
        $data->advance_text       =   $request->advance_text;
        $data->advance_recommended       =   $request->advance_recommended;
        $data->ecom_text       =   $request->ecom_text;
        $data->ecom_recommended       =   $request->ecom_recommended;

        $data->meta_keywords        =   $request->meta_key;
        $data->meta_title           =   $request->meta_title;
        $data->meta_description     =   $request->meta_description;
        $data->status               =   $request->status;
        $result                     =   $data->update();
        if($request->language=='en'){
            PlanPricing::where('price_id', $id)->delete();
            foreach ($request->plan_type as $key => $value) {
                $country = explode('#', $request['country'][$key]);
                $country_code = $country[0];
                $country_name = $country[1];

                $child = new PlanPricing();
                $child->price_id = $id;
                $child->plan_type = $request['plan_type'][$key];
                $child->country_code = $country_code;
                $child->country_name = $country_name;
                $child->currency = $request['currency'][$key];
                $child->monthly = $request['monthly'][$key];
                $child->quaterly = $request['quaterly'][$key];
                $child->yearly = $request['yearly'][$key];
                $child->no_of_order = $request['no_of_order'][$key];
                $child->save();
            }
        }

        if ($result) {
            $notification = array(
                'message' => 'Record Updated Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('pricing.index')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy($id){
        $data       =   Pricing::find($id);
        if($data->status=='Trash'){
            $dataCheck=PricingFeature::where('pricing_id',$id)->count();
            $dataSubscriptionItem=Subscription::where('plan_id',$id)->count();
            if($dataCheck==0 && $dataSubscriptionItem==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category or Subscription associated with this Lob !!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status = 'Trash';
            $result = $data->update();
        }

        if (@$result) {
            $notification = array(
                'message' => 'Record Deleted Successfully!!',
                'alert-type' => 'success'
            );
            return redirect()->route('pricing.index')->with($notification);
        } else {
            $notification = array(
                'message' => 'Unable to save the data, Please try again later!!',
                'alert-type' => 'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
