<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PricingFeature;
use App\Models\PricingAddons;
use App\Models\Pricing;
use Illuminate\Support\Facades\Auth;

class PricingFeatureController extends Controller
{
    public function index($id){
        $parent=Pricing::find($id);
        $datas=PricingFeature::where('pricing_id',$id)->get();
        return view('backend.pricing.feature',compact('datas','id','parent'));
    }

    public function create($id)
    {
        $parent=Pricing::find($id);
        return view('backend.pricing.feature_add',compact('id','parent'));
    }


    public function store(Request $request, $id){
        $validated = $request->validate([
            'name'=>'required'
        ]);

        $data=new PricingFeature();
        $data->name=$request->name;
        $data->pricing_id=$id;
        $data->created_by=Auth::user()->id;
        $result=$data->save();
        if(@$result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('pricing.feature',$id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function edit($price_id, $id){
        $data=PricingFeature::find($id);
        $parent=Pricing::find($price_id);
        return view('backend.pricing.feature_edit',compact('id','parent','data','price_id'));
    }

    public function update(Request $request,$price_id, $id){
        $validated = $request->validate([
            'name'=>'required'
        ]);
        $data=PricingFeature::find($id);
        $data->name=$request->name;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if(@$result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('pricing.feature',$price_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function delete($price_id, $id){
        $data       =   PricingFeature::find($id);
        if($data->status=='Trash'){
            $data_check=PricingAddons::where('pricing_features_id',$id)->count();
            if($data_check==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete assigned category.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
