<?php

namespace App\Http\Controllers\backend\operation;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Subscription;
use App\Models\OrderMeta;
use App\Models\Transaction;
use App\Exports\AdminBillingExport;
use Maatwebsite\Excel\Facades\Excel;
use DataTables;
use Illuminate\Support\Facades\DB;
use PDF;
use Illuminate\Support\Facades\Log;

class LobBillingDetailController extends Controller
{
    public function index(Request $request){

        if($request->ajax()){
            $products = Subscription::select(
                    'subscriptions.id',
                    'subscriptions.serial_number',
                    'subscriptions.plan_name',
                    'subscriptions.plan_duration',
                    'subscriptions.quantity',
                    'subscriptions.partner_commission_percentage',
                    'subscriptions.partner_commission_amount',
                    'subscriptions.grand_amount',
                    'subscriptions.start_at',
                    'subscriptions.end_at',
                    'subscriptions.status',
                    'users.f_name', 
                    'users.l_name',
                    'users.partner_code',
                    'users.company',
                    DB::raw('CONCAT_WS(" ", users.f_name, users.l_name) as name'),
                    'industries.title as industry_title'
                )
                ->join('users', 'subscriptions.user_id', '=', 'users.id')
                ->join('pricings', 'subscriptions.plan_id', '=', 'pricings.id')
                ->join('industries', 'pricings.lob_id', '=', 'industries.id')
                ->with('OrderMeta')
                ->orderBy('subscriptions.id', 'DESC');
            
            return DataTables::of($products)
                ->editColumn('status', function($data) {
                    return ($data->plan_name=='Free-Trial')?'Upgrade':'Paid';
                })
                ->addColumn('action', function($data) {
                    return '<a href="'.route('lob.billing.preview',$data->id).'" class="btn btn-outline-success"><i class="fas fa-eye"></i></a>
                        <a href="'.route('lob.billing.pdf',$data->id).'" class="btn btn-outline-warning"><i class="fas fa-download"></i></a>
                    ';
                })
                
                ->addIndexColumn()
                ->rawColumns(['action'])  // Allow HTML in the 'action' column
                ->make(true);
        }
        
        return view('backend.operation.billing.index');
    }

    public function show($id){
        $data=Subscription::find($id);
        return view('backend.operation.billing.view',compact('data'));
    }

    // public function pdf($id){
    //     try{
    //         $data = Subscription::find($id);
    //         if(!$data){  return redirect()->back();}

    //         $orderMeta=OrderMeta::where('subscription_id',$data->id)->get();
    //         $title='Invoice';

    //         if (!$data) {
    //             abort(404, 'Subscription not found.');
    //         }

    //         $datas = [
    //             'title' => $title,
    //             'data' => $data,
    //             'orderMeta'=>$orderMeta
    //         ];

    //         $pdf = PDF::loadView('backend.operation.billing.pdf', $datas);

    //         return $pdf->download('invoice.pdf');
    //         // return $pdf->stream('invoice.pdf');
    //     }catch(\Exception $e){
    //         Log::error('Customer Billing Pdf:'.$e);
    //         return redirect()->back();
    //     }
    // }

    public function pdf($id){
        try{
            $data = Subscription::find($id);
            if(!$data){  return redirect()->back();}

            $orderMeta=OrderMeta::where('subscription_id',$data->id)->get();
            $transaction = Transaction::where('subscription_id', $data->id)->where('status', 'Success')->first();
            $title='Invoice';

            if (!$data) {
                abort(404, 'Subscription not found.'); 
            }

            $datas = [
                'title' => $title,
                'data' => $data,
                'orderMeta'=>$orderMeta,
                'transaction' => $transaction
            ];
            $pdf = PDF::loadView('backend.operation.billing.pdf', $datas)->setPaper('A4', 'landscape');
            return $pdf->download('invoice.pdf');
            
        }catch(\Exception $e){
            Log::error('Customer Billing Pdf:'.$e);
            return redirect()->back();
        }
    }

    public function excel(){
        return Excel::download(new AdminBillingExport, 'billing.xlsx');
    }

}
