<?php

namespace App\Http\Controllers\backend\page\contact_us;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Language;
use Intervention\Image\Facades\Image;
use App\Models\ContactUs;
use App\Models\ContactUsGlobalOffices;
use App\Models\ContactUsGlobalOfficesAddress;

class ContactUsGlobalOfficesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($contact_us_id)
    {
        $datas=ContactUsGlobalOffices::where('contact_us_id',$contact_us_id)->get();
        return view('backend.page.contact-us.global-office.index',compact('datas','contact_us_id'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($contact_us_id)
    {
        return view('backend.page.contact-us.global-office.add',compact('contact_us_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request,$contact_us_id)
    {
        $request->validate([
            'title'=>'required',
        ]);

        $data    =   new ContactUsGlobalOffices();
        $data->contact_us_id =   $contact_us_id;
        $data->title       =   $request->title;
        $data->created_by       =   Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.contact-us.global-office.list',$contact_us_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($contact_us_id,$id)
    {
        $data       =   ContactUsGlobalOffices::find($id);
        return view('backend.page.contact-us.global-office.edit',compact('data','contact_us_id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $contact_us_id, $id)
    {
        $request->validate([
            'title'=>'required',
        ]);

        $data    = ContactUsGlobalOffices::find($id);
        $data->title       =   $request->title;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.contact-us.global-office.list',$contact_us_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($contact_us_id,$id)
    {
        $data       =   ContactUsGlobalOffices::find($id);
        if($data->status=='Trash'){
            $dataCheck=ContactUsGlobalOfficesAddress::where('contact_us_global_office_id',$id)->count();
            if($dataCheck==0 ){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
