<?php

namespace App\Http\Controllers\backend\page\event;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use App\Models\EventDate;
use App\Models\EventFormData;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;
use App\Models\Language;
use Str;
use DataTables;
use App\Http\Controllers\ZoomController;

class EventDateController extends ZoomController
{
    public function index(Request $request){
        if($request->ajax()){
            $products = EventDate::select('*')->orderBy('id','DESC');

            return DataTables::of($products)
                ->addColumn('action', function($data) {
                    $html ='<a href="'.route('page.event.event-form-data.list',$data->id).'" class="btn btn-outline-info mx-1">Registered User</a>';
                    $html .='<a href="'.route('page.event.event-date.edit',$data->id).'" class="btn btn-outline-info mx-1"><i class="fas fa-edit"></i></a>';
                    if($data->post_status=='Trash'){
                        $html .='<a href="'.route('page.event.event-date.delete',$data->id).'" onclick="return confirm(\'Are you sure you want to delete this item?\');" class="btn btn-outline-danger mx-1"  title="Permanently delete"><i class="fas fa-trash"></i></a>';
                    }else{
                        $html .='<a href="'.route('page.event.event-date.delete',$data->id).'" onclick="return confirm(\'Are you sure you want to trash this item?\');" class="btn btn-outline-warning mx-1" title="Trash Item"><i class="fas fa-trash"></i></a>';
                    }
                    return $html;
                })
                ->addIndexColumn()
                ->rawColumns(['action'])  // Allow HTML in the 'action' column
                ->make(true);
        }

        return view('backend.page.event.event-date.index');
    }

    public function create(){
        $languages      =   Language::all();
        $defaultLanguagePagesList=EventDate::where('language','en')->where('status','Published')->get();
        return view('backend.page.event.event-date.add',compact('languages','defaultLanguagePagesList'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'pdf'=>'nullable|mimes:pdf',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'thumbnail_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'datetime'=>'required',
            'duration'=>'required',
            'meeting_type'=>'required',
            'meeting_link'=>'required',
        ]);
        if($request->language !='en'){
            $check_data=EventDate::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        //create zoom meeting
        $meetings=$this->createMeeting($request);
        if(@$meetings['status']){

            $data    =   new EventDate();
            //--------------------------------------
            if($request->media_type=='Image'){
                $image_name     =   $request->file('image');
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/event/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/event/'.$name_gen;
                    $data->image            =   $last_img;
                }else{
                    $notification=array(
                        'message'=>'Please Upload Image',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->media_type=='Video'){
                if($request->video_type=='MP4'){
                    $video = $request->file('video');
                    $thumbnail_image_name     =   $request->file('thumbnail_image');
                    if(!empty($video) && $video != null && $thumbnail_image_name){
                        $fileExentsion              = $video->extension();
                        $fileName                   = $video->getClientOriginalName();
                        $fileFullName               = time()."_".$fileName;
                        $path                       = Str::slug($fileFullName).".".$fileExentsion;
                        $video->move(public_path('upload/event/'), $path);
                        $fullpath                   = 'upload/event/'.$path;
                        $data->video            =   $fullpath;

                        //thumbnail_image
                        $thumbnail_image_name_gen       =   hexdec(uniqid()).'.'.$thumbnail_image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/event/'.$thumbnail_image_name_gen);
                        Image::make($thumbnail_image_name->getRealPath())->save($path);
                        $last_img       =   'upload/event/'.$thumbnail_image_name_gen;
                        $data->thumbnail_image            =   $last_img;
                    }else{
                        $notification=array(
                            'message'=>'Please Upload Video and thumbnail image',
                            'alert-type'=>'warning'
                        );
                        return redirect()->back()->with($notification);
                    }
                }elseif($request->video_type=='Youtube' && $request->youtube){
                    $data->youtube  =   $request->youtube;
                }else{
                    $notification=array(
                        'message'=>'Please Enter Youtube Link',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }

            //pdf
            $pdf_name     =   $request->file('pdf');
            if( !empty($pdf_name) && $pdf_name != null){
                $path  =hexdec(uniqid()).'.'.$pdf_name->getClientOriginalExtension();
                $pdf_name->move(public_path('upload/event/'), $path);
                $data->pdf  = 'upload/event/'.$path;
            }

            if($request->language !='en'){
                $data->default_language_page = $request->default_language_page;
            }
            $data->title       =   $request->title;
            $data->description =   $request->description;
            $data->media_type         =   $request->media_type;
            $data->video_type         =   $request->video_type;
            $data->datetime =   $request->datetime;
            $data->duration =   $request->duration;
            $data->meeting_type =   $request->meeting_type;
            $data->meeting_link =   $request->meeting_link;
            if(@$meetings['status']){
                $data->zoom_start_url =   @$meetings['data']['start_url'];
                $data->zoom_join_url =   @$meetings['data']['join_url'];
                $data->zoom_id =   @$meetings['data']['id'];
                $data->zoom_password =   @$meetings['data']['password'];
            }
            $data->created_by       =   Auth::user()->id;
            $data->language=$request->language;

            $result=$data->save();
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.event.event-date.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function show($id)
    {
        //
    }

    public function edit( $id)
    {
        $data=EventDate::find($id);
        $languages      =   Language::all();
        $defaultLanguagePagesList=EventDate::where('language','en')->where('status','Published')->get();
        return view('backend.page.event.event-date.edit',compact('languages','data','defaultLanguagePagesList'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'thumbnail_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'datetime'=>'required',
            'duration'=>'required',
            'meeting_type'=>'required',
            'meeting_link'=>'required',
            'status'=>'required',
            'pdf'=>'nullable|mimes:pdf',
        ]);
        //
        if($request->language !='en'){
            $check_data=EventDate::where('id','!=',$id)->where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $old_video=$request->old_video;
        $old_image=$request->old_image;
        $old_pdf=$request->old_pdf;
        $old_thumbnail_image=$request->old_thumbnail_image;

        $data= EventDate::find($id);

        //update/add/rescheduleMeeting meeting 
        if(!$data->zoom_id || $data->zoom_id==''){
            $meetings=$this->createMeeting($request);
        }elseif($data->datetime!=$request->datetime || $data->duration!=$request->duration){
            $apiData['id']=$data->zoom_id;
            $apiData['title']=$request->title;
            $apiData['datetime']=$request->datetime;
            $apiData['duration']=$request->duration;
            $this->rescheduleMeeting($apiData);
        }elseif($data->title!=$request->title){
            $apiData['id']=$data->zoom_id;
            $apiData['title']=$request->title;
            $this->UpdateMeeting($apiData);
        }




        //--------------------------------------
        $thumbnail_image_name     =   $request->file('thumbnail_image');
        if($thumbnail_image_name){
            $thumbnail_image_name_gen       =   hexdec(uniqid()).'.'.$thumbnail_image_name->getClientOriginalExtension();
            $path           =   public_path('upload/go-online/'.$thumbnail_image_name_gen);
            Image::make($thumbnail_image_name->getRealPath())->save($path);
            $last_img       =   'upload/go-online/'.$thumbnail_image_name_gen;
            $data->thumbnail_image            =   $last_img;
            if($old_thumbnail_image){
                $unlink=@unlink($old_thumbnail_image);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image');
            if($image_name ||$old_image){
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/go-online/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/go-online/'.$name_gen;
                    $data->image            =   $last_img;
                    if($old_image){
                        $unlink=@unlink($old_image);
                    }
                }
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                if((!empty($video) && $video != null) ||$old_video){
                    if(!empty($video) && $video != null){
                        $fileExentsion              = $video->extension();
                        $fileName                   = $video->getClientOriginalName();
                        $fileFullName               = time()."_".$fileName;
                        $path                       = Str::slug($fileFullName).".".$fileExentsion;
                        $video->move(public_path('upload/go-online/'), $path);
                        $fullpath                   = 'upload/go-online/'.$path;
                        $data->video            =   $fullpath;
                        if($old_video){
                            $unlink=@unlink($old_video);
                        }
                    }
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        //pdf
        $pdf_name     =   $request->file('pdf');
        if( !empty($pdf_name) && $pdf_name != null){
            $path  =hexdec(uniqid()).'.'.$pdf_name->getClientOriginalExtension();
            $pdf_name->move(public_path('upload/event/'), $path);
            $data->pdf  = 'upload/event/'.$path;
            if($old_pdf){
                @unlink($old_pdf);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        if($request->language !='en'){
            $data->default_language_page = $request->default_language_page;
        }
        $data->title       =   $request->title;
        $data->description =   $request->description;
        $data->media_type =   $request->media_type;
        $data->video_type =   $request->video_type;
        $data->datetime =   $request->datetime;
        $data->duration =   $request->duration;
        $data->meeting_type =   $request->meeting_type;
        $data->meeting_link =   $request->meeting_link;
        
        if(@$meetings['status'] && @$meetings['data']['id']){
            $data->zoom_start_url =   @$meetings['data']['start_url'];
            $data->zoom_join_url =   @$meetings['data']['join_url'];
            $data->zoom_id =   @$meetings['data']['id'];
            $data->zoom_password =   @$meetings['data']['password'];
        }

        $data->language=$request->language;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.event.event-date.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy($id)
    {
        $data       =   EventDate::find($id);
        if($data->status=='Trash'){
            $checkData=EventFormData::where('event_child_id',$id)->count();
            if($checkData==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'Event Registered!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }


}
