<?php

namespace App\Http\Controllers\backend\page\event;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\EventFormData;
use DataTables;
use DB;
use App\Exports\AdminEventList;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Log;

class EventFormDataController extends Controller
{
    public function index($id, Request $request)
    {
        $id=$request->id; 
        if($request->ajax()){
            // $products=EventFormData::with('EventChild')->orderBy('id','DESC');
            $products = EventFormData::select(
                'event_dates.title', 
                'event_dates.datetime', 
                DB::raw('CONCAT_WS(" ", event_form_data.f_name, event_form_data.l_name) as full_name'), 
                'event_form_data.email', 
                'event_form_data.calling_code', 
                'event_form_data.phone'
            )
            ->join('event_dates', 'event_form_data.event_child_id', '=', 'event_dates.id')
            ->where('event_form_data.event_child_id', $request->event_child_id)
            ->orderBy('event_form_data.id', 'DESC');

            return DataTables::of($products)
                ->editColumn('phone', function($data) {
                    return '(+'.$data->calling_code.') '. $data->phone;
                })
               
                ->editColumn('datetime', function($data) {
                    return date('H:i A Y-m-d',strtotime( $data->datetime));
                })
                ->addIndexColumn()
                ->make(true);
        }

        return view('backend.page.event.event-form-data.index', compact('id'));
    }

    public function excel($id){
        try{
            $datas = EventFormData::select(
                'event_dates.title', 
                'event_dates.datetime', 
                DB::raw('CONCAT_WS(" ", event_form_data.f_name, event_form_data.l_name) as full_name'), 
                'event_form_data.email', 
                'event_form_data.calling_code', 
                'event_form_data.phone'
            )
            ->join('event_dates', 'event_form_data.event_child_id', '=', 'event_dates.id')
            ->where('event_form_data.event_child_id', $id)
            ->orderBy('event_form_data.id', 'DESC')
            ->get();

            if (!$datas->isEmpty()) {
                return Excel::download(new AdminEventList($datas), 'Event-Form-List.xlsx');
            } else {
               return redirect()->back();
            }
        }catch(\Exception $e){
            Log::info('EventFormDataController excel: ' . $e);
            return redirect()->back();
        }
    }
}
