<?php

namespace App\Http\Controllers\backend\page\financial_service;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\FinancialServiceBusinessPaymentPlatforms;
use App\Models\Language;
use Intervention\Image\Facades\Image;

class BusinessPaymentPlatformsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=FinancialServiceBusinessPaymentPlatforms::all();
        return view('backend.page.financial-service.business-payment-platforms.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $languages  =Language::all();
        $defaultLanguagePagesList=FinancialServiceBusinessPaymentPlatforms::where('language','en')->where('status','Published')->get();
        return view('backend.page.financial-service.business-payment-platforms.add',compact('languages','defaultLanguagePagesList'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'image_1'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'image_2'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'title'=>'required',
            'sub_title'=>'required',
            'description'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'key_benefits_title' =>'required',
            'key_benefits_1' =>'required',
            'key_benefits_2' =>'required',
            'key_benefits_3' =>'required',
            'key_benefits_4' =>'required',
            'key_benefits_5' =>'required', 
        ]);

        if($request->language =='en' && $request->slug){
            $check_data=FinancialServiceBusinessPaymentPlatforms::where('slug',$request->slug)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->language !='en' && $request->default_language_page){
            $check_data=FinancialServiceBusinessPaymentPlatforms::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $notification=array(
                'message'=>'Please first add english language page!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data=new FinancialServiceBusinessPaymentPlatforms();
        //--------------------------------------
        $image_1     =   $request->file('image_1');
        $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1->getClientOriginalExtension();
        $path           =   public_path('upload/financial-service/'.$image_1_name_gen);
        Image::make($image_1->getRealPath())->save($path);
        $last_img       =   'upload/financial-service/'.$image_1_name_gen;
        $data->image_1            =   $last_img;
        //------------------------------------------------------
        $image_2     =   $request->file('image_2');
        $image_2_name_gen       =   hexdec(uniqid()).'.'.$image_2->getClientOriginalExtension();
        $path           =   public_path('upload/financial-service/'.$image_2_name_gen);
        Image::make($image_2->getRealPath())->save($path);
        $last_img       =   'upload/financial-service/'.$image_2_name_gen;
        $data->image_2            =   $last_img;
        //------------------------------------------------------

        if($request->language =='en'){
            $data->slug        =   trim(strtolower($request->slug));
        }else{
            $data->default_language_page = $request->default_language_page;
        }
        $data->title=$request->title;
        $data->key_benefits_title=$request->key_benefits_title;
        $data->key_benefits_1=$request->key_benefits_1;
        $data->key_benefits_2=$request->key_benefits_2;
        $data->key_benefits_3=$request->key_benefits_3;
        $data->key_benefits_4=$request->key_benefits_4;
        $data->key_benefits_5=$request->key_benefits_5;
        $data->sub_title=$request->sub_title;
        $data->description=$request->description;
        $data->button_text=$request->button_text;
        $data->button_link=$request->button_link;

        $data->language=$request->language;
        $data->meta_key=$request->meta_key;
        $data->meta_title=$request->meta_title;
        $data->meta_description=$request->meta_description;
        $data->created_by=Auth::user()->id;
        $result=$data->save();

        if(@$result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('financial-service.business-payment-platforms.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages  =Language::all();
        $defaultLanguagePagesList=FinancialServiceBusinessPaymentPlatforms::where('language','en')->where('status','Published')->get();
        $data=FinancialServiceBusinessPaymentPlatforms::find($id);
        return view('backend.page.financial-service.business-payment-platforms.edit',compact('languages','data','defaultLanguagePagesList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'image_1'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'image_2'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'title'=>'required',
            'sub_title'=>'required',
            'description'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'key_benefits_title'=>'required',
            'key_benefits_1' =>'required',
            'key_benefits_2' =>'required',
            'key_benefits_3' =>'required',
            'key_benefits_4' =>'required',
            'key_benefits_5' =>'required',
        ]);
        $old_image_1=$request->old_image_1;
        $old_image_2=$request->old_image_2;

        if($request->language !='en'){
            $check_data=FinancialServiceBusinessPaymentPlatforms::where('id','!=',$id)->where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $data= FinancialServiceBusinessPaymentPlatforms::find($id);

        //--------------------------------------
        $image_1     =   $request->file('image_1');
        if($image_1){
            $image_1_name_gen       =   hexdec(uniqid()).'.'.$image_1->getClientOriginalExtension();
            $path           =   public_path('upload/financial-service/'.$image_1_name_gen);
            Image::make($image_1->getRealPath())->save($path);
            $last_img       =   'upload/financial-service/'.$image_1_name_gen;
            $data->image_1            =   $last_img;
            if($old_image_1){
                @unlink($old_image_1);
            }
        }
        //------------------------------------------------------
        $image_2     =   $request->file('image_2');
        if($image_2){
            $image_2_name_gen       =   hexdec(uniqid()).'.'.$image_2->getClientOriginalExtension();
            $path           =   public_path('upload/financial-service/'.$image_2_name_gen);
            Image::make($image_2->getRealPath())->save($path);
            $last_img       =   'upload/financial-service/'.$image_2_name_gen;
            $data->image_2            =   $last_img;
            if($old_image_2){
                @unlink($old_image_2);
            }
        }
        //------------------------------------------------------
        if($request->language !='en'){
            $data->default_language_page = $request->default_language_page;
        }
        $data->title=$request->title;
        $data->key_benefits_title=$request->key_benefits_title;
        $data->key_benefits_1=$request->key_benefits_1;
        $data->key_benefits_2=$request->key_benefits_2;
        $data->key_benefits_3=$request->key_benefits_3;
        $data->key_benefits_4=$request->key_benefits_4;
        $data->key_benefits_5=$request->key_benefits_5;
        $data->sub_title=$request->sub_title;
        $data->description=$request->description;
        $data->button_text=$request->button_text;
        $data->button_link=$request->button_link;
        
        $data->language=$request->language;
        $data->meta_key=$request->meta_key;
        $data->meta_title=$request->meta_title;
        $data->meta_description=$request->meta_description;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if(@$result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('financial-service.business-payment-platforms.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   FinancialServiceBusinessPaymentPlatforms::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
        }else{
            $data->status = 'Trash';
            $result = $data->update();
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
