<?php

namespace App\Http\Controllers\backend\page\financial_service;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\FinancialServices;
use App\Models\FinancialServicesService;
use App\Models\FinancialServicesCard;
use Intervention\Image\Facades\Image;

class FinancialServicesServiceController extends Controller
{
    public function index($id)
    {
        $datas=FinancialServicesService::where('financial_service_id',$id)->get();
        return view('backend.page.financial-service.service',compact('datas','id'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'row.*.image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'row.*.title'=>'required'
        ]);
        foreach ($request->row as $photo){
            if(@$photo['old_id']){
                $data= FinancialServicesService::find($photo['old_id']);
                $image_name     =  @$photo['image'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/financial-service/service/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/financial-service/service/'.$name_gen;
                    $data->image  =   $last_img;
                    if($photo['old_image']){
                        $unlink=@unlink($photo['old_image']);
                    }
                }

                $data->title=$photo['title'];
                $data->updated_by=Auth::user()->id;
                $result=$data->save();
            }
            else{
                $image_name     =  @$photo['image'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/financial-service/service/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/financial-service/service/'.$name_gen;

                    $data    =   new FinancialServicesService();
                    $data->image  =   $last_img;
                    $data->financial_service_id =$id;
                    $data->title=$photo['title'];
                    $data->created_by=Auth::user()->id;
                    $result=$data->save();
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('financial-service.payment-gateway.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy(Request $request)
    {
        $id=$request->id;
        FinancialServicesService::where('id',$id)->delete();
        exit;
    }
}
