<?php

namespace App\Http\Controllers\backend\page\general_page;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Language;
use App\Models\LabelManagement;
use App\Models\LabelManagementValue;

class LabelManagementController extends Controller
{
    public function index(){
        $datas=LabelManagementValue::all();
        return view('backend.page.general-page.label-management.index',compact('datas'));
    }

    public function create(){
        $languages      =   Language::all();
        $labels=LabelManagement::all();
        return view('backend.page.general-page.label-management.add',compact('languages','labels'));
    }

    public function store(Request $request){
        $request->validate([
            'key'=>'required',
            'value'=>'required',
            'language'=>'required',
        ]);
        $check_data=LabelManagementValue::where('key',$request->key)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new LabelManagementValue();
        $data->key       =   $request->key;
        $data->value        =   $request->value;
        $data->language     =   $request->language;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('label.page.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $languages      =   Language::all();
        $labels=LabelManagement::all();
        $data       =   LabelManagementValue::find($id);
        return view('backend.page.general-page.label-management.edit',compact('data','languages','labels'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'key'=>'required',
            'value'=>'required',
            'language'=>'required',
        ]);
        $check_data=LabelManagementValue::where('id','!=',$id)->where('key',$request->key)->where('language',$request->language)->count();
        if($check_data){
            $notification=array(
                'message'=>'Title already exists!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    = LabelManagementValue::find($id);
        $data->key     =   $request->key;
        $data->value     =   $request->value;
        $data->language     =   $request->language;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('label.page.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   LabelManagementValue::find($id);
        $result=$data->delete();
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
