<?php

namespace App\Http\Controllers\backend\page\general_page\vission_mission;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use App\Models\VissionAndMissionFeature;
use Illuminate\Support\Facades\Auth;

class VissionAndMissionFeatureController extends Controller
{
    public function index($id)
    {
        $datas=VissionAndMissionFeature::where('vission_mission_id',$id)->get();
        return view('backend.page.general-page.vission-and-mission.feature',compact('datas','id'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'row.*.image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'row.*.title'=>'required',
            'row.*.description'=>'required'
        ]);
        foreach ($request->row as $photo){
            if(@$photo['old_id']){
                $data= VissionAndMissionFeature::find($photo['old_id']);
                $image_name     =  @$photo['image'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/vission-and-mission/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/vission-and-mission/'.$name_gen;
                    $data->image  =   $last_img;
                    if($photo['old_image']){
                        $unlink=@unlink($photo['old_image']);
                    }
                }

                $data->title=$photo['title'];
                $data->description=$photo['description'];
                $data->updated_by=Auth::user()->id;
                $result=$data->save();
            }
            else{
                $image_name     =  @$photo['image'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/vission-and-mission/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/vission-and-mission/'.$name_gen;

                    $data    =   new VissionAndMissionFeature();
                    $data->image  =   $last_img;
                    $data->vission_mission_id =$id;
                    $data->title=$photo['title'];
                    $data->description=$photo['description'];
                    $data->created_by=Auth::user()->id;
                    $result=$data->save();
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('page.vission-and-mission.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy(Request $request)
    {
        $id=$request->id;
        VissionAndMissionFeature::where('id',$id)->delete();
        exit;
    }
}
