<?php

namespace App\Http\Controllers\backend\page\go_online;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;
use App\Models\GoOnlineDigitalMarketingServicesFeatures;

class GoOnlineDigitalMarketingServicesFeaturesController extends Controller
{
    public function edit($id)
    {
        $datas=GoOnlineDigitalMarketingServicesFeatures::where('digital_marketing_service_id',$id)->get();
        return view('backend.page.go-online.digital-marketing-services.features',compact('datas','id'));
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'row.*.image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp'
        ]);
        foreach ($request->row as $photo){
            if(@$photo['title'] && $photo['description']){
                if(@$photo['old_id']){
                    $data= GoOnlineDigitalMarketingServicesFeatures::find($photo['old_id']);
                    $image_name     =  @$photo['image'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/go-online/features/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/go-online/features/'.$name_gen;
                        $data->image  =   $last_img;
                        if($photo['old_image']){
                            $unlink=@unlink($photo['old_image']);
                        }
                    }

                    $data->title=$photo['title'];
                    $data->description=$photo['description'];
                    $data->updated_by=Auth::user()->id;
                    $result=$data->save();
                }
                else{
                    $image_name     =  @$photo['image'];
                    if($image_name){
                        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                        $path           =   public_path('upload/go-online/features/'.$name_gen);
                        Image::make($image_name->getRealPath())->save($path);
                        $last_img       =   'upload/go-online/features/'.$name_gen;

                        $data    =   new GoOnlineDigitalMarketingServicesFeatures();
                        $data->image  =   $last_img;
                        $data->digital_marketing_service_id =$id;
                        $data->title=$photo['title'];
                        $data->description=$photo['description'];
                        $data->created_by=Auth::user()->id;
                        $result=$data->save();
                    }
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('go-online.digital-marketing-services.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function destroy(Request $request)
    {
        $data=GoOnlineDigitalMarketingServicesFeatures::find($request->id)->delete();
    }
}
