<?php

namespace App\Http\Controllers\backend\page\home;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;
use App\Models\HomeBrands;

class HomeBrandsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas=HomeBrands::all();
        return view('backend.page.home.brands.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('backend.page.home.brands.add');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'logo'=>'required|mimes:jpg,png,jpeg,gif,svg',
            'link'=>'nullable|url',
        ]);
        $data    =   new HomeBrands();

        //--------------------------------------
        $image_name     =   $request->file('logo');
        $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
        $path           =   public_path('upload/home/brands/'.$name_gen);
        Image::make($image_name->getRealPath())->save($path);
        $last_img       =   'upload/home/brands/'.$name_gen;
        $data->logo            =   $last_img;

        //-----------------------------------------

        $data->link=$request->link;
        $data->created_by=Auth::user()->id;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.brands.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data       =   HomeBrands::find($id);
        return view('backend.page.home.brands.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'logo'=>'nullable|mimes:jpg,png,jpeg,gif,svg',
            'link'=>'nullable|url',
        ]);
        $old_image=$request->old_image;

        $data= HomeBrands::find($id);


        //--------------------------------------
        $image_name     =   $request->file('logo');
        if($image_name){
            $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
            $path           =   public_path('upload/home/brands/'.$name_gen);
            Image::make($image_name->getRealPath())->save($path);
            $last_img       =   'upload/home/brands/'.$name_gen;
            $data->logo            =   $last_img;
            if($old_image){
                $unlink=@unlink($old_image);
            }
        }
        //--------------------------------------
        $data->link=$request->link;
        $data->status=$request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Updated Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.brands.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data       =   HomeBrands::find($id);
        if($data->status=='Trash'){
            $result=$data->delete();
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('home.brands.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
