<?php

namespace App\Http\Controllers\backend\page\industries;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\IndustriesCategory;
use App\Models\Industries;
use App\Models\Pricing;
use App\Models\IndustriesKeyOfferings;
use App\Models\IndustriesService;
use Intervention\Image\Facades\Image;
use Str;
use Illuminate\Support\Facades\Auth;
use App\Models\Language;

class IndustriesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        $categorys=IndustriesCategory::where('language','en')->get();
        $datas=Industries::all();
        return view('backend.page.industries.industry.index',compact('datas','categorys'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(){
        $languages  =Language::all();
        $categorys=IndustriesCategory::where('language','en')->where('status','Published')->get();
        $defaultLanguagePagesList=Industries::where('language','en')->where('status','Published')->get();
        return view('backend.page.industries.industry.add',compact('languages','categorys', 'defaultLanguagePagesList'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request){
        $request->validate([
            'header_icon'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'banner_image'=>'required|image|mimes:jpeg,png,jpg,gif,svg',
            'image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'thumbnail_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'title'=>'required',
            'sub_title'=>'required',
            'description'=>'required',
            'button_text'=>'required',
            'button_link'=>'required',
            'key_offerings_text'=>'required',
            'industries_category_id'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'media_type'=>'required',
        ]);

        if($request->language =='en' && $request->slug){
            $check_data=Industries::where('slug',$request->slug)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->language !='en' && $request->default_language_page){
            $check_data=Industries::where('default_language_page',$request->default_language_page)->where('language',$request->language)->count();
            if($check_data){
                $notification=array(
                    'message'=>'Title already exists!!.',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $notification=array(
                'message'=>'Please first add english language page!!.',
                'alert-type'=>'warning'
            );
            return redirect()->back()->with($notification);
        }

        $data    =   new Industries();
        //--------------------------------------
        $header_icon_name     =   $request->file('header_icon');
        $header_icon_name_gen       =   hexdec(uniqid()).'.'.$header_icon_name->getClientOriginalExtension();
        $path           =   public_path('upload/industry/'.$header_icon_name_gen);
        Image::make($header_icon_name->getRealPath())->save($path);
        $last_img       =   'upload/industry/'.$header_icon_name_gen;
        $data->header_icon            =   $last_img;
        //--------------------------------------
        $banner_image_name     =   $request->file('banner_image');
        $banner_image_name_gen       =   hexdec(uniqid()).'.'.$banner_image_name->getClientOriginalExtension();
        $path           =   public_path('upload/industry/'.$banner_image_name_gen);
        Image::make($banner_image_name->getRealPath())->save($path);
        $last_img       =   'upload/industry/'.$banner_image_name_gen;
        $data->banner_image            =   $last_img;
        //--------------------------------------
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image');
            if($image_name){
                $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                $path           =   public_path('upload/industry/'.$name_gen);
                Image::make($image_name->getRealPath())->resize(1920,1088)->save($path);
                $last_img       =   'upload/industry/'.$name_gen;
                $data->image            =   $last_img;
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                $thumbnail_image_name     =   $request->file('thumbnail_image');
                if(!empty($video) && $video != null && $thumbnail_image_name){
                    $fileExentsion              = $video->extension();
                    $fileName                   = $video->getClientOriginalName();
                    $fileFullName               = time()."_".$fileName;
                    $path                       = Str::slug($fileFullName).".".$fileExentsion;
                    $video->move(public_path('upload/industry/'), $path);
                    $fullpath                   = 'upload/industry/'.$path;
                    $data->video            =   $fullpath;

                    //thumbnail_image
                    $thumbnail_image_name_gen       =   hexdec(uniqid()).'.'.$thumbnail_image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/industry/'.$thumbnail_image_name_gen);
                    Image::make($thumbnail_image_name->getRealPath())->save($path);
                    $last_img       =   'upload/industry/'.$thumbnail_image_name_gen;
                    $data->thumbnail_image            =   $last_img;
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video and thumbnail image',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        if($request->language =='en'){
            $data->slug        =   trim(strtolower($request->slug));
        }else{
            $data->default_language_page = $request->default_language_page;
        }
        $data->description =   $request->description;
        $data->button_text =   $request->button_text;
        $data->button_link =   $request->button_link;
        $data->key_offerings_text =   $request->key_offerings_text;
        $data->industries_category_id =   $request->industries_category_id;
        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->created_by       =   Auth::user()->id;

        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Record Created Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('industries.industry.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id){
        $data       =   Industries::find($id);
        return view('backend.page.industries.industry.view',compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id){
        $languages  =Language::all();
        $categorys=IndustriesCategory::where('language','en')->where('status','Published')->get();
        $defaultLanguagePagesList=Industries::where('language','en')->where('status','Published')->get();
        $data=Industries::find($id);
        return view('backend.page.industries.industry.edit',compact('data','languages','categorys','defaultLanguagePagesList'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id){
        $request->validate([
            'header_icon'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'banner_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'thumbnail_image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg',
            'video'=>'nullable|mimes:mp4,mov,ogg,qt',
            'title'=>'required',
            'sub_title'=>'required',
            'description'=>'required',
            'button_text'=>'required',
            'button_link'=>'required',
            'key_offerings_text'=>'required',
            'industries_category_id'=>'required',
            'language'=>'required',
            'meta_key'=>'required',
            'meta_title'=>'required',
            'meta_description'=>'required',
            'media_type'=>'required',
            'status'=>'required',
        ]);

        if ($request->language != 'en') {
            $check_data = Industries::where('id', '!=', $id)->where('default_language_page', $request->default_language_page)->where('language', $request->language)->count();
            if ($check_data) {
                $notification = array(
                    'message' => 'Title already exists!!.',
                    'alert-type' => 'warning'
                );
                return redirect()->back()->with($notification);
            }
        }

        $old_image=$request->old_image;
        $old_video=$request->old_video;
        $old_header_icon=$request->old_header_icon;
        $old_banner_image=$request->old_banner_image;
        $old_thumbnail_image=$request->old_thumbnail_image;

        $data= Industries::find($id);
        //--------------------------------------
        $header_icon_name     =   $request->file('header_icon');
        if($header_icon_name){
            $header_icon_name_gen       =   hexdec(uniqid()).'.'.$header_icon_name->getClientOriginalExtension();
            $path           =   public_path('upload/industry/'.$header_icon_name_gen);
            Image::make($header_icon_name->getRealPath())->save($path);
            $last_img       =   'upload/industry/'.$header_icon_name_gen;
            $data->header_icon            =   $last_img;
            if($old_header_icon){
                $unlink=@unlink($old_header_icon);
            }
        }
        //--------------------------------------
        $banner_image_name     =   $request->file('banner_image');
        if($banner_image_name){
            $banner_image_name_gen       =   hexdec(uniqid()).'.'.$banner_image_name->getClientOriginalExtension();
            $path           =   public_path('upload/industry/'.$banner_image_name_gen);
            Image::make($banner_image_name->getRealPath())->save($path);
            $last_img       =   'upload/industry/'.$banner_image_name_gen;
            $data->banner_image            =   $last_img;
            if($old_banner_image){
                $unlink=@unlink($old_banner_image);
            }
        }
        //--------------------------------------thumbnail_image
        $thumbnail_image_name     =   $request->file('thumbnail_image');
        if($thumbnail_image_name){
            $thumbnail_image_name_gen       =   hexdec(uniqid()).'.'.$thumbnail_image_name->getClientOriginalExtension();
            $path           =   public_path('upload/industry/'.$thumbnail_image_name_gen);
            Image::make($thumbnail_image_name->getRealPath())->save($path);
            $last_img       =   'upload/industry/'.$thumbnail_image_name_gen;
            $data->thumbnail_image            =   $last_img;
            if($old_thumbnail_image){
                $unlink=@unlink($old_thumbnail_image);
            }
        }
        // ---------------------------------------------------------------------------------------------------
        if($request->media_type=='Image'){
            $image_name     =   $request->file('image');
            if($image_name ||$old_image){
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/industry/'.$name_gen);
                    Image::make($image_name->getRealPath())->resize(1920,1088)->save($path);
                    $last_img       =   'upload/industry/'.$name_gen;
                    $data->image            =   $last_img;
                    if($old_image){
                        $unlink=@unlink($old_image);
                    }
                }
            }else{
                $notification=array(
                    'message'=>'Please Upload Image',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }elseif($request->media_type=='Video'){
            if($request->video_type=='MP4'){
                $video = $request->file('video');
                if((!empty($video) && $video != null) ||$old_video){
                    if(!empty($video) && $video != null){
                        $fileExentsion              = $video->extension();
                        $fileName                   = $video->getClientOriginalName();
                        $fileFullName               = time()."_".$fileName;
                        $path                       = Str::slug($fileFullName).".".$fileExentsion;
                        $video->move(public_path('upload/industry/'), $path);
                        $fullpath                   = 'upload/industry/'.$path;
                        $data->video            =   $fullpath;
                        if($old_video){
                            $unlink=@unlink($old_video);
                        }
                    }
                }else{
                    $notification=array(
                        'message'=>'Please Upload Video',
                        'alert-type'=>'warning'
                    );
                    return redirect()->back()->with($notification);
                }
            }elseif($request->video_type=='Youtube' && $request->youtube){
                $data->youtube            =   $request->youtube;
            }else{
                $notification=array(
                    'message'=>'Please Enter Youtube Link',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        // ---------------------------------------------------------------------------------------------------

        $data->title       =   $request->title;
        $data->sub_title     =   $request->sub_title;
        if ($request->language != 'en') {
            $data->default_language_page = $request->default_language_page;
        }
        $data->description =   $request->description;
        $data->button_text =   $request->button_text;
        $data->button_link =   $request->button_link;
        $data->key_offerings_text =   $request->key_offerings_text;
        $data->industries_category_id =   $request->industries_category_id;
        $data->language         =   $request->language;
        $data->media_type         =   $request->media_type;
        $data->video_type         =   $request->video_type;
        $data->meta_key         =   $request->meta_key;
        $data->meta_title         =   $request->meta_title;
        $data->meta_description         =   $request->meta_description;
        $data->status         =   $request->status;
        $data->updated_by=Auth::user()->id;
        $result=$data->update();

        if($result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('industries.industry.list')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id){
        $data       =   Industries::find($id);
        if($data->status=='Trash'){
            $dataCheck=Pricing::where('lob_id',$id)->count();
            $dataCheck1=IndustriesKeyOfferings::where('industries_id',$id)->count();
            $dataCheck2=IndustriesService::where('industries_id',$id)->count();
            if($dataCheck==0 && $dataCheck2==0 && $dataCheck1==0){
                $result=$data->delete();
            }else{
                $notification=array(
                    'message'=>'First delete associated Category!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }else{
            $data->status='Trash';
            $result=$data->update();
        }
        if($result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function GetCategoryName(Request $request){
        $code=$request->code;
        return IndustriesCategory::where('language',$code)->get();
    }

}
