<?php

namespace App\Http\Controllers\backend\setting;

use App\Http\Controllers\Controller;
use App\Models\EmailNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class EmailNotificationManagementController extends Controller
{
    public function index(){
        $datas=EmailNotification::all();
        return view('backend.setting.email-notification.index',compact('datas'));
    }

    public function update(Request $request){
        $validateData=$request->validate([
            'value' => 'required'
        ]);
        $data=EmailNotification::find($request->id);
        $data->description=$request->value;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();
        if($result){
            $notification=array(
                'message'=>'Email Notification Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('user.setting.email-subscription-notification.view')->with($notification);
        }else{
            $notification=array(
                'message'=>'Some Problem on server!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
