<?php

namespace App\Http\Controllers\backend\setting;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ForgotPasswordPageManagement;

class ForgotPasswordPageManagementController extends Controller
{
    public function index(){

        return view('backend.setting.forgot-password.index');
    }

    public function update(Request $request){
        $validated = $request->validate([
            'forgot_password_thumbnail_image' => 'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'forgot_password_video' => 'nullable|mimetypes:video/mp4,video/webm',
            'otp_thumbnail_image' => 'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'otp_video' => 'nullable|mimetypes:video/mp4,video/webm',
            'change_password_thumbnail_image' => 'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'change_password_video' => 'nullable|mimetypes:video/mp4,video/webm',
        ]);
        
        $arrayKey=['forgot_password_thumbnail_image', 'forgot_password_video', 'otp_thumbnail_image', 'otp_video', 'change_password_thumbnail_image', 'change_password_video'];
        foreach($arrayKey as $key){
            $file = $request->file($key);
            if (!empty($file) && $file != null) {
                $path  = hexdec(uniqid()). "." . $file->extension();
                $file->move(public_path('upload/forgot-password-page/'), $path);
                $fullPath   = 'upload/forgot-password-page/' . $path;

                $data= ForgotPasswordPageManagement::where('key', $key)->first();
                if(!$data){
                    $data= new ForgotPasswordPageManagement();
                }
                $data->key=$key ;
                $data->value= $fullPath;
                $data->save();
            }
        } 

        $notification=array(
            'message'=>'Data Update Successfully!!',
            'alert-type'=>'success'
        );
        return redirect()->back()->with($notification);
    }
}
