<?php

namespace App\Http\Controllers\backend\setting;

use App\Http\Controllers\Controller;
use App\Models\FooterMenu;
use App\Models\FooterMenuChild;
use Illuminate\Http\Request;
use Intervention\Image\Facades\Image;
use App\Models\Language;
use Str;
use Illuminate\Support\Facades\Auth;
use App\Models\HeaderManagement;
use App\Models\FooterSocialIcons;
use App\Models\HeaderMenu;
use App\Models\HeaderMenuChild;
use App\Models\HeaderMenuSubChild;
use App\Models\Industries;
use App\Models\MenuLanguageManagement;
use App\Models\TopHeaderMenu;
use App\Providers\HeaderManagementProvider;
use Illuminate\Support\Facades\DB;

class HeaderManagementController extends Controller
{
    //logo
    public function index(){
        $header_logo_1=HeaderManagement::where('key','header-logo-1')->first();
        $header_logo_2=HeaderManagement::where('key','header-logo-2')->first();
        return view('backend.setting.header.index',compact('header_logo_1','header_logo_2'));
    }

    public function HeaderLogoStore(Request $request){
        $validated = $request->validate([
            'header_logo_1'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'header_logo_2'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'copyright_text'=>'required',
        ]);

        $header_logo_1_name=$request->file('header_logo_1');
        if($header_logo_1_name){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$header_logo_1_name->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($header_logo_1_name->getRealPath())->save($path);

            $data=HeaderManagement::where('key','header-logo-1')->first();
            $oldImage=$data->value;
            $data->value=$name_gen;
            $result=$data->save();
            if($oldImage){
                @unlink($oldImage);
            }
        }

        $header_logo_2_name=$request->file('header_logo_2');
        if($header_logo_2_name){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$header_logo_2_name->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($header_logo_2_name->getRealPath())->save($path);

            $data=HeaderManagement::where('key','header-logo-2')->first();
            $oldImage=$data->value;
            $data->value=$name_gen;
            $result=$data->save();
            if($oldImage){
                @unlink($oldImage);
            }
        }

        $data=HeaderManagement::where('key','copyright_text')->first();
        $data->value=$request->copyright_text;
        $result=$data->save();

        if($result){
            $notification=array(
                'message'=>' Record Update Successfully!!',
                'alert-type'=>'info'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Some Problem on server!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }

    }

    //menu heading
    public function headerMenu(){
        $datas=HeaderMenu::orderBy('Order','ASC')->get();
        return view('backend.setting.header.header-menu',compact('datas'));
    }
    public function headerMenuEdit($id){
        $data = HeaderMenu::find($id);
        $languages=Language::all();
        $languageTitles=MenuLanguageManagement::where('table','header_menus')->where('table_id',$id)->get();
        return view('backend.setting.header.header-menu-edit',compact('data','languages','languageTitles'));
    }
    public function headerMenuOrderPre($order){
        if($order>1){
            $data = HeaderMenu::where('order',$order)->first();
            $other = HeaderMenu::where('order',$order-1)->first();
            $data->order=$order-1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function headerMenuOrderNext($order){
        if($order<5){
            $data = HeaderMenu::where('order',$order)->first();
            $other = HeaderMenu::where('order',$order+1)->first();
            $data->order=$order+1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function headerMenuUpdate(Request $request ,$id){
        $validated = $request->validate([
            'title'=>'required',
        ]);
        $data = HeaderMenu::find($id);
        $data->title=$request->title;
        $data->link=$request->link;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();

        MenuLanguageManagement::where('table','header_menus')->where('table_id',$id)->delete();
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','header_menus')->where('table_id',$id)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='header_menus';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->language=$language[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.header.header-menu')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    //menu sub menu for go online and Financial Service
    public function headerMenuChildGet($id){
        if($id!=5){
            if($id==1 ||$id==3){
                $datas=HeaderMenuChild::where('header_menu_id',$id)->orderBy('order','ASC')->get();
                $parentMenu = HeaderMenu::find($id);
                return view('backend.setting.header.header-menu-child.index',compact('datas','parentMenu'));
            }elseif($id==2 || $id==4){
                $datas=HeaderMenuChild::where('header_menu_id',$id)->orderBy('order','ASC')->get();
                $parentMenu = HeaderMenu::find($id);
                return view('backend.setting.header.header-menu-child.price.index',compact('datas','parentMenu'));
            }
        }
        return redirect()->back();
    }
    public function headerMenuChildAdd($id){
        $languages=Language::all();
        $parentMenu = HeaderMenu::find($id);
        if($id==1){
            $table_1_datas=DB::select('select id,title from go_online_digital_marketing_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from go_online_create_websites where status = ? and language=?', ['Published','en']);
            $table_1_name='go_online_digital_marketing_services';
            $table_2_name='go_online_create_websites';
        }elseif($id==3){
            $table_1_datas=DB::select('select id,title_1 as title from financial_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from financial_service_business_payment_platforms where status = ? and language=?', ['Published','en']);
            $table_1_name='financial_services';
            $table_2_name='financial_service_business_payment_platforms';
        }elseif($id==2 ||$id==4){
            return view('backend.setting.header.header-menu-child.price.add',compact('parentMenu', 'languages'));
        }
        return view('backend.setting.header.header-menu-child.add',compact('table_1_datas','table_2_datas','table_1_name','table_2_name','parentMenu', 'languages'));
    }
    public function headerMenuChildStore(Request $request,$id){
        $validated = $request->validate([
            'icon'=>'required|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'page' => strtolower($request->link)? 'nullable' : 'required',
            'link' => strtolower($request->page)? 'nullable' : 'required|url',
        ], [
            'page.required' => 'Please select page or enter link.',
            'link.required' => 'Please select page or enter link.',
        ]);
        $maxOrder=HeaderMenuChild::where('header_menu_id',$id)->max('order');
        if(!$maxOrder){
            $maxOrder=1;
        }else{
            $maxOrder+=1;
        }
        $data=new HeaderMenuChild();
        $data->header_menu_id=$id;
        if($request->page){
            $page=explode('#',$request->page);
            $data->table_id=$page[0];
            $data->table_name=$page[1];
        }
        $data->title=$request->title;
        $data->order=$maxOrder;
        $data->description=$request->description;
        $data->link=$request->link;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
        }
        $result=$data->save();

        $idCurrent=$data->id;
        $language=$request->language;
        $language_description=$request->language_description;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','header_menu_children')->where('table_id',$idCurrent)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='header_menu_children';
                    $item->table_id=$idCurrent;
                    $item->title=$val;
                    $item->language=$language[$key];
                    $item->description=$language_description[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.header.header-menu-child',$id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function headerMenuChildOrderPre($parent_id,$order){
        if($order>1){
            $data = HeaderMenuChild::where('header_menu_id',$parent_id)->where('order',$order)->first();
            $other = HeaderMenuChild::where('header_menu_id',$parent_id)->where('order',$order-1)->first();
            $data->order=$order-1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function headerMenuChildOrderNext($parent_id, $order){
        $data = HeaderMenuChild::where('header_menu_id',$parent_id)->where('order',$order)->first();
        $other = HeaderMenuChild::where('header_menu_id',$parent_id)->where('order',$order+1)->first();
        if($data && $other){
            $data->order=$order+1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function headerMenuChildEdit($parent_id,$id){
        $languages=Language::all();
        $languageTitles=MenuLanguageManagement::where('table','header_menu_children')->where('table_id',$id)->get();
        $parentMenu = HeaderMenu::find($parent_id);
        $data = HeaderMenuChild::find($id);
        if($parent_id==1){
            $table_1_datas=DB::select('select id,title from go_online_digital_marketing_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from go_online_create_websites where status = ? and language=?', ['Published','en']);
            $table_1_name='go_online_digital_marketing_services';
            $table_2_name='go_online_create_websites';
        }elseif($parent_id==3){
            $table_1_datas=DB::select('select id,title_1 as title from financial_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from financial_service_business_payment_platforms where status = ? and language=?', ['Published','en']);
            $table_1_name='financial_services';
            $table_2_name='financial_service_business_payment_platforms';
        }elseif($parent_id==2 ||$parent_id==4){
            return view('backend.setting.header.header-menu-child.price.edit',compact('parentMenu','data','languages','languageTitles'));
        }
        return view('backend.setting.header.header-menu-child.edit',compact('data','parentMenu','table_1_datas','table_2_datas','table_1_name','table_2_name','languages','languageTitles'));
    }
    public function headerMenuChildUpdate(Request $request ,$parent_id ,$id){
        $validated = $request->validate([
            'icon'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'page' => strtolower($request->link)? 'nullable' : 'required',
            'link' => strtolower($request->page)? 'nullable' : 'required|url',
        ], [
            'page.required' => 'Please select page or enter link.',
            'link.required' => 'Please select page or enter link.',
        ]);

        $data= HeaderMenuChild::find($id);
        $oldIcon=$data->icon;
        if($request->page){
            $page=explode('#',$request->page);
            $data->table_id=$page[0];
            $data->table_name=$page[1];
        }
        $data->title=$request->title;
        $data->description=$request->description;
        $data->link=$request->link;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
            if($oldIcon){
                @unlink($oldIcon);
            }
        }
        $result=$data->save();

        MenuLanguageManagement::where('table','header_menu_children')->where('table_id',$id)->delete();
        $language=$request->language;
        $language_description=$request->language_description;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','header_menu_children')->where('table_id',$id)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='header_menu_children';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->language=$language[$key];
                    $item->description=$language_description[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.header.header-menu-child',$parent_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function headerMenuChildDelete($id){
        $data = HeaderMenuChild::find($id);
        $header_menu_id=$data->header_menu_id;
        $order=$data->order;
        $result=$data->delete();

        $orderList = HeaderMenuChild::where('header_menu_id',$header_menu_id)->where('order','>',$order)->get();
        if(!$orderList->isEmpty()){
            foreach($orderList as $data){
                $item=HeaderMenuChild::find($data->id);
                $item->order=$data->order-1;
                $item->save();
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to delete the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }


    //menu sub menu for industry and price
    public function headerMenuPriceStore(Request $request, $id){
        $validated = $request->validate([
            'title'=>'required',
        ]);
        $maxOrder=HeaderMenuChild::where('header_menu_id',$id)->max('order');
        if(!$maxOrder){
            $maxOrder=1;
        }else{
            $maxOrder+=1;
        }
        $data=new HeaderMenuChild();
        $data->header_menu_id=$id;
        $data->title=$request->title;
        $data->order=$maxOrder;
        $result=$data->save();

        $idCurrent=$data->id;
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
                $lan=$language[$key];
               $checkData= MenuLanguageManagement::where('table','header_menu_children')->where('table_id',$idCurrent)->where('language',$lan)->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='header_menu_children';
                    $item->table_id=$idCurrent;
                    $item->title=$val;
                    $item->language=$lan;
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.header.header-menu-child',$id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function headerMenuPriceUpdate(Request $request ,$parent_id ,$id){
        $validated = $request->validate([
            'title'=>'required',
        ]);

        $data= HeaderMenuChild::find($id);
        $data->title=$request->title;
        $result=$data->save();

        MenuLanguageManagement::where('table','header_menu_children')->where('table_id',$id)->delete();
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
                $lan=$language[$key];
               $checkData= MenuLanguageManagement::where('table','header_menu_children')->where('table_id',$id)->where('language',$lan)->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='header_menu_children';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->language=$lan;
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.header.header-menu-child',$parent_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function headerMenuPriceDelete($id){
        $data = HeaderMenuChild::find($id);
        if($data){
            $checkData=HeaderMenuSubChild::where('header_menu_child_id',$data->id)->count();
            if($checkData==0){
                $header_menu_id=$data->header_menu_id;
                $order=$data->order;
                $result=$data->delete();

                $orderList = HeaderMenuChild::where('header_menu_id',$header_menu_id)->where('order','>',$order)->get();
                if(!$orderList->isEmpty()){
                    foreach($orderList as $data){
                        $item=HeaderMenuChild::find($data->id);
                        $item->order=$data->order-1;
                        $item->save();
                    }
                }
            }else{
                $notification=array(
                    'message'=>'First Delete child!!',
                    'alert-type'=>'warning'
                );
                return redirect()->back()->with($notification);
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to delete the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    //menu sub sub menu for industry and price
    public function headerMenuPriceChildGet($parent_id,$id){
        $datas=HeaderMenuSubChild::where('header_menu_id',$parent_id)->where('header_menu_child_id',$id)->orderBy('order','ASC')->get();
        $parentMenu = HeaderMenu::find($parent_id);
        $parentMenuChild = HeaderMenuChild::find($id);
        return view('backend.setting.header.header-menu-child.price.child.index',compact('datas','parentMenu','parentMenuChild'));
    }
    public function headerMenuPriceChildAdd($parent_id,$id){
        $languages=Language::all();
        $parentMenu = HeaderMenu::find($parent_id);
        $parentMenuChild = HeaderMenuChild::find($id);
        $table_1_datas=Industries::where('status','Published')->where('language','en')->get();
        $table_1_name='industries';
        return view('backend.setting.header.header-menu-child.price.child.add',compact('parentMenu','parentMenuChild','table_1_datas','table_1_name','languages'));
    }
    public function headerMenuPriceChildStore(Request $request, $parent_id, $id){
        $validated = $request->validate([
            'icon'=>'required|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'page' => strtolower($request->link)? 'nullable' : 'required',
            'link' => strtolower($request->page)? 'nullable' : 'required|url',
        ], [
            'page.required' => 'Please select page or enter link.',
            'link.required' => 'Please select page or enter link.',
        ]);
        $maxOrder=HeaderMenuSubChild::where('header_menu_id',$parent_id)->where('header_menu_child_id',$id)->max('order');
        if(!$maxOrder){
            $maxOrder=1;
        }else{
            $maxOrder+=1;
        }
        $data=new HeaderMenuSubChild();
        $data->header_menu_id=$parent_id;
        $data->header_menu_child_id=$id;
        if($request->page){
            $page=explode('#',$request->page);
            $data->table_id=$page[0];
            $data->table_name=$page[1];
        }
        $data->title=$request->title;
        $data->order=$maxOrder;
        $data->description=$request->description;
        $data->link=$request->link;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
        }
        $result=$data->save();

        $idCurrent=$data->id;
        $language=$request->language;
        $language_description=$request->language_description;
        if($request->language_title && $request->language && $id){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','header_menu_sub_children')->where('table_id',$idCurrent)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='header_menu_sub_children';
                    $item->table_id=$idCurrent;
                    $item->title=$val;
                    $item->description=$language_description[$key];
                    $item->language=$language[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.header.header-menu-price-child',[$parent_id,$id])->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function headerMenuPriceChildOrderPre($parent_id, $child_id,$order){
        if($order>1){
            $data = HeaderMenuSubChild::where('header_menu_id',$parent_id)->where('header_menu_child_id',$child_id)->where('order',$order)->first();
            $other = HeaderMenuSubChild::where('header_menu_id',$parent_id)->where('header_menu_child_id',$child_id)->where('order',$order-1)->first();
            $data->order=$order-1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function headerMenuPriceChildOrderNext($parent_id, $child_id, $order){
        $data = HeaderMenuSubChild::where('header_menu_id',$parent_id)->where('header_menu_child_id',$child_id)->where('order',$order)->first();
        $other = HeaderMenuSubChild::where('header_menu_id',$parent_id)->where('header_menu_child_id',$child_id)->where('order',$order+1)->first();
        if($data && $other){
            $data->order=$order+1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function headerMenuPriceChildEdit($parent_id, $child_id,$id){
        $languages=Language::all();
        $languageTitles=MenuLanguageManagement::where('table','header_menu_sub_children')->where('table_id',$id)->get();
        $parentMenu = HeaderMenu::find($parent_id);
        $parentMenuChild = HeaderMenuChild::find($child_id);
        $data = HeaderMenuSubChild::find($id);
        $table_1_datas=Industries::where('status','Published')->where('language','en')->get();
        $table_1_name='industries';
        return view('backend.setting.header.header-menu-child.price.child.edit',compact('parentMenu','parentMenuChild','table_1_datas','table_1_name','data','languages','languageTitles'));
    }
    public function headerMenuPriceChildUpdate(Request $request, $parent_id,$child_id, $id){
        $validated = $request->validate([
            'icon'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'description'=>'required',
            'page' => strtolower($request->link)? 'nullable' : 'required',
            'link' => strtolower($request->page)? 'nullable' : 'required|url',
        ], [
            'page.required' => 'Please select page or enter link.',
            'link.required' => 'Please select page or enter link.',
        ]);

        $data= HeaderMenuSubChild::find($id);
        $oldIcon=$data->icon;
        if($request->page){
            $page=explode('#',$request->page);
            $data->table_id=$page[0];
            $data->table_name=$page[1];
        }
        $data->title=$request->title;
        $data->description=$request->description;
        $data->link=$request->link;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
            if($oldIcon){
                @unlink($oldIcon);
            }
        }
        $result=$data->save();

        MenuLanguageManagement::where('table','header_menu_sub_children')->where('table_id',$id)->delete();
        $language=$request->language;
        $language_description=$request->language_description;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','header_menu_sub_children')->where('table_id',$id)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='header_menu_sub_children';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->description=$language_description[$key];
                    $item->language=$language[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.header.header-menu-price-child',[$parent_id,$child_id])->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function headerMenuPriceChildDelete($id){
        $data = HeaderMenuSubChild::find($id);
        $header_menu_child_id=$data->header_menu_child_id;
        $order=$data->order;
        $result=$data->delete();

        $orderList = HeaderMenuSubChild::where('header_menu_child_id',$header_menu_child_id)->where('order','>',$order)->get();
        if(!$orderList->isEmpty()){
            foreach($orderList as $data){
                $item=HeaderMenuSubChild::find($data->id);
                $item->order=$data->order-1;
                $item->save();
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to delete the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    //Menu Footer
    public function footerMenu(){
        $datas=FooterMenu::orderBy('Order','ASC')->get();
        return view('backend.setting.footer.index',compact('datas'));
    }
    public function footerMenuEdit($id){
        $data = FooterMenu::find($id);
        $languages=Language::all();
        $languageTitles=MenuLanguageManagement::where('table','footer_menus')->where('table_id',$id)->get();
        return view('backend.setting.footer.edit',compact('data', 'languages','languageTitles'));
    }
    public function footerMenuOrderPre($order){
        if($order>1){
            $data = FooterMenu::where('order',$order)->first();
            $other = FooterMenu::where('order',$order-1)->first();
            $data->order=$order-1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function footerMenuOrderNext($order){
        if($order<4){
            $data = FooterMenu::where('order',$order)->first();
            $other = FooterMenu::where('order',$order+1)->first();
            $data->order=$order+1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function footerMenuUpdate(Request $request ,$id){
        $validated = $request->validate([
            'title'=>'required',
        ]);

        $data = FooterMenu::find($id);
        $data->title=$request->title;
        $data->updated_by=Auth::user()->id;
        $result=$data->save();

        MenuLanguageManagement::where('table','footer_menus')->where('table_id',$id)->delete();
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','footer_menus')->where('table_id',$id)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='footer_menus';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->language=$language[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.footer.footer-menu')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    //Menu Footer Child
    public function footerMenuChildGet($id){
        $datas=FooterMenuChild::where('footer_menu_id',$id)->orderBy('order','ASC')->get();
        $parentMenu = FooterMenu::find($id);
        if($datas && $parentMenu){
            return view('backend.setting.footer.footer-menu-child.index',compact('datas','parentMenu'));
        }else{
            return redirect()->back();
        }
    }
    public function footerMenuChildAdd($id){
        $languages=Language::all();
        $parentMenu = FooterMenu::find($id);
        if($id==1){
            $table_1_datas=[];
            $table_1_name='';
            $table_2_datas=[];
            $table_2_name='';
        }elseif($id==2){
            $table_1_datas=DB::select('select id,title from go_online_digital_marketing_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from go_online_create_websites where status = ? and language=?', ['Published','en']);
            $table_1_name='go_online_digital_marketing_services';
            $table_2_name='go_online_create_websites';
        }elseif($id==3){
            $table_1_datas=Industries::where('status','Published')->where('language','en')->get();
            $table_1_name='industries';
            $table_2_datas=[];
            $table_2_name='';
        }elseif($id==4){
            $table_1_datas=DB::select('select id,title_1 as title from financial_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from financial_service_business_payment_platforms where status = ? and language=?', ['Published','en']);
            $table_1_name='financial_services';
            $table_2_name='financial_service_business_payment_platforms';
        }else{
            return redirect()->back();
        }
        return view('backend.setting.footer.footer-menu-child.add',compact('table_1_datas','table_2_datas','table_1_name','table_2_name','parentMenu','languages'));
    }
    public function footerMenuChildStore(Request $request,$id){
        $validated = $request->validate([
            'icon'=>'required|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'page' => strtolower($request->link)? 'nullable' : 'required',
            'link' => strtolower($request->page)? 'nullable' : 'required|url',
        ], [
            'page.required' => 'Please select page or enter link.',
            'link.required' => 'Please select page or enter link.',
        ]);
        $maxOrder=FooterMenuChild::where('footer_menu_id',$id)->max('order');
        if(!$maxOrder){
            $maxOrder=1;
        }else{
            $maxOrder+=1;
        }
        $data=new FooterMenuChild();
        $data->footer_menu_id=$id;
        if($request->page){
            $page=explode('#',$request->page);
            $data->table_id=$page[0];
            $data->table_name=$page[1];
        }
        $data->title=$request->title;
        $data->order=$maxOrder;
        $data->link=$request->link;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
        }
        $result=$data->save();

        $idCurrent=$data->id;
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
                $lan=$language[$key];
               $checkData= MenuLanguageManagement::where('table','footer_menu_children')->where('table_id',$idCurrent)->where('language',$lan)->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='footer_menu_children';
                    $item->table_id=$idCurrent;
                    $item->title=$val;
                    $item->language=$lan;
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.footer.footer-menu-child',$id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function footerMenuChildOrderPre($parent_id,$order){
        if($order>1){
            $data = FooterMenuChild::where('footer_menu_id',$parent_id)->where('order',$order)->first();
            $other = FooterMenuChild::where('footer_menu_id',$parent_id)->where('order',$order-1)->first();
            $data->order=$order-1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function footerMenuChildOrderNext($parent_id, $order){
        $data = FooterMenuChild::where('footer_menu_id',$parent_id)->where('order',$order)->first();
        $other = FooterMenuChild::where('footer_menu_id',$parent_id)->where('order',$order+1)->first();
        if($data && $other){
            $data->order=$order+1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function footerMenuChildEdit($parent_id,$id){
        $languages=Language::all();
        $languageTitles=MenuLanguageManagement::where('table','footer_menu_children')->where('table_id',$id)->get();
        $parentMenu = FooterMenu::find($parent_id);
        $data = FooterMenuChild::find($id);
        if($parent_id==1){
            $table_1_datas=[];
            $table_1_name='';
            $table_2_datas=[];
            $table_2_name='';
        }elseif($parent_id==2){
            $table_1_datas=DB::select('select id,title from go_online_digital_marketing_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from go_online_create_websites where status = ? and language=?', ['Published','en']);
            $table_1_name='go_online_digital_marketing_services';
            $table_2_name='go_online_create_websites';
        }elseif($parent_id==3){
            $table_1_datas=Industries::where('status','Published')->where('language','en')->get();
            $table_1_name='industries';
            $table_2_datas=[];
            $table_2_name='';
        }elseif($parent_id==4){
            $table_1_datas=DB::select('select id,title_1 as title from financial_services where status = ? and language=?', ['Published','en']);
            $table_2_datas=DB::select('select id,title from financial_service_business_payment_platforms where status = ? and language=?', ['Published','en']);
            $table_1_name='financial_services';
            $table_2_name='financial_service_business_payment_platforms';
        }else{
            return redirect()->back();
        }
        return view('backend.setting.footer.footer-menu-child.edit',compact('data','parentMenu','table_1_datas','table_2_datas','table_1_name','table_2_name','languages','languageTitles'));
    }
    public function footerMenuChildUpdate(Request $request ,$parent_id ,$id){
        $validated = $request->validate([
            'icon'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'page' => strtolower($request->link)? 'nullable' : 'required',
            'link' => strtolower($request->page)? 'nullable' : 'required|url',
        ], [
            'page.required' => 'Please select page or enter link.',
            'link.required' => 'Please select page or enter link.',
        ]);

        $data= FooterMenuChild::find($id);
        $oldIcon=$data->icon;
        if($request->page){
            $page=explode('#',$request->page);
            $data->table_id=$page[0];
            $data->table_name=$page[1];
        }
        $data->title=$request->title;
        $data->link=$request->link;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
            if($oldIcon){
                @unlink($oldIcon);
            }
        }
        $result=$data->save();

        MenuLanguageManagement::where('table','footer_menu_children')->where('table_id',$id)->delete();
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','footer_menu_children')->where('table_id',$id)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='footer_menu_children';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->language=$language[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.footer.footer-menu-child',$parent_id)->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function footerMenuChildDelete($id){
        $data = FooterMenuChild::find($id);
        $footer_menu_id=$data->footer_menu_id;
        $order=$data->order;
        $result=$data->delete();

        $orderList = FooterMenuChild::where('footer_menu_id',$footer_menu_id)->where('order','>',$order)->get();
        if(!$orderList->isEmpty()){
            foreach($orderList as $data){
                $item=FooterMenuChild::find($data->id);
                $item->order=$data->order-1;
                $item->save();
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to delete the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }

    //footer social icon
    public function FooterSocialIcons(){
        $datas= FooterSocialIcons::all();
        return view('backend.setting.header.footer-social-icons',compact('datas'));
    }
    public function FooterSocialIconsStore(Request $request){
        $request->validate([
            'row.*.image'=>'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp',
            'row.*.link'=>'required|url',
        ]);
        foreach ($request->row as $photo){
            if(@$photo['old_id']){
                $data= FooterSocialIcons::find($photo['old_id']);
                $image_name     =  @$photo['icon'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/header/footer-social-icon/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/header/footer-social-icon/'.$name_gen;
                    $data->icon  =   $last_img;
                    if($photo['old_icon']){
                        $unlink=@unlink($photo['old_icon']);
                    }
                }

                $data->link=$photo['link'];
                $data->updated_by=Auth::user()->id;
                $result=$data->save();
            }else{
                $image_name     =  @$photo['icon'];
                if($image_name){
                    $name_gen       =   hexdec(uniqid()).'.'.$image_name->getClientOriginalExtension();
                    $path           =   public_path('upload/header/footer-social-icon/'.$name_gen);
                    Image::make($image_name->getRealPath())->save($path);
                    $last_img       =   'upload/header/footer-social-icon/'.$name_gen;

                    $data    =   new FooterSocialIcons();
                    $data->icon  =   $last_img;
                    $data->link=$photo['link'];
                    $data->created_by=Auth::user()->id;
                    $result=$data->save();
                }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function FooterSocialIconDelete(Request $request){
        $data=FooterSocialIcons::find($request->id)->delete();
    }

    //Top Header Menu
    public function topHeaderMenuGet(){
        $datas=TopHeaderMenu::orderBy('order','ASC')->get();
        if($datas){
            return view('backend.setting.top-header-menu.index',compact('datas'));
        }else{
            return redirect()->back();
        }
    }
    public function topHeaderMenuAdd(){
        $languages=Language::all();
        return view('backend.setting.top-header-menu.add',compact('languages'));
    }
    public function topHeaderMenuStore(Request $request){
        $validated = $request->validate([
            'icon'=>'required|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'link' =>'required|url',
        ]);
        $maxOrder=TopHeaderMenu::max('order');
        if(!$maxOrder){
            $maxOrder=1;
        }else{
            $maxOrder+=1;
        }
        $data=new TopHeaderMenu();
        $data->title=$request->title;
        $data->order=$maxOrder;
        $data->link=$request->link;
        $data->created_by=Auth::user()->id;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
        }
        $result=$data->save();

        $id=$data->id;
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
                $lan=$language[$key];
               $checkData= MenuLanguageManagement::where('table','top_header_menus')->where('table_id',$id)->where('language',$lan)->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='top_header_menus';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->language=$lan;
                    $item->save();
               }
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.top-header-menu')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function topHeaderMenuOrderPre($order){
        if($order>1){
            $data = TopHeaderMenu::where('order',$order)->first();
            $other = TopHeaderMenu::where('order',$order-1)->first();
            $data->order=$order-1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function topHeaderMenuOrderNext($order){
        $data = TopHeaderMenu::where('order',$order)->first();
        $other = TopHeaderMenu::where('order',$order+1)->first();
        if($data && $other){
            $data->order=$order+1;
            $data->save();
            $other->order=$order;
            $other->save();
        }
        return redirect()->back();
    }
    public function topHeaderMenuEdit($id){
        $languages=Language::all();
        $data = TopHeaderMenu::find($id);
        $languageTitles=MenuLanguageManagement::where('table','top_header_menus')->where('table_id',$id)->get();
        return view('backend.setting.top-header-menu.edit',compact('data','languages','languageTitles'));
    }
    public function topHeaderMenuUpdate(Request $request, $id){
        $validated = $request->validate([
            'icon'=>'nullable|image|mimes:jpg,png,jpeg,gif,svg',
            'title'=>'required',
            'link' => 'required|url',
        ]);

        $data= TopHeaderMenu::find($id);
        $oldIcon=$data->icon;
        $data->title=$request->title;
        $data->link=$request->link;
        $data->updated_by=Auth::user()->id;
        $icon=$request->file('icon');
        if($icon){
            $name_gen='upload/header/'.hexdec(uniqid()).'.'.$icon->getClientOriginalExtension();
            $path = public_path($name_gen);
            Image::make($icon->getRealPath())->save($path);
            $data->icon=$name_gen;
            if($oldIcon){
                @unlink($oldIcon);
            }
        }
        $result=$data->save();

        MenuLanguageManagement::where('table','top_header_menus')->where('table_id',$id)->delete();
        $language=$request->language;
        if($request->language_title && $request->language){
            foreach($request->language_title as $key => $val){
               $checkData= MenuLanguageManagement::where('table','top_header_menus')->where('table_id',$id)->where('language',$language[$key])->count();
               if($checkData==0){
                    $item=new MenuLanguageManagement();
                    $item->table='top_header_menus';
                    $item->table_id=$id;
                    $item->title=$val;
                    $item->language=$language[$key];
                    $item->save();
               }
            }
        }

        if(@$result){
            $notification=array(
                'message'=>'Record Update Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->route('setting.top-header-menu')->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to save the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
    public function topHeaderMenuDelete($id){
        $data = TopHeaderMenu::find($id);
        $order=$data->order;
        $result=$data->delete();

        $orderList = TopHeaderMenu::where('order','>',$order)->get();
        if(!$orderList->isEmpty()){
            foreach($orderList as $data){
                $item=TopHeaderMenu::find($data->id);
                $item->order=$data->order-1;
                $item->save();
            }
        }
        if(@$result){
            $notification=array(
                'message'=>'Record Delete Successfully!!',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }else{
            $notification=array(
                'message'=>'Unable to delete the data, Please try again later!!',
                'alert-type'=>'error'
            );
            return redirect()->back()->with($notification);
        }
    }
}
