<?php

namespace App\Http\Controllers\frontend\become_a_partner;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use DataTables;
use App\Models\CallingCode;
use App\Models\CountryList;
use App\Models\StateList;
use App\Exports\PartnerCustomerExport;
use Maatwebsite\Excel\Facades\Excel;

class PartnerCustomerManagement extends Controller
{
    public function index(Request $request)
    {
        $datas = User::where('status','N')->where('role','Customer')->where('partner_code', Auth::user()->code)->orderBy('id','DESC')->get();

        return view('frontend.become_a_partner.customer.index', compact('datas'));
    }

    public function show($id)
    {
        $data=User::find($id);
        return view('frontend.become_a_partner.customer.view',compact('data'));
    }

    public function edit($id)
    {
        //---------------------------------------------------------------
        $country_list = CountryList::all();
        $state_list = StateList::all();
        $calling_code_list=CallingCode::all();
        //-------------------------------------------------------------------
        $data=User::find($id);
        return view('frontend.become_a_partner.customer.edit',compact('data','country_list','state_list','calling_code_list'));
    }

    public function update(Request $request)
    {
        $validateData=$request->validate([

            'f_name'=>'required|min:2',
            'l_name'=>'required|min:2',
            'company'=>'required|min:2',
            'country'=>'required|min:2',
            'calling_code'=>'required',
            'phone' => 'required|numeric',
            'pincode' => strtolower($request->country) === 'ae' ? 'nullable' : 'required|numeric',
            'statelist' => strtolower($request->country) === 'in' ? 'required' : 'nullable',
        ]);

        $data= User::find($request->id);
        $data->f_name=ucwords($request->f_name);
        $data->l_name=ucwords($request->l_name);
        $data->phone=$request->phone;
        $data->company=$request->company;
        $data->country=$request->country;
        $data->state=($request->country=='IN')?$request->statelist:NULL;
        $data->city=$request->city;
        $data->address=$request->address;
        $data->pincode=($request->country=='AE')?Null:$request->pincode;
        $data->calling_code=$request->calling_code;
        $data->updated_by=Auth::user()->id;
        $data->save();

        $notification=array(
            'message'=>'Customer Update Successfully!!',
            'alert-type'=>'info'
        );
        return $notification;
    }

    public function excel(){
        return Excel::download(new PartnerCustomerExport(), 'User List.xlsx');
    }
}
