<?php

namespace App\Http\Controllers\frontend\become_a_partner;

use App\Http\Controllers\Controller;
use App\Models\PartnerBio;
use Illuminate\Http\Request;
use App\Models\PartnerDetailMetaData;
use App\Models\User;
use App\Models\StateList;
use App\Models\MarketSectorsList;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Intervention\Image\Facades\Image;
use App\Providers\MessageManagementProvider;
use App\Providers\EmailProvider;
use App\Models\EmailManagement;
use App\Models\Notification;
use App\Models\PartnerNotification;
use stdClass;

class PartnerProfileController extends Controller
{
    public function index()
    {
        try {
            $state_list = StateList::all();
            $market_sectors_lists = MarketSectorsList::all();
            $partnerBio=PartnerBio::where('user_id', Auth::user()->id)->first();
            $partnerBio=$partnerBio?$partnerBio->bio:'';
            $datas= PartnerDetailMetaData::where('user_id', Auth::user()->id)->get();
            return view('frontend.become_a_partner.profile.index', compact('datas', 'state_list', 'market_sectors_lists','partnerBio'));
        } catch (\Exception $e) {
            Log::error('Partner Profile page:' . $e);
            return redirect()->back();
        }
    }

    //update profile photo
    public function updatePhoto(Request $request)
    {
        $request->validate([
            'photo' => 'required|image|mimes:jpeg,png,jpg,gif', // Adjust the validation rules as needed
        ]);
        try {
            $oldImage = Auth::user()->profile_photo_path;
            $image_name     =   $request->file('photo');
            if ($image_name) {
                $name_gen       =   hexdec(uniqid()) . '.' . $image_name->getClientOriginalExtension();
                $path           =   public_path('upload/user_image/' . $name_gen);
                Image::make($image_name->getRealPath())->save($path);
                $last_img       =   'upload/user_image/' . $name_gen;

                $data = User::find(Auth::user()->id);
                $data->profile_photo_path  =   $last_img;
                $result = $data->save();
                if ($oldImage) {
                    @unlink($oldImage);
                }
            }
            $message = MessageManagementProvider::MessageManage('customer-profile-photo-update-successfully');
            return response()->json(['message' => $message], 200);
        } catch (\Exception $e) {
            Log::error('Partner Profile update photo:' . $e);
            return;
        }
    }

    //remove profile photo
    public function removePhoto(Request $request)
    {
        try {
            $oldImage = Auth::user()->profile_photo_path;
            $data = User::find(Auth::user()->id);
            $data->profile_photo_path  =   NULL;
            $result = $data->save();
            if ($oldImage) {
                @unlink($oldImage);
            }
            $message = MessageManagementProvider::MessageManage('customer-profile-photo-remove-successfully');
            return response()->json(['message' => $message], 200);
        } catch (\Exception $e) {
            Log::error('Partner Profile remove photo:' . $e);
            return;
        }
    }

    public function updateBio(Request $request){
        $validateData=$request->validate([
            'bio'=>'required',
        ]);
        try{
            //Partner Bio table
            $checkDetail=PartnerBio::where('user_id',Auth::user()->id)->count();
            if($checkDetail==0){
                $detail=new PartnerBio();
                $detail->user_id =Auth::user()->id;
            }else{
                $detail=PartnerBio::where('user_id',Auth::user()->id)->first();
            }
            $detail->bio =$request->bio;
            $detail->save();
            $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
            return response()->json(['message' => $message], 200);
        }catch(\Exception $e){
            Log::error('Partner Profile bio update:'.$e);
            return;
        }
    }

    public function updateLoginInformation(Request $request){
        $updateDataCount=0;
        $response=self::UpdatePartnerMetaData('designation', $request->designation);
        if($response){ $updateDataCount++; }
        if($updateDataCount>0){
            //notification
            $notification=new Notification();
            $notification->notification_from= '2';
            $notification->table_id= Auth::user()->id;
            $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner update files and fields.';
            $notification->description='partner update files and fields.';
            $notification->save();

            //notification partner
            $partner_notification=new PartnerNotification();
            $partner_notification->user_id =Auth::user()->id;
            $partner_notification->notification=MessageManagementProvider::MessageManage('partner-uploaded-files-and-fields-successfully');
            $partner_notification->save();

            //partner mail
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields', Auth::user()->email, Auth::user() );
            //support
            $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields_for_support', $support_team_email_list->title, Auth::user() );
        }

        $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
        return response()->json(['message' => $message], 200);
    }

    public function updateBasicInformation(Request $request){
        $validateData = $request->validate([
            'how_did_you_hear_about_our_program' => 'required',
            'in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner' => 'required',
            'individual_business' => 'required',
        ], [
            'how_did_you_hear_about_our_program.required' => 'Please select How did you hear about our program.',
            'in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner.required' => 'Please select In what region do you want to represent Aurobees as a channel partner.',
            'individual_business.required' => 'Please check Individual / Business',
        ]);
        $updateDataCount=0;
        $array=array('how_did_you_hear_about_our_program','in_what_region_do_you_want_to_represent_aurobees_as_a_channel_partner','individual_business');
        foreach($array as $key){
            $response=self::UpdatePartnerMetaData($key, $request->$key);
                if($response){ $updateDataCount++; }
        }

        if($updateDataCount>0){
            //notification
            $notification=new Notification();
            $notification->notification_from= '2';
            $notification->table_id= Auth::user()->id;
            $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner update files and fields.';
            $notification->description='partner update files and fields.';
            $notification->save();

            //notification partner
            $partner_notification=new PartnerNotification();
            $partner_notification->user_id =Auth::user()->id;
            $partner_notification->notification=MessageManagementProvider::MessageManage('partner-uploaded-files-and-fields-successfully');
            $partner_notification->save();

            //partner mail
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields', Auth::user()->email, Auth::user() );
            //support
            $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields_for_support', $support_team_email_list->title, Auth::user() );
        }

        $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
        return response()->json(['message' => $message], 200);
    }

    public function updateCompanyInformation(Request $request){
        $validateData = $request->validate([
            'company' => 'required|min:2',
            'country' => 'required|min:2',
            'statelist' => strtolower($request->country) === 'in' ? 'required' : 'nullable',
            'city' => 'required|min:2',
            'company_calling_code' => 'required',
            'company_phone' => 'required|numeric',
            'address' => 'required',
            'address_2' => 'required',
            'pincode' => strtolower($request->country) === 'ae' ? 'nullable' : 'required|numeric',
            'what_is_your_primary_business_domain_focus' => 'required',
            'primary_company_website_or_social_media_page' => 'required',
            'short_description_of_your_company' => 'required'
        ], [
            'city.required' => 'Please enter city name.',
            'address.required' => 'Please enter address line 1.',
            'address_2.required' => 'Please enter address line 2.',
            'company.required' => 'Please enter company name.',
            'country.required' => 'Please enter country name.',
            'company_phone.required' => 'Please enter a phone number.',
            'pincode.required' => 'Please enter a pincode.',
            'company_calling_code.required' => 'Please select a calling code.',
            'statelist.required' => 'Please select a state.',
            'what_is_your_primary_business_domain_focus.required' => 'Please enter Please enter What is your primary business domain focus.',
            'primary_company_website_or_social_media_page.required' => 'Please enter Please enter Primary Company Website or Social Media Page.',
            'short_description_of_your_company.required' => 'Please enter Please enter Short Description.',
        ]);
        try{
            $data=User::find(Auth::user()->id);
            $data->company= $request->company;
            $data->company= $request->company;
            $data->country= $request->country;
            $data->state= ($request->country=='IN')?$request->statelist:Null;
            $data->city= $request->city;
            $data->address= $request->address;
            $data->pincode= ($request->country=='AE')?Null:$request->pincode;
            $data->save();

            $updateDataCount=0;
            $array=array('what_is_your_primary_business_domain_focus','primary_company_website_or_social_media_page','short_description_of_your_company'.'company_phone','address_2','company_calling_code');
            foreach($array as $key){
                $response=self::UpdatePartnerMetaData($key, $request->$key);
                if($response){ $updateDataCount++; }
            }
            
            if($updateDataCount>0){
                //notification
                $notification=new Notification();
                $notification->notification_from= '2';
                $notification->table_id= Auth::user()->id;
                $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner update files and fields.';
                $notification->description='partner update files and fields.';
                $notification->save();
    
                //notification partner
                $partner_notification=new PartnerNotification();
                $partner_notification->user_id =Auth::user()->id;
                $partner_notification->notification=MessageManagementProvider::MessageManage('partner-uploaded-files-and-fields-successfully');
                $partner_notification->save();
    
                //partner mail
                EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields', Auth::user()->email, Auth::user() );
                //support
                $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
                EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields_for_support', $support_team_email_list->title, Auth::user() );
            }

            $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
            return response()->json(['message' => $message], 200);
        
        }catch(\Exception $e){
            Log::error('Partner Register Error Company Information Store: '. $e);
            return '';
        }
    }

    public function updateCompanyFinancialInformation(Request $request){
        $validateData = $request->validate([
            'what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year' => 'required',
            'do_you_have_a_single_primary_vertical_market' => 'required',
            'what_is_your_company_primary_vertical_market_focus' => 'required'
        ], [
            'what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year.required' => 'Please select What was the total sales and services revenue generated by your company in its last fiscal year (USD).',
            'do_you_have_a_single_primary_vertical_market.required' => 'Please select Do you have a single primary vertical market?.',
            'what_is_your_company_primary_vertical_market_focus.required' => 'Please select What is your company’s primary vertical market focus.'
        ]);
        $updateDataCount=0;
        $array=array('what_was_the_total_sales_and_services_revenue_generated_by_your_company_in_its_last_fiscal_year','face_to_face_field_sales','telephone_based_consultative_sales_resources','via_internet_with_limited_human_interference','what_is_your_company_primary_vertical_market_focus','total_number_of_employees','total_number_of_sales_employees','total_number_of_services','total_number_of_technical_support_employees','total_number_of_marketing_employees','do_you_have_a_single_primary_vertical_market');
        foreach($array as $key){
            $response=self::UpdatePartnerMetaData($key, $request->$key);
            if($response){ $updateDataCount++; }
        }

        if($updateDataCount>0){
            //notification
            $notification=new Notification();
            $notification->notification_from= '2';
            $notification->table_id= Auth::user()->id;
            $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner update files and fields.';
            $notification->description='partner update files and fields.';
            $notification->save();

            //notification partner
            $partner_notification=new PartnerNotification();
            $partner_notification->user_id =Auth::user()->id;
            $partner_notification->notification=MessageManagementProvider::MessageManage('partner-uploaded-files-and-fields-successfully');
            $partner_notification->save();

            //partner mail
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields', Auth::user()->email, Auth::user() );
            //support
            $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields_for_support', $support_team_email_list->title, Auth::user() );
        }

        $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
        return response()->json(['message' => $message], 200);
    }

    public function updateCompanyDocumentsUpload(Request $request){
        $arrayDocument=array('pan_card_copy','aadhar_card_copy','acra_profile_copy', 'tax_registration_document', 'company_address_proof', 'company_registration_copy','passport_copy', 'passport_size_photo', 'partners_signature_copy');
        $updateDataCount=0;
        if($request->country_code=='IN'){
            $array=array('company_registration_number','passport_number','gst_number','pan_number','aadhar_card_number');
        }elseif($request->country_code=='SG'){
            $array=array('company_registration_number','passport_number','gst_number','acra_number');
        }elseif($request->country_code=='AE'){
            $array=array('company_registration_number','passport_number','trn_number','tax_registration_number');
        }elseif($request->country_code=='ID'){
            $array=array('company_registration_number','passport_number', 'npwp_number');
        }
        if(@$array){
            foreach($array as $key){
                $response=self::UpdatePartnerMetaData($key, $request->$key);
                if($response){ $updateDataCount++; }
            }
        }
        $documentsList=array();
        if(@$arrayDocument){
            foreach($arrayDocument as $key){
                $image = $request->file($key);
                if(!empty($image) && $image != null){
                    $path               = hexdec(uniqid()).".".$image->extension();
                    $image->move(public_path('upload/partner/'), $path);
                    $imagePath = 'upload/partner/'.$path;
                    self::UpdatePartnerMetaData($key, $imagePath);
                    $documentsList[$key]=$imagePath;
                    $updateDataCount++;
                }
            }
        }

        if($updateDataCount>0){
            //notification
            $notification=new Notification();
            $notification->notification_from= '2';
            $notification->table_id= Auth::user()->id;
            $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner update files and fields.';
            $notification->description='partner update files and fields.';
            $notification->save();

            //notification partner
            $partner_notification=new PartnerNotification();
            $partner_notification->user_id =Auth::user()->id;
            $partner_notification->notification=MessageManagementProvider::MessageManage('partner-uploaded-files-and-fields-successfully');
            $partner_notification->save();

            //partner mail
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields', Auth::user()->email, Auth::user() );
            //support
            $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
            EmailProvider::Email('become_a_partner_uploaded_partner_files_and_fields_for_support', $support_team_email_list->title, Auth::user() );
        }

        $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
        return response()->json(['message' => $message, 'documentsList' => $documentsList], 200);
    }

    public function updateContractRenewal(Request $request){
        $arrayDocument=array('kyc_form', 'partner_contract');
        $updateDataCount=0;
        $documentsList=array();
        if(@$arrayDocument){
            foreach($arrayDocument as $key){
                $image = $request->file($key);
                if(!empty($image) && $image != null){
                    $path               = hexdec(uniqid()).".".$image->extension();
                    $image->move(public_path('upload/partner/'), $path);
                    $imagePath = 'upload/partner/'.$path;
                    self::UpdatePartnerMetaData($key, $imagePath);
                    $documentsList[$key]=$imagePath;
                    $updateDataCount++;
                }
            }
        }
        if($updateDataCount>0){
            //notification
            $notification=new Notification();
            $notification->notification_from= '2';
            $notification->table_id= Auth::user()->id;
            $notification->title=Auth::user()->f_name. ' '.Auth::user()->l_name.' partner update contract.';
            $notification->description='partner update contract throw ContractRenewal';
            $notification->save();

            //notification partner
            $partner_notification=new PartnerNotification();
            $partner_notification->user_id =Auth::user()->id;
            $partner_notification->notification=MessageManagementProvider::MessageManage('partner-contract-uploaded-successfully');
            $partner_notification->save();

            //partner mail
            EmailProvider::Email('become_a_partner_uploaded_partner_contract_throw_contract_renewal_process', Auth::user()->email, Auth::user() );
            //support
            $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
            EmailProvider::Email('become_a_partner_uploaded_partner_contract_throw_contract_renewal_process_for_support', $support_team_email_list->title, Auth::user() );
        }

        $message =MessageManagementProvider::MessageManage('customer-profile-record-update-successfully');
        return response()->json(['message' => $message, 'documentsList' => $documentsList], 200);
    }

    private function UpdatePartnerMetaData($key, $value){
        $data=PartnerDetailMetaData::where('key',$key)->where('user_id', Auth::user()->id)->first();
        if($data && $data->value!=$value){
            $data->key=$key;
            $data->value=$value;
            $data->verify=null;
            $data->remarks='';
            $data->save();

            return true;
        }
        return false;
    }

}
 