<?php

namespace App\Http\Controllers\frontend\operation;

use App\Http\Controllers\Controller;
use App\Models\SubscriptionAddons;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Providers\HelperServiceProvider;
use App\Providers\MessageManagementProvider;
use App\Providers\EmailProvider;
use App\Providers\SubscriptionApiProvider;

use App\Services\PaymentGatewayFactory;
use Illuminate\Database\Eloquent\ModelNotFoundException;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cookie;
use App\Models\Pricing;
use App\Models\PlanPricing;
use App\Models\Subscription;
use App\Models\Transaction;
use App\Models\Notification;
use App\Models\PartnerNotification;
use App\Models\EmailManagement;
use App\Models\OrderMeta;
use App\Models\User;
use Mail;
use stdClass;
use DB;


class TransactionsPageController extends Controller
{
    public function transaction(){
        try{
            $grand_amount           =   number_format(Session::get('grand_amount'),2,'.','');
            $subscription_id        =   Session::get('subscription_id');
            $plan_name              =   Session::get('plan_name');
            $plan_duration          =   Session::get('plan_duration');
            $subscription_name      =   Session::get('subscription_name');
            $currency_code          =   Session::get('currency_code');
            $payment_mode           =   Session::get('payment_mode');
            $quantity               =   Session::get('quantity');
            $isWoocommerceRequired  =   Session::get('isWoocommerceRequired');
            if($subscription_id){
                if(intval($grand_amount) > 0 && $plan_name !='Free-Trial' && $payment_mode =='auropay')
                {
                    //Send data to Aurobees subscription api
                    // $api_data=Session::get('apiData');
                    // $response=SubscriptionApiProvider::SubScriptionApi($api_data);
                    // return $response;
                    //{"errorCode":"200","errorMessage":"Record Added Successfully","status":"Success"}
                    // Log::info('Checkout Transactions page api response: ' . json_encode($response)); // Use an appropriate log level like 'info'

                    //transaction
                    $transaction                    =   new Transaction();
                    $transaction->subscription_id   =   $subscription_id;
                    $transaction->transaction_id    =   '';
                    $transaction->status            =   'Pending';
                    $transaction->message           =   $payment_mode;
                    $transaction->amount            =   $grand_amount;
                    $transaction->currency          =   $currency_code;
                    $transaction->save();

                    $ReferenceNo = 'AURO_'.date('Ymd').'_'.$transaction->id.'_'.$subscription_id;

                    $gateway    = PaymentGatewayFactory::create($payment_mode);
                    $res        = $gateway->charge($grand_amount, $ReferenceNo);
                    Log::info('Auropay response: ' . json_encode($res));
                    if(isset($res['paymentLink']) && isset($res['id']) && isset($res['title'])){
                        return redirect($res['paymentLink']);
                    }else{
                        Log::error('Unable to create the payment link- '. isset($res['message'])?$res['message']:'');
                        $msg=isset($res['message'])?$res['message']:'';
                        $message = MessageManagementProvider::MessageManage('unable-to-create-the-payment-link');
                        $message = str_replace('{Message}',$msg, $message);
                        return redirect()->back()->with('message',$message );
                    }
                }else{
                    if($plan_duration=='MTH'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +30 days'));
                    }elseif($plan_duration=='QTR'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +90 days'));
                    }elseif($plan_duration=='YLY'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +365 days'));
                    }elseif($plan_name=='Free-Trial'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +15 days'));
                    }else{
                        return redirect()->route('home');
                    }
                    //update subscription

                    $subscription=Subscription::find($subscription_id);
                    $subscription->status='Active';
                    $subscription->start_at=$currentDate;
                    $subscription->end_at=$futureDate;
                    $subscription->save();


                    // //Send data to Aurobees subscription api
                    $api_data=Session::get('apiData');
                    $response=SubscriptionApiProvider::SubScriptionApi($api_data);
                    // return $response;
                    //{"errorCode":"200","errorMessage":"Record Added Successfully","status":"Success"}

                    Log::info('Checkout Transactions page api response: ' . json_encode($response)); // Use an appropriate log level like 'info'

                    //transaction
                    $transaction=new Transaction();
                    $transaction->subscription_id=$subscription_id;
                    $transactionID=hexdec(uniqid());
                    $transaction->transaction_id=$transactionID;
                    // $transaction->status=($plan_name=='Free-Trial')?'Success':'Pending';
                    $transaction->status='Success';
                    $transaction->message=$payment_mode;
                    $transaction->amount=$grand_amount;
                    $transaction->currency=$currency_code;
                    $transaction->save();

                    //notification
                    $notification=new Notification();
                    $notification->notification_from= '3';
                    $notification->table_id= $subscription_id;
                    $notification->title=Auth::user()->f_name.' '.Auth::user()->l_name.' Purchase Lob Subscription';
                    $notification->description=Auth::user()->f_name.' '.Auth::user()->l_name.' Purchase '.$subscription_name. ' ('.$plan_name.').';
                    $notification->save();

                    //partner_code partner Notification
                    if(Auth::user()->partner_code){
                        $partnerDetail=User::where('code',Auth::user()->partner_code)->first();
                        if($partnerDetail){
                            //notification partner
                            $partner_notification=new PartnerNotification();
                            $partner_notification->user_id =$partnerDetail->id;
                            $partner_notification->notification_from ='3';
                            $partner_notification->table_id =$subscription_id;
                            $partner_notification->notification= Auth::user()->f_name.' '.Auth::user()->l_name.' Purchase '.$subscription_name. ' ('.$plan_name.').';
                            $partner_notification->save();
                        }
                    }

                    //subscription mail
                    $userEmail=Auth::user()->email;
                    $value=new stdClass();
                    $value->f_name=Auth::user()->f_name;
                    $value->l_name=Auth::user()->l_name;
                    $value->email=Auth::user()->email;
                    $value->amount=$grand_amount;
                    $value->futureDate=$futureDate;
                    $value->currentDate=$currentDate;
                    $value->currency_code=$currency_code;
                    $value->subscription_name=$subscription_name;
                    $value->plan_name=$plan_name;
                    $value->plan_duration=$plan_duration;
                    $value->number_of_user=$quantity;
                    $value->transaction_status='Success';
                    $value->transaction_id=$transactionID;
                    $value->transaction_payment_mode='Offline';
                    $value->email=Auth::user()->email;
                    $value->phone=Auth::user()->phone;
                    //--------------------------------------------------
                    $subscriptionMetaData=OrderMeta::where('subscription_id',$subscription_id)->get();
                    $oldOrderMetaArray=array();
                    foreach($subscriptionMetaData as  $orderMeta){
                        $oldOrderMetaArray[$orderMeta->key]=$orderMeta->value;
                    }
                    $value->company=@$oldOrderMetaArray['company_name'];
                    $value->addressLine1=@$oldOrderMetaArray['address_1'];
                    $value->addressLine2=@$oldOrderMetaArray['address_2'];
                    $value->city=@$oldOrderMetaArray['city'];
                    $value->state=@$oldOrderMetaArray['state'];
                    $value->country=@$oldOrderMetaArray['country'];
                    $value->pincode=@$oldOrderMetaArray['pincode'];
                    $value->industry=@$oldOrderMetaArray['industry'];
                    $value->designation=@$oldOrderMetaArray['designation'];
                    $value->contactPersonFirstName=@$oldOrderMetaArray['first_name'];
                    $value->contactPersonLastName=@$oldOrderMetaArray['last_name'];
                    $value->contactPersonEmail=@$oldOrderMetaArray['email'];
                    $value->contactPersonPhoneNo=@$oldOrderMetaArray['phone'];
                    $value->CustomerOf='Aurobees';
                    $value->CompanyCode=@$oldOrderMetaArray['company_code'];
                    
                    if($plan_name=='Free-Trial'){ 
                        $value->planType='Free';
                    }elseif($plan_name=='Basic'){ 
                        $value->planType='Paid-Basic';
                    }elseif($plan_name=='Advance'){ 
                        $value->planType='Paid-Advanced';
                    }elseif($plan_name=='Ecommerce'){ 
                        $value->planType='Paid-E-commerce';
                    }
                    $value->isWoocommerceRequired=$isWoocommerceRequired;
                    //--------------------------------------------------
                    $subscriptionAddonsList = SubscriptionAddons::select(DB::raw('GROUP_CONCAT(name) as names'))->where('subscription_id', $subscription_id)->first();
                    if($subscriptionAddonsList){
                        $subscriptionAddonsName=$subscriptionAddonsList->names;
                    }else{
                        $subscriptionAddonsName='';
                    }
                    $value->subscriptionAddonsName=$subscriptionAddonsName;
                    //free trial
                    if($plan_name=='Free-Trial'){
                        $finance_team_email_list=EmailManagement::where('key','finance_team_email')->first();
                        $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
                        //free
                        EmailProvider::Email('customer_subscribe_plan_free_trial', $userEmail, $value );
                        EmailProvider::Email('finance_team_subscribe_plan_free', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_free', $support_team_email_list->title, $value );

                    }else{
                        $finance_team_email_list=EmailManagement::where('key','finance_team_email')->first();
                        $support_team_email_list=EmailManagement::where('key','support_team_email')->first();
                        //paid
                        EmailProvider::Email('customer_subscribe_plan_paid', $userEmail, $value );
                        EmailProvider::Email('finance_team_subscribe_plan_paid', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_paid', $support_team_email_list->title, $value );
                    }
                    Session::forget('grand_amount');
                    Session::forget('subscription_id');
                    Session::forget('plan_name');
                    Session::forget('subscription_name');
                    Session::forget('currency_code');
                    Session::forget('plan_duration');
                    Session::forget('quantity');
                    Session::forget('apiData');
                    Session::forget('isWoocommerceRequired');

                    return redirect()->route('subscription.thankyou');
                }
            }else{
                return redirect()->route('home');
            }
        }catch(\Exception $e) {
            Log::error('Checkout Transactions page: '. $e);
            return redirect()->back();
        }
    }

    public function ThankYou(){
        try{
            return view('frontend.new_user.thank-you');
        }catch(\Exception $e) {
            Log::error('Subscription thankyou page: '. $e);
            return redirect()->route('home');
        }
    }

    public function callbackauropay(Request $request){
        // Access URL parameters using both input() and query() methods for robustness:
        $result = $request->input('result', $request->query('result'));
        $refNo = $request->input('refNo', $request->query('refNo'));
        $id = $request->input('id', $request->query('id'));

        if ($result === 'success' && $refNo && $id) {
            try {
                $refArr         = explode('_', $refNo);
                $transactionId  = $refArr[2];

                $transaction = Transaction::findOrFail($transactionId);
                $transaction->status            = 'Success';
                $transaction->transaction_id    = $id;
                $transaction->payment_mode      = 'auropay';
                $transaction->save();
                //subscription
                if($transaction->subscription_id){
                    $subscriptionList=Subscription::find($transaction->subscription_id);

                    //order meta table
                    $orderMetaList=OrderMeta::where('subscription_id',$transaction->subscription_id)->get();
                    $oldOrderMetaArray=array();
                    foreach($orderMetaList as  $orderMeta){
                        $oldOrderMetaArray[$orderMeta->key]=$orderMeta->value;
                    }
                    $subscriptionEmailCheck=0;
                    $planUpgradeStatus=0;
                    //unique email check--------------------------
                    $emailCheck=OrderMeta::where('key','email')->where('value',$oldOrderMetaArray['email'])->count();
                    if($emailCheck!=0){
                        $emailCheck=OrderMeta::where('key','email')->where('value',$request->email)->get();
                        foreach($emailCheck as $data){
                            if($data['Subscription']['status']=='Active'){
                                $subscriptionEmailCheck++;
                                if($emailCheck==1 && $data['Subscription']['plan_name']=='Free-Trial'){
                                    $planUpgradeStatus=1;
                                }
                                break;
                            }
                        }
                    }
                    if($subscriptionEmailCheck==0){
                        //api data
                        $apiData=array();
                        $apiData['companyFullName']=@$oldOrderMetaArray['company_name'];
                        $apiData['addressLine1']=@$oldOrderMetaArray['address_1'];
                        $apiData['addressLine2']=@$oldOrderMetaArray['address_2'];
                        $apiData['city']=@$oldOrderMetaArray['city'];
                        $apiData['state']=@$oldOrderMetaArray['state'];
                        $apiData['country']=@$oldOrderMetaArray['country'];
                        $apiData['zipCode']=@$oldOrderMetaArray['pincode'];
                        $apiData['industry']=@$oldOrderMetaArray['industry'];
                        $apiData['designation']=@$oldOrderMetaArray['designation'];
                        $apiData['noOfEmployees']=@$subscriptionList['quantity'];
                        $apiData['taxRegistrationNo']='';
                        $apiData['contactPersonFirstName']=@$oldOrderMetaArray['first_name'];
                        $apiData['contactPersonMiddleName']='';
                        $apiData['contactPersonLastName']=@$oldOrderMetaArray['last_name'];
                        $apiData['contactPersonEmail']=@$oldOrderMetaArray['email'];
                        $apiData['contactPersonPhoneNo']=@$oldOrderMetaArray['phone'];
                        $apiData['webSiteUrl']='';
                        $apiData['stateCode']='';
                        $apiData['customerOf']='Aurobees';
                        $apiData['companyCode']=@$oldOrderMetaArray['company_code'];

                        //'Free-Trial','Basic','Advance','Ecommerce'                 subscription type
                        if($subscriptionList->plan_name=='Ecommerce'){
                            $apiData['lob']='Ecom';
                            $apiData['subscriptionType']='Paid';
                            $apiData['isWoocommerceRequired']='Yes';
                            $isWoocommerceRequired='Yes';
                        }elseif(@$subscriptionList['Pricing']['short_name']=='Ecom' && $subscriptionList->plan_name=='Free-Trial'){
                            $apiData['lob']='Ecom';
                            $apiData['subscriptionType']='Free';
                            $apiData['isWoocommerceRequired']='Yes';
                            $isWoocommerceRequired='Yes';
                        }else{
                            $apiData['lob']=@$subscriptionList['Pricing']['short_name'];
                            if($subscriptionList->plan_name=='Free-Trial'){ $subscriptionType='FREE';}elseif($subscriptionList->plan_name=='Basic'){ $subscriptionType='Paid-Basic';}elseif($subscriptionList->plan_name=='Advance'){ $subscriptionType='Paid-Advanced';}
                            $apiData['subscriptionType']=@$subscriptionType;
                            $apiData['isWoocommerceRequired']='';
                            $isWoocommerceRequired='No';
                        }

                        //Send data to Aurobees subscription api
                        $api_data=json_encode('apiData');
                        $response=SubscriptionApiProvider::SubScriptionApi($api_data);
                        // return $response;
                        //{"errorCode":"200","errorMessage":"Record Added Successfully","status":"Success"}
                        Log::info('Checkout Transactions page api response auropay: ' . json_encode($response)); // Use an appropriate log level like 'info'
                    }

                    $plan_duration          =   $subscriptionList->plan_duration;
                    if($plan_duration=='MTH'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +30 days'));
                    }elseif($plan_duration=='QTR'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +90 days'));
                    }elseif($plan_duration=='YLY'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +365 days'));
                    }else{
                        return redirect()->route('home');
                    }
                    //update subscription
                    $subscription=Subscription::find($subscriptionList->id);
                    $subscription->status='Active';
                    $subscription->start_at=$currentDate;
                    $subscription->end_at=$futureDate;
                    $subscription->save();

                    //subscription mail
                    $userEmail=$subscription['User']['email'];
                    $value=new stdClass();
                    $value->f_name=$subscription['User']['f_name'];
                    $value->l_name=$subscription['User']['l_name'];
                    $value->amount= number_format($subscription->grand_amount,2,".","");
                    $value->futureDate=$futureDate;
                    $value->currentDate=$currentDate;
                    $value->currency_code=$subscription->currency_code;
                    $value->subscription_name=$subscription['Pricing']['LOB']['title'];
                    $value->plan_name=$subscription->plan_name;
                    $value->plan_duration=$subscription->plan_duration;
                    $value->number_of_user=$subscription->quantity;
                    $value->email=$subscription['User']['email'];
                    $value->phone=$subscription['User']['phone'];

                    $value->transaction_status='Success';
                    $value->transaction_id=$id;
                    $value->transaction_payment_mode='AuroPay';

                    //-----------------------------------------------------------
                    $value->company=@$oldOrderMetaArray['company_name'];
                    $value->addressLine1=@$oldOrderMetaArray['address_1'];
                    $value->addressLine2=@$oldOrderMetaArray['address_2'];
                    $value->city=@$oldOrderMetaArray['city'];
                    $value->state=@$oldOrderMetaArray['state'];
                    $value->country=@$oldOrderMetaArray['country'];
                    $value->pincode=@$oldOrderMetaArray['pincode'];
                    $value->industry=@$oldOrderMetaArray['industry'];
                    $value->designation=@$oldOrderMetaArray['designation'];
                    $value->contactPersonFirstName=@$oldOrderMetaArray['first_name'];
                    $value->contactPersonLastName=@$oldOrderMetaArray['last_name'];
                    $value->contactPersonEmail=@$oldOrderMetaArray['email'];
                    $value->contactPersonPhoneNo=@$oldOrderMetaArray['phone'];
                    $value->CustomerOf='Aurobees';
                    $value->CompanyCode=@$oldOrderMetaArray['company_code'];
                    if($subscriptionList->plan_name=='Free-Trial'){ 
                        $value->planType='Free';
                    }elseif($subscriptionList->plan_name=='Basic'){ 
                        $value->planType='Paid-Basic';
                    }elseif($subscriptionList->plan_name=='Advance'){ 
                        $value->planType='Paid-Advanced';
                    }elseif($subscriptionList->plan_name=='Ecommerce'){ 
                        $value->planType='Paid-E-commerce';
                    }
                    $value->isWoocommerceRequired=$isWoocommerceRequired;
                    //--------------------------------------------------

                    $subscriptionAddonsList = SubscriptionAddons::select(DB::raw('GROUP_CONCAT(name) as names'))->where('subscription_id', $subscriptionList->id)->first();
                    if($subscriptionAddonsList){
                        $subscriptionAddonsName=$subscriptionAddonsList->names;
                    }else{
                        $subscriptionAddonsName='';
                    }
                    $value->subscriptionAddonsName=$subscriptionAddonsName;

                    $finance_team_email_list=EmailManagement::where('key','finance_team_email')->first();
                    $support_team_email_list=EmailManagement::where('key','support_team_email')->first();

                    //email
                    if($subscriptionEmailCheck==0){
                        EmailProvider::Email('customer_subscribe_plan_paid_auropay', $userEmail, $value );
                        EmailProvider::Email('finance_team_subscribe_plan_paid', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_paid', $support_team_email_list->title, $value );
                    }elseif($planUpgradeStatus==1){  //plan upgrade free to basic/advance/ecommerce
                        EmailProvider::Email('customer_subscribe_plan_upgrade_auropay', $userEmail, $value );
                        EmailProvider::Email('finance_team_subscribe_plan_upgrade', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_upgrade', $support_team_email_list->title, $value );
                    }else{  //same plan again pay
                        EmailProvider::Email('customer_subscribe_plan_paid_auropay', $userEmail, $value );
                        EmailProvider::Email('finance_team_subscribe_plan_paid', $finance_team_email_list->title, $value );
                        EmailProvider::Email('support_team_subscribe_plan_paid', $support_team_email_list->title, $value );
                    }
                }
                //admin notification
                if($subscriptionEmailCheck==0){
                    $notification=new Notification();
                    $notification->notification_from= '3';
                    $notification->table_id= $subscriptionList->id;
                    $notification->title=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase Lob Subscription';
                    $notification->description=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.').';
                    $notification->save();

                    //partner_code partner Notification
                    if(@$subscription['User']['partner_code']){
                        $partnerDetail=User::where('code',$subscription['User']['partner_code'])->first();
                        if($partnerDetail){
                            //notification partner
                            $partner_notification=new PartnerNotification();
                            $partner_notification->user_id =$partnerDetail->id;
                            $partner_notification->notification_from ='3';
                            $partner_notification->table_id =$subscriptionList->id;
                            $partner_notification->notification= @$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Purchase '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.').';
                            $partner_notification->save();
                        }
                    }
                }else{
                    $notification=new Notification();
                    $notification->notification_from= '3';
                    $notification->table_id= $subscriptionList->id;
                    $notification->title=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Upgrade Lob Subscription';
                    $notification->description=@$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Upgrade '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.').';
                    $notification->save();

                    //partner_code partner Notification
                    if(@$subscription['User']['partner_code']){
                        $partnerDetail=User::where('code',$subscription['User']['partner_code'])->first();
                        if($partnerDetail){
                            //notification partner
                            $partner_notification=new PartnerNotification();
                            $partner_notification->user_id =$partnerDetail->id;
                            $partner_notification->notification_from ='3';
                            $partner_notification->table_id =$subscriptionList->id;
                            $partner_notification->notification= @$subscription['User']['f_name'].' '.@$subscription['User']['l_name'].' Upgrade '.@$subscription['Pricing']['LOB']['title']. ' ('.$subscription->plan_name.').';
                            $partner_notification->save();
                        }
                    }
                }
                return view('frontend.new_user.thank-you');
            } catch (ModelNotFoundException $e) {
                // Handle missing transaction gracefully
                Log::error("Transaction not found: {$transactionId}");
                return view('frontend.new_user.payment-error');
            }
        }elseif($result === 'failure' && $refNo && $id){
             try {
                $refArr         = explode('_', $refNo);
                $transactionId  = $refArr[2];

                $transaction = Transaction::findOrFail($transactionId);
                $transaction->status            = 'Failure';
                $transaction->transaction_id    = $id;
                $transaction->payment_mode      = 'auropay';
                $transaction->save();

                if($transaction->subscription_id){
                    $subscription=Subscription::find($transaction->subscription_id);
                    //subscription mail
                    $userEmail=$subscription['User']['email'];
                    $value=new stdClass();
                    $value->f_name=$subscription['User']['f_name'];
                    $value->l_name=$subscription['User']['l_name'];
                    $value->amount= number_format($subscription->grand_amount,2,".","");
                    $value->currency_code=$subscription->currency_code;
                    $value->subscription_name=$subscription['Pricing']['LOB']['title'];
                    $value->plan_name=$subscription->plan_name;
                    $value->plan_duration=$subscription->plan_duration;
                    $value->number_of_user=$subscription->quantity;
                    $value->email=$subscription['User']['email'];
                    $value->phone=$subscription['User']['phone'];

                    $value->transaction_status='Failure';
                    $value->transaction_id=$id;
                    $value->transaction_payment_mode='AuroPay';

                    //email
                    EmailProvider::Email('customer_subscribe_plan_paid_auropay_payment_failed', $userEmail, $value );
                }
                Log::error("Transaction failed: {$id}");
                return view('frontend.new_user.payment-error');
            } catch (ModelNotFoundException $e) {
                // Handle missing transaction gracefully
                Log::error("Transaction not found: {$id}");
                return view('frontend.new_user.payment-error');
            }
        } else {
            Log::error("Transaction not found: {$refNo}");
            return view('frontend.new_user.payment-error');
        }
    }
}
