<?php

namespace App\Http\Controllers\frontend\operation;

use App\Http\Controllers\Controller;
use App\Models\SubscriptionAddons;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Providers\HelperServiceProvider;
use App\Providers\MessageManagementProvider;
use App\Providers\EmailProvider;
use App\Providers\SubscriptionApiProvider;

use App\Services\PaymentGatewayFactory;
use Illuminate\Database\Eloquent\ModelNotFoundException;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Cookie;
use App\Models\Pricing;
use App\Models\PlanPricing;
use App\Models\Subscription;
use App\Models\Transaction;
use App\Models\Notification;
use App\Models\PartnerNotification;
use App\Models\EmailManagement;
use App\Models\OrderMeta;
use App\Models\User;
use Mail;
use stdClass;
use DB;
use App\Providers\SubscriptionNotificationProvider;

class TransactionsPageController extends Controller
{
    public function transaction(){
        try{
            $grand_amount           =   number_format(Session::get('grand_amount'),2,'.','');
            $subscription_id        =   Session::get('subscription_id');
            $plan_name              =   Session::get('plan_name');
            $plan_duration          =   Session::get('plan_duration');
            $subscription_name      =   Session::get('subscription_name');
            $currency_code          =   Session::get('currency_code');
            $payment_mode           =   Session::get('payment_mode');
            $quantity               =   Session::get('quantity');
            $isWoocommerceRequired  =   Session::get('isWoocommerceRequired');
            if($subscription_id){
                if(intval($grand_amount) > 0 && $plan_name !='Free-Trial' && $payment_mode =='auropay')
                {
                    return SubscriptionNotificationProvider::PaymentAuropay($subscription_id);
                }else{
                    //Send data to Aurobees subscription api
                    $api_data=Session::get('apiData');
                    $response=SubscriptionApiProvider::SubScriptionApi($api_data);
                    // {"errorCode":"200","errorMessage":"Record Added Successfully","status":"Success"}
                    Log::info('Checkout Transactions page api response: ' . json_encode($response)); // Use an appropriate log level like 'info'

                    //free trail subscription activate
                    if($plan_name=='Free-Trial'){
                        $subscription=Subscription::find($subscription_id);
                        $subscription->status='Active';
                        $subscription->start_at=date('Y-m-d H:i:s');
                        $subscription->end_at=date('Y-m-d H:i:s', strtotime('+15 days'));
                        $subscription->save();
                    }

                    //mail and notification
                    SubscriptionNotificationProvider::Notification($subscription_id);

                    Session::forget('grand_amount');
                    Session::forget('subscription_id');
                    Session::forget('plan_name');
                    Session::forget('subscription_name');
                    Session::forget('currency_code');
                    Session::forget('plan_duration');
                    Session::forget('quantity');
                    Session::forget('apiData');
                    Session::forget('isWoocommerceRequired');

                    return redirect()->route('subscription.thankyou');
                }
            }else{
                return redirect()->route('home');
            }
        }catch(\Exception $e) {
            Log::error('Checkout Transactions page: '. $e);
            return redirect()->back();
        }
    }

    public function ThankYou(){
        try{
            return view('frontend.new_user.thank-you');
        }catch(\Exception $e) {
            Log::error('Subscription thankyou page: '. $e);
            return redirect()->route('home');
        }
    }

    public function callbackauropay(Request $request){
        // Access URL parameters using both input() and query() methods for robustness:
        $result = $request->input('result', $request->query('result'));
        $refNo = $request->input('refNo', $request->query('refNo'));
        $id = $request->input('id', $request->query('id'));

        if ($result === 'success' && $refNo && $id) {
            try {
                $refArr         = explode('_', $refNo);
                $transactionId  = $refArr[2];

                $transaction = Transaction::findOrFail($transactionId);
                $transaction->status            = 'Success';
                $transaction->transaction_id    = $id;
                $transaction->payment_mode      = 'auropay';
                $transaction->save();
                //subscription
                if($transaction->subscription_id){
                    $subscriptionList=Subscription::find($transaction->subscription_id);

                    //order meta table
                    $orderMetaList=OrderMeta::where('subscription_id',$transaction->subscription_id)->get();
                    $oldOrderMetaArray=array();
                    foreach($orderMetaList as  $orderMeta){
                        $oldOrderMetaArray[$orderMeta->key]=$orderMeta->value;
                    }
                    $subscriptionEmailCheck=0;
                    $planUpgradeStatus=0;
                    //unique email check--------------------------
                    $emailCheck=OrderMeta::where('key','email')->where('value',$oldOrderMetaArray['email'])->count();
                    if($emailCheck!=0){
                        $emailCheck=OrderMeta::where('key','email')->where('value',$request->email)->get();
                        foreach($emailCheck as $data){
                            if($data['Subscription']['status']=='Active'){
                                $subscriptionEmailCheck++;
                                if($emailCheck==1 && $data['Subscription']['plan_name']=='Free-Trial'){
                                    $planUpgradeStatus=1;
                                }
                                break;
                            }
                        }
                    }
                    if($subscriptionEmailCheck==0){
                        //api data
                        $apiData=array();
                        $apiData['companyFullName']=@$oldOrderMetaArray['company_name'];
                        $apiData['addressLine1']=@$oldOrderMetaArray['address_1'];
                        $apiData['addressLine2']=@$oldOrderMetaArray['address_2'];
                        $apiData['city']=@$oldOrderMetaArray['city'];
                        $apiData['state']=@$oldOrderMetaArray['state'];
                        $apiData['country']=@$oldOrderMetaArray['country'];
                        $apiData['zipCode']=@$oldOrderMetaArray['pincode'];
                        $apiData['industry']=@$oldOrderMetaArray['industry'];
                        $apiData['designation']=@$oldOrderMetaArray['designation'];
                        $apiData['noOfEmployees']=@$subscriptionList['quantity'];
                        $apiData['taxRegistrationNo']='';
                        $apiData['contactPersonFirstName']=@$oldOrderMetaArray['first_name'];
                        $apiData['contactPersonMiddleName']='';
                        $apiData['contactPersonLastName']=@$oldOrderMetaArray['last_name'];
                        $apiData['contactPersonEmail']=@$oldOrderMetaArray['email'];
                        $apiData['contactPersonPhoneNo']=@$oldOrderMetaArray['phone'];
                        $apiData['webSiteUrl']='';
                        $apiData['stateCode']='';
                        $apiData['customerOf']='Aurobees';
                        $apiData['companyCode']=@$oldOrderMetaArray['company_code'];

                        //'Free-Trial','Basic','Advance','Ecommerce'                 subscription type
                        if($subscriptionList->plan_name=='Ecommerce'){
                            $apiData['lob']='Ecom';
                            $apiData['subscriptionType']='Paid';
                            $apiData['isWoocommerceRequired']='Yes';
                            $isWoocommerceRequired='Yes';
                        }elseif(@$subscriptionList['Pricing']['short_name']=='Ecom' && $subscriptionList->plan_name=='Free-Trial'){
                            $apiData['lob']='Ecom';
                            $apiData['subscriptionType']='Free';
                            $apiData['isWoocommerceRequired']='Yes';
                            $isWoocommerceRequired='Yes';
                        }else{
                            $apiData['lob']=@$subscriptionList['Pricing']['short_name'];
                            if($subscriptionList->plan_name=='Free-Trial'){ $subscriptionType='FREE';}elseif($subscriptionList->plan_name=='Basic'){ $subscriptionType='Paid-Basic';}elseif($subscriptionList->plan_name=='Advance'){ $subscriptionType='Paid-Advanced';}
                            $apiData['subscriptionType']=@$subscriptionType;
                            $apiData['isWoocommerceRequired']='';
                            $isWoocommerceRequired='No';
                        }

                        //Send data to Aurobees subscription api
                        $api_data=json_encode('apiData');
                        $response=SubscriptionApiProvider::SubScriptionApi($api_data);
                        // return $response;
                        //{"errorCode":"200","errorMessage":"Record Added Successfully","status":"Success"}
                        Log::info('Checkout Transactions page api response auropay: ' . json_encode($response)); // Use an appropriate log level like 'info'
                    }

                    $plan_duration          =   $subscriptionList->plan_duration;
                    if($plan_duration=='MTH'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +30 days'));
                    }elseif($plan_duration=='QTR'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +90 days'));
                    }elseif($plan_duration=='YLY'){
                        $currentDate = date('Y-m-d H:i:s'); // Get the current date
                        $futureDate = date('Y-m-d H:i:s', strtotime($currentDate . ' +365 days'));
                    }else{
                        return redirect()->route('home');
                    }
                    //update subscription
                    $subscription=Subscription::find($subscriptionList->id);
                    $subscription->status='Active';
                    $subscription->start_at=$currentDate;
                    $subscription->end_at=$futureDate;
                    $subscription->save();
                }
                //mail and notification
                SubscriptionNotificationProvider::Notification($subscriptionList->id);
                return view('frontend.new_user.thank-you');
            } catch (ModelNotFoundException $e) {
                // Handle missing transaction gracefully
                Log::error("Transaction not found success Error: {$transactionId}");
                return view('frontend.new_user.payment-error');
            }
        }elseif($result === 'failure' && $refNo && $id){
             try {
                $refArr         = explode('_', $refNo);
                $transactionId  = $refArr[2];

                $transaction = Transaction::findOrFail($transactionId);
                $transaction->status            = 'Failure';
                $transaction->transaction_id    = $id;
                $transaction->payment_mode      = 'auropay';
                $transaction->save();

                if($transaction->subscription_id){
                    $subscription=Subscription::find($transaction->subscription_id);
                    //subscription mail
                    $userEmail=$subscription['User']['email'];
                    $value=new stdClass();
                    $value->f_name=$subscription['User']['f_name'];
                    $value->l_name=$subscription['User']['l_name'];
                    $value->amount= number_format($subscription->grand_amount,2,".","");
                    $value->currency_code=$subscription->currency_code;
                    $value->subscription_name=$subscription['Pricing']['LOB']['title'];
                    $value->plan_name=$subscription->plan_name;
                    $value->plan_duration=$subscription->plan_duration;
                    $value->number_of_user=$subscription->quantity;
                    $value->email=$subscription['User']['email'];
                    $value->phone=$subscription['User']['phone'];

                    $value->transaction_status='Failure';
                    $value->transaction_id=$id;
                    $value->transaction_payment_mode='AuroPay';

                    //email
                    EmailProvider::Email('customer_subscribe_plan_paid_auropay_payment_failed', $userEmail, $value );
                }
                Log::error("Transaction failed: {$id}");
                return view('frontend.new_user.payment-error');
            } catch (ModelNotFoundException $e) {
                // Handle missing transaction gracefully
                Log::error("Transaction not failure found : {$id}");
                return view('frontend.new_user.payment-error');
            }
        } else {
            Log::error("Transaction result not found: {$refNo}");
            return view('frontend.new_user.payment-error');
        }
    }
}
