<?php

namespace App\Providers;

use App\Models\FooterMenu;
use App\Models\FooterMenuChild;
use App\Models\FooterSocialIcons;
use Illuminate\Support\ServiceProvider;
use App\Models\HeaderManagement;
use App\Models\HeaderMenu;
use App\Models\HeaderMenuChild;
use App\Models\HeaderMenuSubChild;
use App\Models\MenuLanguageManagement;
use App\Models\TopHeaderMenu;
use Illuminate\Support\Facades\DB;
use App\Providers\HelperServiceProvider;

class HeaderManagementProvider extends ServiceProvider
{
    public static function HeaderManage(string $key){
        try{
            $dataList=HeaderManagement::where('key',$key)->first();
            if($dataList){
                return $dataList->value;
            }else{
                return ;
            }
        }catch(\Exception $e){
            return ;
        }
    }
    public static function UpdateData(string $key, $value){
        try{
            $dataList=HeaderManagement::where('key',$key)->first();
            $dataList->value=$value;
            $dataList->save();
        }catch(\Exception $e){
            return ;
        }
    }

    public static function FooterSocialIconsData(){
        try{
            $datas=FooterSocialIcons::all();
            return $datas;
        }catch(\Exception $e){
            return ;
        }
    }
    //only generate link
    public static function LinkGenerator($link, $table_id, $table_name,$header_menu_id=''){
        if($link){
            return $link;
        }elseif($table_id && $table_name){
            if($table_name=='industries'){
                if($header_menu_id==4){
                    $slug=DB::select('select slug from '.$table_name.' where id=? and status = ?', [$table_id,'Published']);
                    return route('price.page.view',$slug[0]->slug);
                }elseif($header_menu_id==2){
                    $slug=DB::select('select slug from '.$table_name.' where id=? and status = ?', [$table_id,'Published']);
                    return route('industry.page.view',$slug[0]->slug);
                }else{
                    return '#';
                }
            }elseif($table_name=='go_online_create_websites' || $table_name=='go_online_digital_marketing_services'){
                $slug=DB::select('select slug from '.$table_name.' where id=? and status = ?', [$table_id,'Published']);
                return route('go-online.page.view',$slug[0]->slug);
            }elseif($table_name=='financial_service_business_payment_platforms' || $table_name=='financial_services'){
                $slug=DB::select('select slug from '.$table_name.' where id=? and status = ?', [$table_id,'Published']);
                return route('financial-service.page.view',$slug[0]->slug);
            }
        }elseif($header_menu_id==5){
            return route('become-a-partner.index');
        }else{
            return '#';
        }
    }

    public static function HeaderMenuGet(){
        try{
            $parentList=HeaderMenu::orderBy('order','ASC')->get();
            if(!$parentList->isEmpty()){
                $data='<ul>';
                foreach($parentList as $parent){
                    $childList=HeaderMenuChild::where('header_menu_id',$parent->id)->orderBy('order','ASC')->get();
                    if(!$childList->isEmpty()){
                        $data .='<li class="menu-item-has-children">';
                    }else{
                        $data .='<li class="menu-item">';
                    }
                    $data .='<a href="'.Self::LinkGenerator($parent->link,  '', '',$parent->id).'">'.SELF::MenuLabelManagement('header_menus',$parent->id,$parent->title) .' </a>';
                    if(!$childList->isEmpty()){
                        $class=($parent->id==3)?'col-md-12 half-row':'col-md-6';
                        $megha_meuclass=($parent->id==3)?'':'megha_meu';
                        $data .='<div class="sub__menu '.$megha_meuclass.'">';
                        $data .='<div class="row">';
                        foreach($childList as $child){
                            $subChildList=HeaderMenuSubChild::where('header_menu_id',$parent->id)->where('header_menu_child_id',$child->id)->orderBy('order','ASC')->get();
                            if(!$subChildList->isEmpty()){
                                $data .='<div class="links__title col-md-12"><h4>'.SELF::MenuLabelManagement('header_menu_children',$child->id,$child->title).'</h4></div>';
                                foreach($subChildList as $subChild){
                                    $data .='<div class="col-md-6">
                                        <div class="service__links">
                                            <div class="services_icon">
                                                <img src="'.url($subChild->icon).'" alt="img">
                                            </div>
                                            <div class="services_description">
                                                <a href="'.Self::LinkGenerator($subChild->link,  $subChild->table_id, $subChild->table_name,$subChild->header_menu_id).'">
                                                    <h4>'.SELF::MenuLabelManagement('header_menu_sub_children',$subChild->id,$subChild->title).'</h4>
                                                    <p>'.SELF::MenuLabelManagement('header_menu_sub_children',$subChild->id,$subChild->description,'description').'</p>
                                                </a>
                                            </div>
                                        </div>
                                    </div>';
                                }
                            }else{
                                $data .='<div class="'.$class.'">
                                    <div class="service__links">
                                        <div class="services_icon">
                                            <img src="'.url($child->icon).'" alt="img">
                                        </div>
                                        <div class="services_description">
                                            <a href="'.Self::LinkGenerator($child->link,  $child->table_id, $child->table_name).'">
                                                <h4>'.SELF::MenuLabelManagement('header_menu_children',$child->id,$child->title).'</h4>
                                                <p>'.SELF::MenuLabelManagement('header_menu_children',$child->id,$child->description,'description').'</p>
                                            </a>
                                        </div>
                                    </div>
                                </div>';
                            }
                        }
                        $data .='</div>';
                        $data .='</div>';
                    }
                    $data .='</li>';
                }
                $data .='</ul>';
            }
            return @$data;
        }catch(\Exception $e){
            return ;
        }
    }

    public static function TopHeaderMenu(){
        try{
            $parentList=TopHeaderMenu::orderBy('order','ASC')->get();
            if(!$parentList->isEmpty()){
                $data='<ul class="top_links">';
                foreach($parentList as $parent){
                    $data .='<li><a href="'.$parent->link.'"><img src="'.url($parent->icon).'" alt="img"> '.SELF::MenuLabelManagement('top_header_menus',$parent->id,$parent->title).'</a></li>';
                }
                $data .='</ul>';
            }
            return @$data;
        }catch(\Exception $e){
            return ;
        }
    }
    //oly link generate
    public static function LinkGeneratorFooter($link, $table_id, $table_name,$header_menu_id=''){
        if($link){
            return $link;
        }elseif($table_id && $table_name){
            if($table_name=='industries'){
                $slug=DB::select('select slug from '.$table_name.' where id=? and status = ?', [$table_id,'Published']);
                return route('industry.page.view',$slug[0]->slug);
            }elseif($table_name=='go_online_create_websites' || $table_name=='go_online_digital_marketing_services'){
                $slug=DB::select('select slug from '.$table_name.' where id=? and status = ?', [$table_id,'Published']);
                return route('go-online.page.view',$slug[0]->slug);
            }elseif($table_name=='financial_service_business_payment_platforms' || $table_name=='financial_services'){
                $slug=DB::select('select slug from '.$table_name.' where id=? and status = ?', [$table_id,'Published']);
                return route('financial-service.page.view',$slug[0]->slug);
            }
        }else{
            return '#';
        }
    }
    public static function FooterMenu(){
        try{
            $parentList=FooterMenu::orderBy('order','ASC')->get();
            if(!$parentList->isEmpty()){
                $data ='<div class="row">';
                foreach($parentList as $parent){
                    $data .='<div class="col-md-3">
                                <div class="footer__content">';
                    $data .='<h4>'.SELF::MenuLabelManagement('footer_menus',$parent->id,$parent->title).'</h4>';
                    $childList=FooterMenuChild::where('footer_menu_id',$parent->id)->orderBy('order','ASC')->get();
                    if(!$childList->isEmpty()){
                        $data .='<ul class="footer_links">';
                        foreach($childList as $child){
                            $data .='<li><a href="'.Self::LinkGeneratorFooter($child->link,  $child->table_id, $child->table_name).'"><span><img src="'.url($child->icon).'" alt="img"></span> '.SELF::MenuLabelManagement('footer_menu_children',$child->id,$child->title).'</a></li>';
                        }
                        $data .='</ul>';
                    }
                    $data .= '</div>
                    </div>';
                }
            }
            return @$data;
        }catch(\Exception $e){
            return ;
        }
    }

    public static function MenuLabelManagement($table_name, $table_id,$text='',$title=''){
        $language=HelperServiceProvider::DefaultLanguage();
        $data=MenuLanguageManagement::where('table',$table_name)->where('table_id',$table_id)->where('language',$language)->first();
        if($data){
            if($title=='description'){
                return $data->description;
            }else{
                return $data->title;
            }
        }
        return $text;
    }
}
