<?php

namespace App\Providers;

use App\Models\CustomerDetail;
use App\Models\CustomerNotification;
use App\Models\PricingAddonesPrice;
use Illuminate\Support\ServiceProvider;
use GoogleTranslate;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\PostLike;
use Stevebauman\Location\Facades\Location;
use App\Models\LabelManagement;
use App\Models\LabelManagementValue;
use App\Models\Language;
use App\Models\ForgotPasswordPageManagement;
use Exception;

class HelperServiceProvider extends ServiceProvider
{
    public static function ChangeLanguage(string $value){
        if($value){
            // return GoogleTranslate::trans($value, app()->getLocale());
            return $value;
        }else{
            return '';
        }
    }
    public static function GetAllActiveLanguage(){
        $lists=Language::where('status','Active')->get();
        return $lists;
    }

    public static function DefaultLanguage(){
        if(Cookie::get('language_select')){
            $language =Cookie::get('language_select');
        }else{
            $language='en';
        }
        return $language;
    }

    public static function GetLanguageText($key){
        try{
            if(Cookie::get('language_select')){
                $language =Cookie::get('language_select');
            }else{
                $language='en';
            }
            $data=LabelManagementValue::where('key',$key)->where('language',$language)->first();
            if(!$data){
                $data=LabelManagement::where('key',$key)->first();
            }
            if($data){
                return $data->value;
            }
            return ;
        }catch(\Exception $e){
            return ;
        }
    }

    public static function DefaultCountry($request){
        try{
            $ip = $request->ip();
            // $ip = '45.143.82.221';
            $data = Location::get($ip)->countryCode;
            return $data;
        }catch(\Exception $e){
            return 'Other';
        }
    }

    public static function DefaultCurrency(){
        if(Cookie::get('currency_select')){
            $language =Cookie::get('currency_select');
        }else{
            $language='INR';
        }
        return $language;
    }

    //checkout page
    public static function CheckoutPage($title){
        $PlanData=Session::get('CheckoutPageOldData');
        $name='';
        if(Session::has('CheckoutPageOldData')){
            $datas= json_decode(@$PlanData);
            $name=@$datas->$title;
        }
        if(Session::has('CheckoutPageOldData') && $name ){
            return @$datas->$title;
        }elseif(old($title)){
            return old($title);
        }elseif(Auth::user()->$title){
            return Auth::user()->$title;
        }else{
            if($title=='company_name'){ $title='company';}
            if($title=='address_1'){ $title='address';}
            if($title=='address_2'){ $title='address';}
            if(Auth::user()->$title){
                return Auth::user()->$title;
            }else{
                if($title=='billing_address_1'){ $title='billing_address';}
                if($title=='billing_address_2'){ $title='billing_address';}

                $customerDetail=CustomerDetail::where('user_id',Auth::user()->id)->first();
                if(@$customerDetail && @$customerDetail->$title){
                    return $customerDetail->$title;
                }else{
                    return '';
                }
            }
        }
    }


    public static function PostLikeCount(int $value){
        return PostLike::where('post_id',$value)->count();
    }

    public static function CheckUserLike(int $value){
        if(Auth::user()->id){
            $data= PostLike::where('post_id',$value)->where('user_id',Auth::user()->id)->count();
            if($data){ return 'fas fa-heart';}else{ return 'far fa-heart';}
        }else{
            return 'far fa-heart';
        }
    }

    public static function Prev12Month(){
        // Set the start date to August 2022
        $cDate = date('Y-m-d');

        // Get the date one year back from the current date
        $startDate = date('Y-m-d', strtotime('-11 month', strtotime($cDate)));


        // Get the current month and year
        $currentMonth = date('n');
        $currentYear = date('Y');

        // Initialize an array to store the month data
        $monthsData = array();

        // Generate the data for the next 12 months
        for ($i = 0; $i < 12; $i++) {
            // Calculate the month and year for each iteration
            $monthYear = date('Y-m', strtotime("$startDate +$i months"));
            $month = date('n', strtotime($monthYear));
            $year = date('Y', strtotime($monthYear));

            // Get the full month name using the date function
            $monthName = date('F', strtotime("$year-$month-01"));

            // Get the numeric representation of the month
            $monthNumber = $month;

            // Get the first and last day of the month
            $firstDay = date('Y-m-01', strtotime("$year-$month-01"));
            $lastDay = date('Y-m-t', strtotime("$year-$month-01"));

            // Add the month details to the array
            $monthsData[] = array(
                'name' => $monthName,
                'number' => $monthNumber,
                'f_date' => $firstDay,
                'l_date' => $lastDay
            );
        }

        // Display the month data or use it as needed
        return $monthsData;
    }

    //Show Customer Notification Data
    public static function ShowCustomerNotificationDatas(){
        if(Auth::check()){
            $notifications= CustomerNotification::where('user_id',Auth::user()->id)->where('status','0')->orderBy('id', 'desc')->get();
            $total_notification=CustomerNotification::where('user_id',Auth::user()->id)->where('status','0')->count();
            $list=array();
            $list['notifications']=$notifications;
            $list['total_notification']=$total_notification;
            return $list;
        }else{
            return '';
        }
    }

    public static function GetProductAddonePrice($country_code, $addone_id, $plan_type){
        try{
            $data=PricingAddonesPrice::where('pricing_addon_id', $addone_id)->where('plan_type', $plan_type)->where('country_code', $country_code)->first();
            return $data;
        }catch(\Exception $e){
            return ;
        }
    }

    public static function ForgotPasswordPageManagement($key){
        try{
            $data= ForgotPasswordPageManagement::where('key', $key)->first();
            return ($data)?$data->value:'';
        }catch(\Exception $e){
            return ;
        }
    }
}
