<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\PartnerDetailMetaData;
use App\Models\PartnerNotification;
use Illuminate\Support\Facades\Log;

class PartnerRegistrationProvider extends ServiceProvider
{
    public static function PartnerRegistration(string $value){
        try{
            if(old($value)){
                return old($value);
            }else{
                $user_id=Session::get('partner_registration_id');
                if($user_id && $value){
                    $user_data=User::find($user_id);
                    if(@$user_data->$value){
                        return @$user_data->$value;
                    }else{
                        $data=PartnerDetailMetaData::where('user_id',$user_id)->where('key',$value)->first();
                        return @$data->value;
                    }
                }else{
                    return '';
                }
            }
        }catch(\Exception $e){
            Log::error('Partner Registration Provider Error :'.$e);
            return '';
        }
    }

    public static function PartnerRegistrationReject(){
        try{
            $user_id='';
            if(Auth::check()){
                $user_id=Auth::user()->id;
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify','Reject')->get();
                    return @$datas;
                }
            }else{
                $user_id=Session::get('partner_registration_id');
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify','Reject')->get();
                    return @$datas;
                }else{
                    return '';
                }
            }
        }catch(\Exception $e){
            Log::error('Partner Registration Provider Error :'.$e);
            return '';
        }
    }

    public static function PartnerRegistrationCompleted(){
        try{
            $user_id='';
            if(Auth::check()){
                $user_id=Auth::user()->id;
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify','Approve')->count();
                    return (@$datas==0)?true:false;
                }
            }else{
                $user_id=Session::get('partner_registration_id');
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify','Approve')->count();
                    return (@$datas==0)?true:false;
                }else{
                    return '';
                }
            }
        }catch(\Exception $e){
            Log::error('Partner Registration Provider Error :'.$e);
            return '';
        }
    }

    public static function PartnerRegistrationUnderProcess(){
        try{
            $user_id='';
            if(Auth::check()){
                $user_id=Auth::user()->id;
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify',NULL)->count();
                    return (@$datas==0)?true:false;
                }
            }else{
                $user_id=Session::get('partner_registration_id');
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify',NULL)->count();
                    return (@$datas==0)?true:false;
                }else{
                    return '';
                }
            }
        }catch(\Exception $e){
            Log::error('Partner Registration Provider Error :'.$e);
            return '';
        }
    }

    public static function PartnerRegistrationRejectStatus(){
        try{
            $user_id='';
            if(Auth::check()){
                $user_id=Auth::user()->id;
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify','Reject')->count();
                    return (@$datas==0)?true:false;
                }
            }else{
                $user_id=Session::get('partner_registration_id');
                if($user_id){
                    $datas=PartnerDetailMetaData::where('user_id',$user_id)->where('key','!=','partner_contract')->where('verify','Reject')->count();
                    return (@$datas==0)?true:false;
                }else{
                    return '';
                }
            }
        }catch(\Exception $e){
            Log::error('Partner Registration Provider Error :'.$e);
            return '';
        }
    }
    
    public static function PartnerNotification(){
        if(Auth::check()){
            $notifications= PartnerNotification::where('user_id',Auth::user()->id)->where('status','0')->orderBy('id','DESC')->get();
            $total_notification=PartnerNotification::where('user_id',Auth::user()->id)->where('status','0')->count();
            $list=array();
            $list['notifications']=$notifications;
            $list['total_notification']=$total_notification;
            return $list;
        }else{
            return '';
        }
    }
    
    public static function CheckStatus(){
        if(Auth::check()){
            $datas=PartnerDetailMetaData::where('user_id', Auth::user()->id)->where('key','partner_contract')->where('verify','Approve')->count();
            if($datas>0){
                $data1=PartnerDetailMetaData::where('user_id', Auth::user()->id)->where('verify','!=','Approve')->count();
                if($data1==0){
                    return true;
                }
            }
            return false;
        }else{
            return false;
        }
    }

    public static function GetParentData($key, $user_id){
        try{
            $data=PartnerDetailMetaData::where('user_id',$user_id)->where('key',$key)->first();
            return @$data->value;
        }catch(\Exception $e){
            return '';
        }
    }
}
