<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\User;

class PartnerCodeCheck implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        $currentDate=date('Y-m-d');
        $emailCheck=User::where('code',$value)->where('role','Partner')->where('status','N')->where('is_email_verified','1')->where('agreement_to_date','>',$currentDate)->count();
        if($emailCheck>0){
            return true;
        }
        return false;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Partner code doesn\'t exist.';
    }
}
