<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pricing_addons', function (Blueprint $table) {
            $table->id();
            $table->integer('pricing_id')->comment('Price Table(pricings) id');
            $table->integer('pricing_features_id')->comment('Price Feature Table(pricing_features) id');
            $table->string('name')->nullable();
            $table->string('free_trial')->nullable();
            $table->string('basic')->nullable();
            $table->string('advance')->nullable();
            $table->string('go_ecommerce')->nullable();
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pricing_addons');
    }
};
