<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('plan_pricings', function (Blueprint $table) {
            $table->id();
            $table->integer('price_id')->comment('Price Table(pricing) id')->index();
            $table->string('plan_type')->nullable();
            $table->string('country_code')->nullable();
            $table->string('country_name')->nullable();
            $table->string('currency')->nullable();
            $table->float('monthly')->nullable();
            $table->float('quaterly')->nullable();
            $table->float('yearly')->nullable();
            $table->integer('no_of_order')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('plan_pricings');
    }
};
