<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('financial_service_business_payment_platforms', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('default_language_page')->nullable();
            $table->string('image_1')->nullable();
            $table->string('title')->nullable();
            $table->string('slug')->nullable();
            $table->string('sub_title')->nullable();
            $table->longText('description')->nullable();
            $table->string('image_2')->nullable();
            $table->string('key_benefits_title')->nullable();
            $table->string('key_benefits_1')->nullable();
            $table->string('key_benefits_2')->nullable();
            $table->string('key_benefits_3')->nullable();
            $table->string('key_benefits_4')->nullable();
            $table->string('key_benefits_5')->nullable();
            $table->string('button_text')->nullable();
            $table->string('button_link')->nullable();
            
            $table->string('language')->default('en')->index();
            $table->string('meta_key')->nullable();
            $table->string('meta_title')->nullable();
            $table->longText('meta_description')->nullable();
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('financial_service_business_payment_platforms');
    }
};
