<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->integer('sl_no')->index()->comment('Per Year Subscription no');
            $table->string('serial_number')->index()->comment('Subscription serial number');
            $table->integer('user_id')->index()->comment('User Table(users) id');
            $table->integer('plan_id')->index()->comment('Lob Table(pricings) id');
            $table->enum('plan_name',['Free-Trial','Basic','Advance','Ecommerce'])->default('Free-Trial');
            $table->string('plan_duration')->nullable();
            $table->string('country_code')->nullable();
            $table->string('currency_code')->nullable();
            $table->float('plan_rate')->default(0)->comment('per user plan cost');
            $table->float('addon_rate')->default(0)->comment('per user plan addon cost');
            $table->float('rate')->default(0)->comment('per user plan & addon cost');
            $table->integer('quantity')->comment('no. of user')->default(1);
            $table->float('plan_total_rate')->default(0)->comment('Total amount quantity*plan_rate ');
            $table->float('addon_total_rate')->default(0)->comment('Total amount quantity*addon_rate ');
            $table->float('total_rate')->default(0)->comment('Total amount plan_total_rate + addon_total_rate ');
            $table->float('tax')->default(0);
            $table->float('tax_percentage')->default(0);
            $table->string('tax_name')->nullable();
            $table->float('grand_amount')->default(0)->comment('total_rate + tax ');
            $table->float('partner_commission_percentage')->default(0)->comment('partner commission percentage');
            $table->float('partner_commission_amount')->default(0)->comment('partner commission amount');

            $table->enum('payment_mode',['Online','Offline','auropay'])->default('Offline');
            $table->longText('remarks')->nullable();
            $table->dateTime('start_at')->comment('subscription start date')->nullable();
            $table->dateTime('end_at')->comment('subscription end date')->nullable();
            $table->enum('status',['Active','Canceled','Pending','Processing'])->comment('Processing')->comment('Active=Success, Canceled=Canceled by admin,Pending=Payment Pending')->index();
            $table->enum('upgrade_status',['0','1'])->default('0')->comment('0=not upgrade, 1=upgrade/paid')->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('subscriptions');
    }
};
