<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('event_dates', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('default_language_page')->nullable();
            $table->string('title')->nullable();
            $table->longText('description')->nullable();
            $table->string('pdf')->nullable();

            $table->enum('media_type',['Image','Video'])->nullable();
            $table->string('image')->nullable();
            $table->enum('video_type',['MP4','Youtube'])->nullable();
            $table->string('video')->nullable();
            $table->string('thumbnail_image')->nullable();
            $table->longText('youtube')->nullable();
            $table->dateTime('datetime')->nullable();
            $table->integer('duration')->nullable();
            $table->string('meeting_type')->nullable();
            $table->text('meeting_link')->nullable();

            $table->text('zoom_start_url')->nullable();
            $table->text('zoom_join_url')->nullable();
            $table->text('zoom_id')->nullable();
            $table->text('zoom_password')->nullable();

            $table->string('language')->default('en');
            $table->enum('status',['Published','Draft','Trash'])->default('Published');
            $table->integer('created_by')->nullable();
            $table->integer('updated_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('event_dates');
    }
};
