<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('partner_detail_meta_data', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_id')->index()->comment('Users Table id');
            $table->string('key');
            $table->longText('value')->nullable();
            $table->enum('verify',['Approve','Reject'])->nullable();
            $table->longText('remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('partner_detail_meta_data');
    }
};
