@php
    $header_title = 'Aurobees | Post Management | Post';
    $header_name = 'post';
    $page_name = 'user_post';
@endphp
@extends('admin.admin_master')
@section('admin')
<!-- <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script> -->
<style>
    .select2-container .select2-selection--single {
       height: 37px !important;
   }
</style>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Post</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Post</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">All Posts</h3>
                            <div style="float: right"><a href="{{route('post.addnew')}}" class="btn btn-primary btn-rounded">Add New</a></div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            {{-- <div class="form-group">
                                <label>Category</label>
                                <select id="blog_category_id" class="form-control select2" style="width: 100%;height:37px;">
                                    <option value="All">All</option>
                                        @foreach($categorys as $key=> $category)
                                            <option value="{{ $category->id }}">{{ $category->name }}</option>
                                        @endforeach;
                                </select>
                                @error('blog_category_id')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div> --}}
                            <table id="daterange_table" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Title</th>
                                        <th>Date</th>
                                        <th>Status</th>
                                        <th style="min-width: 170px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="blog_category_body">
                                    
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
@section('script')
    {{-- <script>
        $('#blog_category_id').on('change', function (e) {
            e.preventDefault();
            $.ajax({
                type: 'get',
                url: "{{route('post.getCategory')}}",
                data:{ id:$(this).val()},
                success: function (data) {
                $('#blog_category_body').html('');
                $('#blog_category_body').append(data);
                }
            });
        });
    </script> --}}

    <script>
        $(function () {
            var table = $('#daterange_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('post.list') }}"
                },
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },  // Row index (key + 1)
                    { data: 'post_title', name: 'post_title' },  
                    { data: 'created_at', name: 'created_at' }, 
                    { data: 'post_status', name: 'post_status' },
                    { data: 'action', name: 'action', orderable: false, searchable: false }  // Action buttons (Edit, Gallery, Delete)
                ]
            });
        });
    </script>
@endsection

