@php
$type_name=ucfirst($type);
$header_title="Aurobees | $type_name Management | Category";
$header_name = $type;
$page_name = $type.'_category';
@endphp
@extends('admin.admin_master')
@section('admin')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?=@$type_name?> Category</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                        @if($type=='post')
                            <li class="breadcrumb-item"><a href="{{route('post.list')}}"><?=@$type_name?></a></li>
                        @elseif($type=='news')
                            <li class="breadcrumb-item"><a href="{{route('latest-news.list')}}"><?=@$type_name?></a></li>
                        @endif
                        <li class="breadcrumb-item active"> Category</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content-header -->
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">List All <?=@$type_name?> Category</h3>
                            <div style="float: right"><a href="{{route('user.blog.category.add',$type)}}" class="btn btn-primary btn-rounded">Add New</a></div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Name</th>
                                        <th>Created By</th>
                                        <th>Created Datetime</th>
                                        <th style="min-width: 100px;">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($datas as $key => $data)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td>{{ $data->name }}</td>
                                        <td>{{ $data['CreatedBy']['f_name'] }}</td>
                                        <td>{{ $data->created_at }}</td>
                                        <td>
                                            <a href="{{route('user.blog.category.edit',[$type, $data->id])}}" class="btn btn-round btn-info"><i class="fas fa-edit"></i></a>
                                            @if($data->status=='Trash')
                                                <a href="{{ route('user.blog.category.delete',[$type, $data->id]) }}" onclick="return confirm('Are you sure you want to delete this item?');" class="btn btn-outline-danger"  title="Permanently delete"><i class="fas fa-trash"></i></a>
                                            @else
                                                <a href="{{ route('user.blog.category.delete',[$type, $data->id]) }}" onclick="return confirm('Are you sure you want to trash this item?');" class="btn btn-outline-warning" title="Trash Item"><i class="fas fa-trash"></i></a>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection
