@php
$header_title="Aurobees | Customer Management | Customer";
$header_name = 'customer_management';
$page_name = 'customer';
@endphp
@extends('admin.admin_master')
@section('admin')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Customer</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('dashboard')}}">Dashboard</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('admin.customer.view')}}">Customer Management</a></li>
                            <li class="breadcrumb-item active">View</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content-header -->
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">View User Details</h3>
                            </div>
                            <!-- /.card-header -->
                            <div class="card-body">
                                <table class="table table-striped">
                                    <tbody>
                                        <tr>
                                            <th>Code</th>
                                            <td>{{ $data->code }}</td>
                                        </tr>
                                        <tr>
                                            <th>Partner Code</th>
                                            <td>{{ $data->partner_code }}</td>
                                        </tr>
                                        <tr>
                                            <th>First Name</th>
                                            <td>{{ $data->f_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Last Name</th>
                                            <td>{{ $data->l_name }}</td>
                                        </tr>
                                        <tr>
                                            <th>Phone</th>
                                            <td>{{ $data->phone }}</td>
                                        </tr>
                                        <tr>
                                            <th>Email</th>
                                            <td>{{ $data->email }}</td>
                                        </tr>
                                        <tr>
                                            <th>Company Name</th>
                                            <td>{{ $data->company }}</td>
                                        </tr>
                                        @if($data['Country'])
                                            <tr>
                                                <th>Country</th>
                                                <td>{{ $data['Country']['name'] }}</td>
                                            </tr>
                                        @endif
                                        @if($data['State'])
                                        <tr>
                                            <th>State</th>
                                            <td>{{ $data['State']['name'] }}</td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th>City</th>
                                            <td>{{ $data->city }}</td>
                                        </tr>
                                        <tr>
                                            <th>Address</th>
                                            <td>{{ $data->address }}</td>
                                        </tr>
                                        <tr>
                                            <th>Pincode</th>
                                            <td>{{ $data->pincode }}</td>
                                        </tr>
                                        <tr>
                                            <th>International Calling Code</th>
                                            <td>{{ '('.$data['CallingCode']['code'].')'. $data['CallingCode']['name']}}</td>
                                        </tr>
                                        <tr>
                                            <th>Active Customer</th>
                                            <td>{{ ($data->status=='N')?'Yes':'No' }}</td>
                                        </tr>
                                        <tr>
                                            <th>Email verified</th>
                                            <td>{{ ($data->is_email_verified=='1')?'Yes':'No' }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr>
                                <center><a href="{{ route('admin.customer.view') }}" class="btn btn-round btn-primary">Back</a></center>
                            </div>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.card -->
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
@endsection
