<?php
function convertToWords($number) {
    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $decimal     = ' Rupees and ';
    $dictionary  = array(
        0   => 'Zero',
        1   => 'One',
        2   => 'Two',
        3   => 'Three',
        4   => 'Four',
        5   => 'Five',
        6   => 'Six',
        7   => 'Seven',
        8   => 'Eight',
        9   => 'Nine',
        10  => 'Ten',
        11  => 'Eleven',
        12  => 'Twelve',
        13  => 'Thirteen',
        14  => 'Fourteen',
        15  => 'Fifteen',
        16  => 'Sixteen',
        17  => 'Seventeen',
        18  => 'Eighteen',
        19  => 'Nineteen',
        20  => 'Twenty',
        30  => 'Thirty',
        40  => 'Forty',
        50  => 'Fifty',
        60  => 'Sixty',
        70  => 'Seventy',
        80  => 'Eighty',
        90  => 'Ninety',
        100 => 'Hundred',
        1000 => 'Thousand',
        100000 => 'Lakh',
        10000000 => 'Crore'
    );

    if (!is_numeric($number)) {
        return false;
    }

    $number = number_format((float)$number, 2, '.', ''); // Ensure 2 decimal places

    list($integerPart, $fractionPart) = explode('.', $number);

    $string = convertNumberToWords($integerPart, $dictionary, $hyphen, $conjunction, $separator);
    $string .= " Rupees";

    if ($fractionPart > 0) {
        $paise = (int) $fractionPart;
        $string .= " and " . convertNumberToWords($paise, $dictionary, $hyphen, $conjunction, $separator) . " Paise";
    }

    $string .= " Only";
    return $string;
}

function convertNumberToWords($number, $dictionary, $hyphen, $conjunction, $separator) {
    if ($number == 0) {
        return $dictionary[0];
    }

    $string = '';

    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens   = ((int)($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds  = (int)($number / 100);
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convertNumberToWords($remainder, $dictionary, $hyphen, $conjunction, $separator);
            }
            break;
        case $number < 100000:
            $thousands  = (int)($number / 1000);
            $remainder = $number % 1000;
            $string = convertNumberToWords($thousands, $dictionary, $hyphen, $conjunction, $separator) . ' ' . $dictionary[1000];
            if ($remainder) {
                $string .= $separator . convertNumberToWords($remainder, $dictionary, $hyphen, $conjunction, $separator);
            }
            break;
        case $number < 10000000:
            $lakhs  = (int)($number / 100000);
            $remainder = $number % 100000;
            $string = convertNumberToWords($lakhs, $dictionary, $hyphen, $conjunction, $separator) . ' ' . $dictionary[100000];
            if ($remainder) {
                $string .= $separator . convertNumberToWords($remainder, $dictionary, $hyphen, $conjunction, $separator);
            }
            break;
        default:
            $crores  = (int)($number / 10000000);
            $remainder = $number % 10000000;
            $string = convertNumberToWords($crores, $dictionary, $hyphen, $conjunction, $separator) . ' ' . $dictionary[10000000];
            if ($remainder) {
                $string .= $separator . convertNumberToWords($remainder, $dictionary, $hyphen, $conjunction, $separator);
            }
            break;
    }

    return $string;
}

?>
@php $orderMetaData=[]; @endphp
@if($orderMeta)
    @foreach ($orderMeta as $item )
        @php $orderMetaData[$item->key]=$item->value; @endphp
    @endforeach
@endif

<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tax Invoice</title>
</head>
<body style="width:943px; margin:0 auto;">
    <table style="width: 99%; border-collapse: collapse; font-family: Arial, sans-serif;">
        <tbody>
            <tr style="border-bottom: 1px solid #000">
                <td style="padding: 5px 5px 0 5px;" colspan="2">
                    <a href="https://www.aurobees.com/" target="_blank"><img src="img/Aurobees-logo.png" ></a>
                </td>

                <td style="padding: 5px 5px 0 5px; text-align: right;" colspan="2">
                    an <strong>aurionpro</strong> Product
                </td>
            </tr>

        </tbody>
    </table>

    <table style="width: 99%; border-collapse: collapse; font-family: Arial, sans-serif;">
        <tbody>
            <tr>
                <td style="padding: 5px 5px 20px 0; text-align: center" colspan="2">
                    <strong style="text-transform: uppercase; width: 100%;">tax invoice</strong>
                </td>
            </tr>

        </tbody>
    </table>

    <table style="width: 99%; border-collapse: collapse; font-family: Arial, sans-serif; border: 1px solid #000; box-sizing: border-box;">
        <tbody>
            <tr>
                <td style="padding: 0px;border: 1px solid #000;line-height: 20px;width: 50%;border-bottom: none;"
                    colspan="8">
                    <strong
                        style="width:98%;display: inline-block;background: grey;color: #fff;padding: 0 5px 0 5px;box-sizing: border-box;">SELLER</strong><br>
                    <p style="margin: 0; padding: 1px 5px 1px 5px;"><strong>Aurionpro Solutions Limited</strong></p>
                    <p style="margin: 0; padding: 1px 5px 1px 5px;">Unit No. 603, Sigma IT Park, Plot No. R-203, R-204,
                        T.T.C. Industrial Estate,
                    </p>
                    <p style="margin: 0; padding: 1px 5px 1px 5px;">Thane Belapur Road, Rabale, Navi Mumbai – 400705,
                        Maharashtra</p>
                    <p style="margin: 0; padding: 1px 5px 1px 5px; ">Phone: <a href="tel:+91-22-40408080"
                            style="text-decoration: none; color: #000;">+91-22-4040 8080</a></p>
                    <p style="margin: 0; padding: 1px 5px 1px 5px;">Fax: +91-22-4040 8081</p>
                    <p style="margin: 0; padding: 1px 5px 15px 5px;">Email: <a href="mailto:ce.enquiries@aurionpro.com"
                            style="text-decoration: none; color: #000;" target="_blank">ce.enquiries@aurionpro.com</a>
                    </p>
                </td>
                <td style="padding: 5px 0px 5px 0px;border-bottom: 1px solid #000;vertical-align: top;width: 50%;"
                    colspan="7">
                    <p style="margin: 0; padding: 1px 5px 5px 5px;"><strong style="font-size: 14px;">INVOICE NO. &amp;
                            DATE</strong></p>
                    <p style="margin: 0; padding: 1px 5px 1px 5px; border-bottom: 1px solid #000"><?=@$data->serial_number ?> <span
                            style="padding-left: 15px;">DATE: <?=date('d-m-Y', strtotime(@$data->created_at)) ?></span></p>
                    <p style="margin: 0; padding: 12px 5px 1px 5px;"><strong>Due Date:</strong></p>
                </td>
            </tr>
            <tr>
                <td style="padding: 0px;border: 1px solid #000;line-height: 20px;width: 50%;vertical-align: top;height: 153px;"
                    colspan="8">
                    <strong
                        style="width: 98%;display: inline-block;background: grey;color: #fff;padding: 0 5px 0 5px;box-sizing: border-box;">CUSTOMER</strong><br>
                    <p style="margin: 0; padding: 1px 5px 1px 5px;"><strong><?=@$orderMetaData['billing_company_name']?></strong></p>
                    <p style="margin: 0; padding: 1px 5px 1px 5px;"><?=@$orderMetaData['billing_address_1']?></p>
                    <p style="margin: 0; padding: 1px 5px 1px 5px;">
                        <?=@$orderMetaData['billing_city']?>, 
                        <?=@$orderMetaData['billing_state']?> 
                        <?=@$orderMetaData['pincode']?>
                    </p>
                </td>
                <td style="padding: 5px 0px 5px 0px;border-bottom: 1px solid #000;vertical-align: top;width: 50%;" colspan="7">
                    <p style="margin: 0; padding: 4px 5px 1px 5px;"><strong>Transaction Id: <?=@$transaction->transaction_id ?></strong></p>
                </td>
            </tr>
        </tbody>
    </table>

    <table border="1" style="font-size:12px;width: 99%;border-collapse: collapse;font-family: Arial, sans-serif;box-sizing: border-box;border: 1px solid #000;border-top: none;">
        <tbody>
            <tr>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">No</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Subscribed LOB
                </th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Plan</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Duration</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">No. of Users</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Start Date</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">End Date</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Status</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Subn Billing No
                </th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Currency</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Subscription Unit
                    Price</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Net Amount</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Tax Type</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Tax Amount</th>
                <th style="border-right: 1px solid #000; padding: 5px; border-bottom: 1px solid #000">Total Amount</th>
            </tr>
            <tr>
                <td style="padding: 5px;border-right: 1px solid #000;vertical-align: top;height:120px;">1</td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data['Pricing']['LOB']['title'] ?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->plan_name ?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->plan_duration ?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=(@$data->plan_name=='Ecommerce')?1:@$data->quantity ?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=($data->start_at)?date('d/m/Y H:i:s',strtotime($data->start_at)):'Pending'?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=($data->end_at)?date('d/m/Y H:i:s',strtotime($data->end_at)):'Pending'?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->status ?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->serial_number ?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->currency_code ?></td>
                <?php if(@$data->plan_name=='Ecommerce'){
                    $rate=$data->total_rate;
                }else{
                    $rate=round($data->total_rate/$data->quantity, 2);
                }?>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$rate?></td> 
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->total_rate ?></td>
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->tax_name ?></td> 
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->tax ?></td> 
                <td style="padding: 5px; border-right: 1px solid #000; vertical-align: top;"><?=@$data->grand_amount ?></td>
            </tr>
        
    
            <tr>
                <td style="padding: 0px 5px 0px 0;text-align:right;float:right;" colspan="13">
                    <strong style="width: 100%;">Net Amount (<?=@$data->currency_code ?>)</strong>
                </td>
                <td style="padding: 0px 5px 0px 0;text-align: right;float:right;border-left: 1px solid #000;" colspan="2">
                    <strong style="text-transform: uppercase;"><?=@$data->total_rate ?></strong>
                </td>
            </tr>
       
            <tr>
               
                <td style="padding: 0px 5px 0px 0;text-align:right;float:right;" colspan="13">
                    <strong style="width: 100%;">Tax Amount (<?=@$data->currency_code ?>) (<?=@$data->tax_name ?>)</strong>
                </td>
                <td style="padding: 0px 5px 0px 0;text-align: right;float:right;;border-left: 1px solid #000;"
                    colspan="2">
                    <strong style="width: 100%;"><?=@$data->tax ?></strong> 
                </td>
            </tr>
            <tr>
                <td style="padding: 0px 5px 0px 0;text-align:right;float:right;" colspan="13">
                    <strong style="text-transform: uppercase;">gross total (<?=@$data->currency_code ?>)</strong>
                </td>
                <td style="padding: 0px 5px 0px 0;text-align: right;float:right;;border-left: 1px solid #000;"colspan="2">
                    <strong style="text-transform: uppercase;"><?=@$data->grand_amount ?></strong>
                </td>
            </tr>
        </tbody>
    </table>

    <table  border="1"  style="width:99%;border-collapse: collapse;font-family: Arial, sans-serif;">
        <tbody>
            <tr>
                <td style="padding: 5px 5px 20px 5px;text-align: start;" colspan="3">
                    <strong style="text-transform: uppercase; ">
                    </strong>
                    <h3 style="font-weight: 500;font-size: 16px;"><strong style="width: 100%;">Total (In Words)</strong>: <?=convertToWords(@$data->grand_amount);?></h3>
                </td>
            </tr>
            <tr>
                <td style="padding: 5px 5px 0 5px; text-align: center;" colspan="3"><strong>Aurionpro Solutions Limited</strong> </td>
            </tr>
             <tr>
                <td style="padding: 5px 5px 0 5px;text-align: center;" ><strong>Phone:<a
                            href="tel:+91-22-40408080" style="text-decoration: none; color: #000;" target="_blank">
                            +91-22-4040 8080</a></strong>
                </td>
                <td style="padding: 5px 5px 0 5px;text-align: center;"><strong>Fax: +91-22-4040
                        8081</strong>
                </td>
                <td style="padding: 5px 5px 0 5px;text-align: center;"><strong>Email: <a
                            href="mailto:ce.enquiries@aurionpro.com" style="text-decoration: none; color: #000;"
                            target="_blank">ce.enquiries@aurionpro.com</a></strong>
                </td>
            </tr>
        </tbody>
    </table>
    <!--<table style="width: 100%;border-collapse: collapse;font-family: Arial, sans-serif;box-sizing: border-box;border: 1px solid #000;border-top: none;border-bottom: none;">-->
    <!--    <tbody>-->
    <!--        <tr>-->
    <!--            <td style="padding: 5px;width: 50%;" colspan="2">-->
    <!--                <br>-->
    <!--                <p style="margin: 0; padding: 4px 5px 1px 0px;"><strong>CREDIT TO BENEFICIARY:</strong></p>-->
    <!--                <p style="margin: 0; padding: 4px 5px 1px 0px;">Beneficiary Name: INTELLIVISIONS SOFTWARE LLC</p>-->
    <!--                <p style="margin: 0; padding: 4px 5px 1px 0px;">Beneficiary Account No.: 101410882301</p>-->
    <!--                <p style="margin: 0; padding: 4px 5px 1px 0px;">Bank Name: Emirates NBD</p>-->
    <!--                <p style="margin: 0; padding: 4px 5px 1px 0px;">Branch Name: Al Maktoum Branch</p>-->
    <!--                <p style="margin: 0; padding: 4px 5px 1px 0px;">IBAN: AE250260000101410882301</p>-->
    <!--                <p style="margin: 0; padding: 4px 5px 1px 0px;">SWIFT Code: EBILAEAD</p>-->
    <!--            </td>-->
    <!--            <td style="padding: 5px;width: 50%;vertical-align: top;" colspan="2">-->
    <!--                <strong>Remarks:</strong><br>-->
    <!--            </td>-->
    <!--        </tr>-->

    <!--    </tbody>-->
    <!--</table>-->

    <!--<table style="width: 100%;border-collapse: collapse;font-family: Arial, sans-serif;border: 1px solid #000;border-top: none;">-->
    <!--    <tbody>-->
    <!--        <tr>-->
    <!--            <td style="padding: 5px;width: 50%;" colspan="2">-->
    <!--                <strong>Declaration:</strong><br>-->
    <!--                We declare that invoices show the actual price of goods described and that all particulars are true-->
    <!--                and-->
    <!--                correct.-->
    <!--            </td>-->
    <!--            <td style="padding: 5px;width: 50%;border: 1px solid #000;border-bottom: none;" colspan="2">-->
    <!--                <strong>Signature &amp; Rubber Stamp</strong><br>-->
    <!--                <p style="margin: 0;">For Intellivisions Software LLC</p>-->
    <!--                <p style="margin: 40px 0 0 0;">MANAGER</p>-->
    <!--            </td>-->
    <!--        </tr>-->

    <!--    </tbody>-->
    <!--</table>-->

</body>
</html>